/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.ReconnectableSnitchHelper;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ResourceWatcher;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlFileNetworkTopologySnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(YamlFileNetworkTopologySnitch.class);
    private static final int CHECK_PERIOD_IN_MS = 5000;
    static final String DEFAULT_TOPOLOGY_CONFIG_FILENAME = "cassandra-topology.yaml";
    private volatile Map<InetAddress, NodeData> nodeDataMap;
    private volatile NodeData localNodeData;
    private volatile NodeData defaultNodeData;
    private final String topologyConfigFilename;
    private volatile boolean gossiperInitialized = false;

    public YamlFileNetworkTopologySnitch() throws ConfigurationException {
        this(DEFAULT_TOPOLOGY_CONFIG_FILENAME);
    }

    YamlFileNetworkTopologySnitch(String topologyConfigFilename) throws ConfigurationException {
        logger.warn("YamlFileNetworkTopologySnitch is deprecated; switch to GossipingPropertyFileSnitch instead");
        this.topologyConfigFilename = topologyConfigFilename;
        this.loadTopologyConfiguration(false);
        try {
            FBUtilities.resourceToFile(topologyConfigFilename);
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws ConfigurationException {
                    YamlFileNetworkTopologySnitch.this.loadTopologyConfiguration(true);
                }
            };
            ResourceWatcher.watch(topologyConfigFilename, runnable, 5000);
        }
        catch (ConfigurationException e) {
            logger.debug("{} found, but does not look like a plain file. Will not watch it for changes", (Object)topologyConfigFilename);
        }
    }

    @Override
    public String getRack(InetAddress endpoint) {
        NodeData nodeData = this.nodeDataMap.get(endpoint);
        return nodeData != null ? nodeData.rack : this.defaultNodeData.rack;
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        NodeData nodeData = this.nodeDataMap.get(endpoint);
        return nodeData != null ? nodeData.datacenter : this.defaultNodeData.datacenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyConfig readConfig() throws ConfigurationException {
        TopologyConfig topologyConfig;
        TypeDescription topologyConfigTypeDescription = new TypeDescription(TopologyConfig.class);
        topologyConfigTypeDescription.putListPropertyType("topology", Datacenter.class);
        TypeDescription topologyTypeDescription = new TypeDescription(Datacenter.class);
        topologyTypeDescription.putListPropertyType("racks", Rack.class);
        TypeDescription rackTypeDescription = new TypeDescription(Rack.class);
        rackTypeDescription.putListPropertyType("nodes", Node.class);
        Constructor configConstructor = new Constructor(TopologyConfig.class);
        configConstructor.addTypeDescription(topologyConfigTypeDescription);
        configConstructor.addTypeDescription(topologyTypeDescription);
        configConstructor.addTypeDescription(rackTypeDescription);
        InputStream configFileInputStream = this.getClass().getClassLoader().getResourceAsStream(this.topologyConfigFilename);
        if (configFileInputStream == null) {
            throw new ConfigurationException("Could not read topology config file " + this.topologyConfigFilename);
        }
        try {
            Yaml yaml = new Yaml((BaseConstructor)configConstructor);
            topologyConfig = (TopologyConfig)yaml.load(configFileInputStream);
        }
        finally {
            FileUtils.closeQuietly(configFileInputStream);
        }
        return topologyConfig;
    }

    private synchronized void loadTopologyConfiguration(boolean isUpdate) throws ConfigurationException {
        logger.debug("Loading topology configuration from {}", (Object)this.topologyConfigFilename);
        this.loadTopologyConfiguration(isUpdate, this.readConfig());
    }

    @VisibleForTesting
    synchronized void loadTopologyConfiguration(boolean isUpdate, TopologyConfig topologyConfig) throws ConfigurationException {
        HashMap<InetAddress, NodeData> nodeDataMap = new HashMap<InetAddress, NodeData>();
        if (topologyConfig.topology == null) {
            throw new ConfigurationException("Topology configuration file is missing the topology section");
        }
        for (Datacenter datacenter : topologyConfig.topology) {
            if (datacenter.dc_name == null) {
                throw new ConfigurationException("Topology configuration file is missing a data center name for some data center");
            }
            for (Rack rack : datacenter.racks) {
                if (rack.rack_name == null) {
                    throw new ConfigurationException(String.format("Topology configuration file is missing a rack name for some rack under data center '%s'", datacenter.dc_name));
                }
                for (Node node : rack.nodes) {
                    if (node.broadcast_address == null) {
                        throw new ConfigurationException(String.format("Topology configuration file is missing a broadcast address for some node under data center '%s' rack '%s'", datacenter.dc_name, rack.rack_name));
                    }
                    InetAddress endpoint = InetAddresses.forString((String)node.broadcast_address);
                    InetAddress dcLocalAddress = node.dc_local_address == null ? null : InetAddresses.forString((String)node.dc_local_address);
                    NodeData nodeData = new NodeData();
                    nodeData.datacenter = datacenter.dc_name;
                    nodeData.rack = rack.rack_name;
                    nodeData.dcLocalAddress = dcLocalAddress;
                    if (nodeDataMap.put(endpoint, nodeData) != null) {
                        throw new ConfigurationException(String.format("IP address '%s' appears more than once in the topology configuration file", endpoint));
                    }
                    if (dcLocalAddress == null || nodeDataMap.put(dcLocalAddress, nodeData) == null) continue;
                    throw new ConfigurationException(String.format("IP address '%s' appears more than once in the topology configuration file", dcLocalAddress));
                }
            }
        }
        NodeData localNodeData = (NodeData)nodeDataMap.get(FBUtilities.getBroadcastAddress());
        if (localNodeData == null) {
            throw new ConfigurationException("Topology configuration missing information for the local node");
        }
        NodeData defaultNodeData = new NodeData();
        if (topologyConfig.default_dc_name == null) {
            throw new ConfigurationException("default_dc_name must be specified");
        }
        if (topologyConfig.default_rack_name == null) {
            throw new ConfigurationException("default_rack_name must be specified");
        }
        defaultNodeData.datacenter = topologyConfig.default_dc_name;
        defaultNodeData.rack = topologyConfig.default_rack_name;
        if (isUpdate && !this.livenessCheck(nodeDataMap, defaultNodeData)) {
            return;
        }
        this.nodeDataMap = nodeDataMap;
        this.localNodeData = localNodeData;
        this.defaultNodeData = defaultNodeData;
        this.maybeSetApplicationState();
        if (logger.isDebugEnabled()) {
            logger.debug("Built topology map from config file: localNodeData={}, nodeDataMap={}", (Object)localNodeData, nodeDataMap);
        }
        if (this.gossiperInitialized) {
            StorageService.instance.gossipSnitchInfo();
        }
        if (isUpdate && StorageService.instance != null) {
            StorageService.instance.updateTopology();
        }
    }

    private boolean livenessCheck(Map<InetAddress, NodeData> reloadedMap, NodeData reloadedDefaultData) {
        Sets.SetView hosts = NodeData.isSameDcRack(this.defaultNodeData, reloadedDefaultData) ? Sets.intersection(StorageService.instance.getLiveRingMembers(), (Set)Sets.union(this.nodeDataMap.keySet(), reloadedMap.keySet())) : StorageService.instance.getLiveRingMembers();
        for (InetAddress host : hosts) {
            NodeData updateValue;
            NodeData origValue = this.nodeDataMap.containsKey(host) ? this.nodeDataMap.get(host) : this.defaultNodeData;
            if (NodeData.isSameDcRack(origValue, updateValue = reloadedMap.containsKey(host) ? reloadedMap.get(host) : reloadedDefaultData)) continue;
            logger.error("Cannot update data center or rack from {} to {} for live host {}, property file NOT RELOADED", new Object[]{new String[]{origValue.datacenter, origValue.rack}, new String[]{updateValue.datacenter, updateValue.rack}, host});
            return false;
        }
        return true;
    }

    private void maybeSetApplicationState() {
        if (this.localNodeData.dcLocalAddress == null) {
            return;
        }
        EndpointState es = Gossiper.instance.getEndpointStateForEndpoint(FBUtilities.getBroadcastAddress());
        if (es == null) {
            return;
        }
        VersionedValue vv = es.getApplicationState(ApplicationState.INTERNAL_IP);
        if (vv != null && !vv.value.equals(this.localNodeData.dcLocalAddress.getHostAddress()) || vv == null) {
            Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_IP, StorageService.instance.valueFactory.internalIP(this.localNodeData.dcLocalAddress.getHostAddress()));
        }
    }

    @Override
    public synchronized void gossiperStarting() {
        this.gossiperInitialized = true;
        StorageService.instance.gossipSnitchInfo();
        Gossiper.instance.register(new ReconnectableSnitchHelper(this, this.localNodeData.datacenter, true));
    }

    private static final class NodeData {
        public String datacenter;
        public String rack;
        public InetAddress dcLocalAddress;

        private NodeData() {
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("datacenter", (Object)this.datacenter).add("rack", (Object)this.rack).add("dcLocalAddress", (Object)this.dcLocalAddress).toString();
        }

        public static boolean isSameDcRack(NodeData a, NodeData b) {
            return a == b || a != null && Objects.equal((Object)a.datacenter, (Object)b.datacenter) && Objects.equal((Object)a.rack, (Object)b.rack);
        }
    }

    public static class Node {
        public String broadcast_address;
        public String dc_local_address;
    }

    public static class Rack {
        public String rack_name;
        public List<Node> nodes = Collections.emptyList();
    }

    public static class Datacenter {
        public String dc_name;
        public List<Rack> racks = Collections.emptyList();
    }

    public static class TopologyConfig {
        public List<Datacenter> topology;
        public String default_dc_name = "UNKNOWN";
        public String default_rack_name = "UNKNOWN";
    }
}

