/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.Pair;

public class DeleteStatement
extends ModificationStatement {
    private DeleteStatement(ModificationStatement.StatementType type, int boundTerms, CFMetaData cfm, Attributes attrs) {
        super(type, boundTerms, cfm, attrs);
    }

    @Override
    public boolean requireFullClusteringKey() {
        return false;
    }

    @Override
    public void addUpdateForKey(ColumnFamily cf, ByteBuffer key, Composite prefix, UpdateParameters params) throws InvalidRequestException {
        List<Operation> deletions = this.getOperations();
        if (deletions.isEmpty()) {
            if (prefix.isEmpty()) {
                cf.delete(new DeletionInfo(params.timestamp, params.localDeletionTime));
            } else if (this.cfm.comparator.isDense() && prefix.size() == this.cfm.clusteringColumns().size()) {
                cf.addAtom(params.makeTombstone(this.cfm.comparator.create(prefix, null)));
            } else {
                cf.addAtom(params.makeRangeTombstone(prefix.slice()));
            }
        } else {
            for (Operation op : deletions) {
                op.execute(key, cf, prefix, params);
            }
        }
    }

    @Override
    protected void validateWhereClauseForConditions() throws InvalidRequestException {
        Iterator iterator;
        boolean onlyHasConditionsOnStaticColumns = this.hasStaticConditions() && !this.hasRegularConditions();
        Iterator iterator2 = iterator = this.appliesOnlyToStaticColumns() ? this.cfm.partitionKeyColumns().iterator() : Iterators.concat(this.cfm.partitionKeyColumns().iterator(), this.cfm.clusteringColumns().iterator());
        while (iterator.hasNext()) {
            ColumnDefinition def = (ColumnDefinition)iterator.next();
            Restriction restriction = (Restriction)this.processedKeys.get(def.name);
            if (restriction != null && (restriction.isEQ() || restriction.isIN())) continue;
            if (onlyHasConditionsOnStaticColumns) {
                for (Operation oper : this.getOperations()) {
                    if (oper.column.isStatic()) continue;
                    throw new InvalidRequestException(String.format("Primary key column '%s' must be specified in order to delete column '%s'", def.name, oper.column.name));
                }
            }
            throw new InvalidRequestException(String.format("DELETE statements must restrict all %s KEY columns with equality relations in order to use IF conditions%s, but column '%s' is not restricted", onlyHasConditionsOnStaticColumns ? "PARTITION" : "PRIMARY", onlyHasConditionsOnStaticColumns ? " on static columns" : "", def.name));
        }
    }

    public static class Parsed
    extends ModificationStatement.Parsed {
        private final List<Operation.RawDeletion> deletions;
        private final List<Relation> whereClause;

        public Parsed(CFName name, Attributes.Raw attrs, List<Operation.RawDeletion> deletions, List<Relation> whereClause, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, attrs, conditions, false, ifExists);
            this.deletions = deletions;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            DeleteStatement stmt = new DeleteStatement(ModificationStatement.StatementType.DELETE, boundNames.size(), cfm, attrs);
            for (Operation.RawDeletion deletion : this.deletions) {
                ColumnIdentifier id = deletion.affectedColumn().prepare(cfm);
                ColumnDefinition def = cfm.getColumnDefinition(id);
                if (def == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", id));
                }
                if (def.isPrimaryKeyColumn()) {
                    throw new InvalidRequestException(String.format("Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", def.name));
                }
                Operation op = deletion.prepare(cfm.ksName, def);
                op.collectMarkerSpecification(boundNames);
                stmt.addOperation(op);
            }
            stmt.processWhereClause(this.whereClause, boundNames);
            return stmt;
        }
    }
}

