/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.hadoop.AbstractBulkRecordWriter;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlBulkOutputFormat;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.thrift.ITransportFactory;
import org.apache.cassandra.tools.BulkLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;

public class CqlBulkRecordWriter
extends AbstractBulkRecordWriter<Object, List<ByteBuffer>> {
    private String keyspace;
    private String columnFamily;
    private String schema;
    private String insertStatement;
    private File outputDir;
    private boolean deleteSrc;

    CqlBulkRecordWriter(TaskAttemptContext context) throws IOException {
        super(context);
        this.setConfigs();
    }

    CqlBulkRecordWriter(Configuration conf, Progressable progress) throws IOException {
        super(conf, progress);
        this.setConfigs();
    }

    CqlBulkRecordWriter(Configuration conf) throws IOException {
        super(conf);
        this.setConfigs();
    }

    private void setConfigs() throws IOException {
        this.keyspace = ConfigHelper.getOutputKeyspace(this.conf);
        this.columnFamily = ConfigHelper.getOutputColumnFamily(this.conf);
        this.schema = CqlBulkOutputFormat.getColumnFamilySchema(this.conf, this.columnFamily);
        this.insertStatement = CqlBulkOutputFormat.getColumnFamilyInsertStatement(this.conf, this.columnFamily);
        this.outputDir = this.getColumnFamilyDirectory();
        this.deleteSrc = CqlBulkOutputFormat.getDeleteSourceOnSuccess(this.conf);
    }

    private void prepareWriter() throws IOException {
        try {
            if (this.writer == null) {
                this.writer = CQLSSTableWriter.builder().forTable(this.schema).using(this.insertStatement).withPartitioner(ConfigHelper.getOutputPartitioner(this.conf)).inDirectory(this.outputDir).withBufferSizeInMB(Integer.parseInt(this.conf.get("mapreduce.output.bulkoutputformat.buffersize", "64"))).build();
            }
            if (this.loader == null) {
                BulkLoader.ExternalClient externalClient = this.getExternalClient(this.conf);
                this.loader = new SSTableLoader(this.outputDir, externalClient, new AbstractBulkRecordWriter.NullOutputHandler()){

                    @Override
                    public void onSuccess(StreamState finalState) {
                        if (CqlBulkRecordWriter.this.deleteSrc) {
                            FileUtils.deleteRecursive(CqlBulkRecordWriter.this.outputDir);
                        }
                    }
                };
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void write(Object key, List<ByteBuffer> values) throws IOException {
        this.prepareWriter();
        try {
            ((CQLSSTableWriter)this.writer).rawAddRow(values);
            if (null != this.progress) {
                this.progress.progress();
            }
            if (null != this.context) {
                HadoopCompat.progress(this.context);
            }
        }
        catch (InvalidRequestException e) {
            throw new IOException("Error adding row with key: " + key, e);
        }
    }

    private File getColumnFamilyDirectory() throws IOException {
        File dir = new File(String.format("%s%s%s%s%s-%s", this.getOutputLocation(), File.separator, this.keyspace, File.separator, this.columnFamily, UUID.randomUUID().toString()));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to created output directory: " + dir);
        }
        return dir;
    }

    private BulkLoader.ExternalClient getExternalClient(Configuration conf) {
        String[] nodes;
        HashSet<InetAddress> hosts = new HashSet<InetAddress>();
        String outputAddress = ConfigHelper.getOutputInitialAddress(conf);
        if (outputAddress == null) {
            outputAddress = "localhost";
        }
        for (String node : nodes = outputAddress.split(",")) {
            try {
                hosts.add(InetAddress.getByName(node));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        int rpcPort = ConfigHelper.getOutputRpcPort(conf);
        String username = ConfigHelper.getOutputKeyspaceUserName(conf);
        String password = ConfigHelper.getOutputKeyspacePassword(conf);
        ITransportFactory transportFactory = ConfigHelper.getClientTransportFactory(conf);
        return new BulkLoader.ExternalClient(hosts, rpcPort, username, password, transportFactory, CqlBulkOutputFormat.getStoragePort(conf), CqlBulkOutputFormat.getSSLStoragePort(conf), this.getServerEncryptOpt(conf));
    }

    private EncryptionOptions.ServerEncryptionOptions getServerEncryptOpt(Configuration conf) {
        EncryptionOptions.ServerEncryptionOptions encryptOpt = new EncryptionOptions.ServerEncryptionOptions();
        String internodeEncrypt = CqlBulkOutputFormat.getInternodeEncryption(conf);
        if (StringUtils.isEmpty((String)internodeEncrypt)) {
            return encryptOpt;
        }
        encryptOpt.internode_encryption = EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.valueOf(internodeEncrypt);
        encryptOpt.keystore = CqlBulkOutputFormat.getServerKeystore(conf);
        encryptOpt.truststore = CqlBulkOutputFormat.getServerTruststore(conf);
        encryptOpt.keystore_password = CqlBulkOutputFormat.getServerKeystorePassword(conf);
        encryptOpt.truststore_password = CqlBulkOutputFormat.getServerTruststorePassword(conf);
        String cipherSuites = CqlBulkOutputFormat.getServerCipherSuites(conf);
        if (!StringUtils.isEmpty((String)cipherSuites)) {
            encryptOpt.cipher_suites = cipherSuites.replace(" ", "").split(",");
        }
        return encryptOpt;
    }
}

