/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.DatacenterAwareRequestCoordinator;
import org.apache.cassandra.repair.Differencer;
import org.apache.cassandra.repair.IRepairJobEventListener;
import org.apache.cassandra.repair.IRequestCoordinator;
import org.apache.cassandra.repair.IRequestProcessor;
import org.apache.cassandra.repair.ParallelRequestCoordinator;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.repair.SequentialRequestCoordinator;
import org.apache.cassandra.repair.SnapshotTask;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairJob {
    private static Logger logger = LoggerFactory.getLogger(RepairJob.class);
    public final RepairJobDesc desc;
    private final RepairParallelism parallelismDegree;
    private final IRequestCoordinator<InetAddress> treeRequests;
    private final List<TreeResponse> trees = new ArrayList<TreeResponse>();
    private final ListeningExecutorService taskExecutor;
    private final Condition requestsSent = new SimpleCondition();
    private int gcBefore = -1;
    private volatile boolean failed = false;
    private AtomicInteger waitForSync;
    private final IRepairJobEventListener listener;

    public RepairJob(IRepairJobEventListener listener, UUID parentSessionId, UUID sessionId, String keyspace, String columnFamily, Range<Token> range, RepairParallelism parallelismDegree, ListeningExecutorService taskExecutor) {
        this.listener = listener;
        this.desc = new RepairJobDesc(parentSessionId, sessionId, keyspace, columnFamily, range);
        this.parallelismDegree = parallelismDegree;
        this.taskExecutor = taskExecutor;
        IRequestProcessor<InetAddress> processor = new IRequestProcessor<InetAddress>(){

            @Override
            public void process(InetAddress endpoint) {
                ValidationRequest request = new ValidationRequest(RepairJob.this.desc, RepairJob.this.gcBefore);
                MessagingService.instance().sendOneWay(request.createMessage(), endpoint);
            }
        };
        switch (parallelismDegree) {
            case SEQUENTIAL: {
                this.treeRequests = new SequentialRequestCoordinator<InetAddress>(processor);
                break;
            }
            case PARALLEL: {
                this.treeRequests = new ParallelRequestCoordinator<InetAddress>(processor);
                break;
            }
            case DATACENTER_AWARE: {
                this.treeRequests = new DatacenterAwareRequestCoordinator(processor);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown degree of parallelism specified");
            }
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void sendTreeRequests(Collection<InetAddress> endpoints) {
        ArrayList<InetAddress> allEndpoints = new ArrayList<InetAddress>(endpoints);
        allEndpoints.add(FBUtilities.getBroadcastAddress());
        if (this.parallelismDegree != RepairParallelism.PARALLEL) {
            ArrayList<SnapshotTask> snapshotTasks = new ArrayList<SnapshotTask>(allEndpoints.size());
            for (InetAddress endpoint : allEndpoints) {
                SnapshotTask snapshotTask = new SnapshotTask(this.desc, endpoint);
                snapshotTasks.add(snapshotTask);
                this.taskExecutor.execute((Runnable)snapshotTask);
            }
            ListenableFuture allSnapshotTasks = Futures.allAsList(snapshotTasks);
            Futures.addCallback((ListenableFuture)allSnapshotTasks, (FutureCallback)new FutureCallback<List<InetAddress>>(){

                public void onSuccess(List<InetAddress> endpoints) {
                    RepairJob.this.sendTreeRequestsInternal(endpoints);
                }

                public void onFailure(Throwable throwable) {
                    logger.error("Error occurred during snapshot phase", throwable);
                    RepairJob.this.listener.failedSnapshot();
                    RepairJob.this.failed = true;
                }
            }, (Executor)this.taskExecutor);
        } else {
            this.sendTreeRequestsInternal(allEndpoints);
        }
    }

    private void sendTreeRequestsInternal(Collection<InetAddress> endpoints) {
        this.gcBefore = Keyspace.open(this.desc.keyspace).getColumnFamilyStore(this.desc.columnFamily).gcBefore(System.currentTimeMillis());
        for (InetAddress endpoint : endpoints) {
            this.treeRequests.add(endpoint);
        }
        logger.info(String.format("[repair #%s] requesting merkle trees for %s (to %s)", this.desc.sessionId, this.desc.columnFamily, endpoints));
        this.treeRequests.start();
        this.requestsSent.signalAll();
    }

    public synchronized int addTree(InetAddress endpoint, MerkleTree tree) {
        try {
            this.requestsSent.await();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"Interrupted while waiting for requests to be sent");
        }
        if (tree == null) {
            this.failed = true;
        } else {
            this.trees.add(new TreeResponse(endpoint, tree));
        }
        return this.treeRequests.completed(endpoint);
    }

    public void submitDifferencers() {
        assert (!this.failed);
        ArrayList<Differencer> differencers = new ArrayList<Differencer>();
        for (int i = 0; i < this.trees.size() - 1; ++i) {
            TreeResponse r1 = this.trees.get(i);
            for (int j = i + 1; j < this.trees.size(); ++j) {
                TreeResponse r2 = this.trees.get(j);
                Differencer differencer = new Differencer(this.desc, r1, r2);
                differencers.add(differencer);
                logger.debug("Queueing comparison {}", (Object)differencer);
            }
        }
        this.waitForSync = new AtomicInteger(differencers.size());
        for (Differencer differencer : differencers) {
            this.taskExecutor.submit((Runnable)differencer);
        }
        this.trees.clear();
    }

    boolean completedSynchronization() {
        return this.waitForSync.decrementAndGet() == 0;
    }
}

