/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class SingleColumnRestriction
implements Restriction {
    @Override
    public boolean isMultiColumn() {
        return false;
    }

    public static class Contains
    extends SingleColumnRestriction {
        private List<Term> values;
        private List<Term> keys;

        public boolean hasContains() {
            return this.values != null;
        }

        public boolean hasContainsKey() {
            return this.keys != null;
        }

        public int numberOfValues() {
            return this.values == null ? 0 : this.values.size();
        }

        public int numberOfKeys() {
            return this.keys == null ? 0 : this.keys.size();
        }

        public void add(Term t, boolean isKey) {
            if (isKey) {
                this.addKey(t);
            } else {
                this.addValue(t);
            }
        }

        public void addValue(Term t) {
            if (this.values == null) {
                this.values = new ArrayList<Term>();
            }
            this.values.add(t);
        }

        public void addKey(Term t) {
            if (this.keys == null) {
                this.keys = new ArrayList<Term>();
            }
            this.keys.add(t);
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            if (this.values == null) {
                return Collections.emptyList();
            }
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
            for (Term value : this.values) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        public List<ByteBuffer> keys(QueryOptions options) throws InvalidRequestException {
            if (this.keys == null) {
                return Collections.emptyList();
            }
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.keys.size());
            for (Term value : this.keys) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return true;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        @Override
        public boolean canEvaluateWithSlices() {
            return false;
        }

        public String toString() {
            return String.format("CONTAINS(values=%s, keys=%s)", this.values, this.keys);
        }
    }

    public static class Slice
    extends SingleColumnRestriction
    implements Restriction.Slice {
        protected final Term[] bounds = new Term[2];
        protected final boolean[] boundInclusive = new boolean[2];
        protected final boolean onToken;

        public Slice(boolean onToken) {
            this.onToken = onToken;
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        @Override
        public boolean canEvaluateWithSlices() {
            return true;
        }

        @Override
        public boolean hasBound(Bound b) {
            return this.bounds[b.idx] != null;
        }

        @Override
        public Term bound(Bound b) {
            return this.bounds[b.idx];
        }

        @Override
        public ByteBuffer bound(Bound b, QueryOptions options) throws InvalidRequestException {
            return this.bounds[b.idx].bindAndGet(options);
        }

        @Override
        public boolean isInclusive(Bound b) {
            return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
        }

        @Override
        public Operator getRelation(Bound eocBound, Bound inclusiveBound) {
            switch (eocBound) {
                case START: {
                    return this.boundInclusive[inclusiveBound.idx] ? Operator.GTE : Operator.GT;
                }
                case END: {
                    return this.boundInclusive[inclusiveBound.idx] ? Operator.LTE : Operator.LT;
                }
            }
            throw new AssertionError();
        }

        @Override
        public Operator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? Operator.GTE : Operator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? Operator.LTE : Operator.LT;
                }
            }
            throw new AssertionError();
        }

        @Override
        public final void setBound(Operator operator, Term t) throws InvalidRequestException {
            boolean inclusive;
            Bound b;
            switch (operator) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = false;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.setBound(b, inclusive, t);
        }

        @Override
        public void setBound(Restriction.Slice slice) throws InvalidRequestException {
            for (Bound bound : Bound.values()) {
                if (!slice.hasBound(bound)) continue;
                this.setBound(bound, slice.isInclusive(bound), slice.bound(bound));
            }
        }

        private void setBound(Bound bound, boolean inclusive, Term term) throws InvalidRequestException {
            assert (this.bounds[bound.idx] == null);
            this.bounds[bound.idx] = term;
            this.boundInclusive[bound.idx] = inclusive;
        }

        public String toString() {
            return String.format("SLICE(%s %s, %s %s)%s", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1], this.onToken ? "*" : "");
        }
    }

    public static class InWithMarker
    extends SingleColumnRestriction
    implements Restriction.IN {
        protected final AbstractMarker marker;

        public InWithMarker(AbstractMarker marker) {
            this.marker = marker;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            Term.MultiItemTerminal lval = (Term.MultiItemTerminal)this.marker.bind(options);
            if (lval == null) {
                throw new InvalidRequestException("Invalid null value for IN restriction");
            }
            return lval.getElements();
        }

        @Override
        public boolean canHaveOnlyOneValue() {
            return false;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        @Override
        public boolean canEvaluateWithSlices() {
            return true;
        }

        public String toString() {
            return "IN ?";
        }
    }

    public static class InWithValues
    extends SingleColumnRestriction
    implements Restriction.IN {
        protected final List<? extends Term> values;

        public InWithValues(List<? extends Term> values) {
            this.values = values;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
            for (Term term : this.values) {
                buffers.add(term.bindAndGet(options));
            }
            return buffers;
        }

        @Override
        public boolean canHaveOnlyOneValue() {
            return this.values.size() == 1;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        @Override
        public boolean canEvaluateWithSlices() {
            return true;
        }

        public String toString() {
            return String.format("IN(%s)", this.values);
        }
    }

    public static class EQ
    extends SingleColumnRestriction
    implements Restriction.EQ {
        protected final Term value;
        private final boolean onToken;

        public EQ(Term value, boolean onToken) {
            this.value = value;
            this.onToken = onToken;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.value.bindAndGet(options));
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return true;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        @Override
        public boolean canEvaluateWithSlices() {
            return true;
        }

        public String toString() {
            return String.format("EQ(%s)%s", this.value, this.onToken ? "*" : "");
        }
    }
}

