/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Objects;
import java.util.List;
import org.apache.cassandra.db.AbstractRangeCommand;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceCommandSerializer;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.pager.Pageable;

public class RangeSliceCommand
extends AbstractRangeCommand
implements Pageable {
    public static final RangeSliceCommandSerializer serializer = new RangeSliceCommandSerializer();
    public final int maxResults;
    public final boolean countCQL3Rows;
    public final boolean isPaging;

    public RangeSliceCommand(String keyspace, String columnFamily, long timestamp, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, int maxResults) {
        this(keyspace, columnFamily, timestamp, predicate, range, null, maxResults, false, false);
    }

    public RangeSliceCommand(String keyspace, String columnFamily, long timestamp, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, List<IndexExpression> row_filter, int maxResults) {
        this(keyspace, columnFamily, timestamp, predicate, range, row_filter, maxResults, false, false);
    }

    public RangeSliceCommand(String keyspace, String columnFamily, long timestamp, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, List<IndexExpression> rowFilter, int maxResults, boolean countCQL3Rows, boolean isPaging) {
        super(keyspace, columnFamily, timestamp, range, predicate, rowFilter);
        this.maxResults = maxResults;
        this.countCQL3Rows = countCQL3Rows;
        this.isPaging = isPaging;
    }

    public MessageOut<RangeSliceCommand> createMessage() {
        return new MessageOut<RangeSliceCommand>(MessagingService.Verb.RANGE_SLICE, this, serializer);
    }

    @Override
    public AbstractRangeCommand forSubRange(AbstractBounds<RowPosition> subRange) {
        return new RangeSliceCommand(this.keyspace, this.columnFamily, this.timestamp, this.predicate, subRange, this.rowFilter, this.maxResults, this.countCQL3Rows, this.isPaging);
    }

    @Override
    public AbstractRangeCommand withUpdatedLimit(int newLimit) {
        return new RangeSliceCommand(this.keyspace, this.columnFamily, this.timestamp, this.predicate, this.keyRange, this.rowFilter, newLimit, this.countCQL3Rows, this.isPaging);
    }

    @Override
    public int limit() {
        return this.maxResults;
    }

    @Override
    public boolean countCQL3Rows() {
        return this.countCQL3Rows;
    }

    @Override
    public List<Row> executeLocally() {
        ColumnFamilyStore cfs = Keyspace.open(this.keyspace).getColumnFamilyStore(this.columnFamily);
        ExtendedFilter exFilter = cfs.makeExtendedFilter(this.keyRange, this.predicate, this.rowFilter, this.maxResults, this.countCQL3Rows, this.isPaging, this.timestamp);
        if (cfs.indexManager.hasIndexFor(this.rowFilter)) {
            return cfs.search(exFilter);
        }
        return cfs.getRangeSlice(exFilter);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("keyspace", (Object)this.keyspace).add("columnFamily", (Object)this.columnFamily).add("predicate", (Object)this.predicate).add("keyRange", (Object)this.keyRange).add("rowFilter", (Object)this.rowFilter).add("maxResults", this.maxResults).add("counterCQL3Rows", this.countCQL3Rows).add("timestamp", this.timestamp).toString();
    }
}

