/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.SuperColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.io.ISSTableSerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.UUIDSerializer;

public class ColumnFamilySerializer
implements IVersionedSerializer<ColumnFamily>,
ISSTableSerializer<ColumnFamily> {
    @Override
    public void serialize(ColumnFamily cf, DataOutputPlus out, int version) {
        try {
            if (cf == null) {
                out.writeBoolean(false);
                return;
            }
            out.writeBoolean(true);
            this.serializeCfId(cf.id(), out, version);
            cf.getComparator().deletionInfoSerializer().serialize(cf.deletionInfo(), out, version);
            ColumnSerializer columnSerializer = cf.getComparator().columnSerializer();
            int count = cf.getColumnCount();
            out.writeInt(count);
            int written = 0;
            for (Cell cell : cf) {
                columnSerializer.serialize(cell, out);
                ++written;
            }
            assert (count == written) : "Column family had " + count + " columns, but " + written + " written";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ColumnFamily deserialize(DataInput in, int version) throws IOException {
        return this.deserialize(in, ColumnSerializer.Flag.LOCAL, version);
    }

    public ColumnFamily deserialize(DataInput in, ColumnSerializer.Flag flag, int version) throws IOException {
        return this.deserialize(in, ArrayBackedSortedColumns.factory, flag, version);
    }

    public ColumnFamily deserialize(DataInput in, ColumnFamily.Factory factory, ColumnSerializer.Flag flag, int version) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        Object cf = factory.create(Schema.instance.getCFMetaData(this.deserializeCfId(in, version)));
        if (((ColumnFamily)cf).metadata().isSuper() && version < 7) {
            SuperColumns.deserializerSuperColumnFamily(in, cf, flag, version);
        } else {
            ((ColumnFamily)cf).delete(((ColumnFamily)cf).getComparator().deletionInfoSerializer().deserialize(in, version));
            ColumnSerializer columnSerializer = ((ColumnFamily)cf).getComparator().columnSerializer();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                ((ColumnFamily)cf).addColumn(columnSerializer.deserialize(in, flag));
            }
        }
        return cf;
    }

    public long contentSerializedSize(ColumnFamily cf, TypeSizes typeSizes, int version) {
        long size = cf.getComparator().deletionInfoSerializer().serializedSize(cf.deletionInfo(), typeSizes, version);
        size += (long)typeSizes.sizeof(cf.getColumnCount());
        ColumnSerializer columnSerializer = cf.getComparator().columnSerializer();
        for (Cell cell : cf) {
            size += columnSerializer.serializedSize(cell, typeSizes);
        }
        return size;
    }

    public long serializedSize(ColumnFamily cf, TypeSizes typeSizes, int version) {
        if (cf == null) {
            return typeSizes.sizeof(false);
        }
        return (long)(typeSizes.sizeof(true) + this.cfIdSerializedSize(cf.id(), typeSizes, version)) + this.contentSerializedSize(cf, typeSizes, version);
    }

    @Override
    public long serializedSize(ColumnFamily cf, int version) {
        return this.serializedSize(cf, TypeSizes.NATIVE, version);
    }

    @Override
    public void serializeForSSTable(ColumnFamily cf, DataOutputPlus out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnFamily deserializeFromSSTable(DataInput in, Descriptor.Version version) {
        throw new UnsupportedOperationException();
    }

    public void serializeCfId(UUID cfId, DataOutputPlus out, int version) throws IOException {
        UUIDSerializer.serializer.serialize(cfId, out, version);
    }

    public UUID deserializeCfId(DataInput in, int version) throws IOException {
        UUID cfId = UUIDSerializer.serializer.deserialize(in, version);
        if (Schema.instance.getCF(cfId) == null) {
            throw new UnknownColumnFamilyException("Couldn't find cfId=" + cfId, cfId);
        }
        return cfId;
    }

    public int cfIdSerializedSize(UUID cfId, TypeSizes typeSizes, int version) {
        return typeSizes.sizeof(cfId);
    }
}

