/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class ListSerializer<T>
extends CollectionSerializer<List<T>> {
    private static final Map<TypeSerializer<?>, ListSerializer> instances = new HashMap();
    public final TypeSerializer<T> elements;

    public static synchronized <T> ListSerializer<T> getInstance(TypeSerializer<T> elements) {
        ListSerializer<T> t = instances.get(elements);
        if (t == null) {
            t = new ListSerializer<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    private ListSerializer(TypeSerializer<T> elements) {
        this.elements = elements;
    }

    @Override
    public List<ByteBuffer> serializeValues(List<T> values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.size());
        for (T value : values) {
            buffers.add(this.elements.serialize(value));
        }
        return buffers;
    }

    @Override
    public int getElementCount(List<T> value) {
        return value.size();
    }

    @Override
    public void validateForNativeProtocol(ByteBuffer bytes, int version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = ListSerializer.readCollectionSize(input, version);
            for (int i = 0; i < n; ++i) {
                this.elements.validate(ListSerializer.readValue(input, version));
            }
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public List<T> deserializeForNativeProtocol(ByteBuffer bytes, int version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = ListSerializer.readCollectionSize(input, version);
            ArrayList<T> l = new ArrayList<T>(n);
            for (int i = 0; i < n; ++i) {
                ByteBuffer databb = ListSerializer.readValue(input, version);
                this.elements.validate(databb);
                l.add(this.elements.deserialize(databb));
            }
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public String toString(List<T> value) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("; ");
            }
            sb.append(this.elements.toString(element));
        }
        return sb.toString();
    }

    @Override
    public Class<List<T>> getType() {
        return List.class;
    }
}

