/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BiMultiValMap;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SortedBiMultiValMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenMetadata {
    private static final Logger logger = LoggerFactory.getLogger(TokenMetadata.class);
    private final BiMultiValMap<Token, InetAddress> tokenToEndpointMap;
    private final BiMap<InetAddress, UUID> endpointToHostIdMap;
    private final BiMultiValMap<Token, InetAddress> bootstrapTokens = new BiMultiValMap();
    private final Set<InetAddress> leavingEndpoints = new HashSet<InetAddress>();
    private final ConcurrentMap<String, Multimap<Range<Token>, InetAddress>> pendingRanges = new ConcurrentHashMap<String, Multimap<Range<Token>, InetAddress>>();
    private final Set<Pair<Token, InetAddress>> movingEndpoints = new HashSet<Pair<Token, InetAddress>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile ArrayList<Token> sortedTokens;
    private final Topology topology;
    private static final Comparator<InetAddress> inetaddressCmp = new Comparator<InetAddress>(){

        @Override
        public int compare(InetAddress o1, InetAddress o2) {
            return ByteBuffer.wrap(o1.getAddress()).compareTo(ByteBuffer.wrap(o2.getAddress()));
        }
    };
    private volatile long ringVersion = 0L;
    private final AtomicReference<TokenMetadata> cachedTokenMap = new AtomicReference();

    public TokenMetadata() {
        this(SortedBiMultiValMap.create(null, inetaddressCmp), (BiMap<InetAddress, UUID>)HashBiMap.create(), new Topology());
    }

    private TokenMetadata(BiMultiValMap<Token, InetAddress> tokenToEndpointMap, BiMap<InetAddress, UUID> endpointsMap, Topology topology) {
        this.tokenToEndpointMap = tokenToEndpointMap;
        this.topology = topology;
        this.endpointToHostIdMap = endpointsMap;
        this.sortedTokens = this.sortTokens();
    }

    private ArrayList<Token> sortTokens() {
        return new ArrayList<Token>(this.tokenToEndpointMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pendingRangeChanges(InetAddress source) {
        int n = 0;
        Collection<Range<Token>> sourceRanges = this.getPrimaryRangesFor(this.getTokens(source));
        this.lock.readLock().lock();
        try {
            for (Token token : this.bootstrapTokens.keySet()) {
                for (Range<Token> range : sourceRanges) {
                    if (!range.contains(token)) continue;
                    ++n;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return n;
    }

    public void updateNormalToken(Token token, InetAddress endpoint) {
        this.updateNormalTokens(Collections.singleton(token), endpoint);
    }

    public void updateNormalTokens(Collection<Token> tokens, InetAddress endpoint) {
        HashMultimap endpointTokens = HashMultimap.create();
        for (Token token : tokens) {
            endpointTokens.put((Object)endpoint, (Object)token);
        }
        this.updateNormalTokens((Multimap<InetAddress, Token>)endpointTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNormalTokens(Multimap<InetAddress, Token> endpointTokens) {
        if (endpointTokens.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            boolean shouldSortTokens = false;
            for (InetAddress endpoint : endpointTokens.keySet()) {
                Collection tokens = endpointTokens.get((Object)endpoint);
                assert (tokens != null && !tokens.isEmpty());
                this.bootstrapTokens.removeValue(endpoint);
                this.tokenToEndpointMap.removeValue(endpoint);
                this.topology.addEndpoint(endpoint);
                this.leavingEndpoints.remove(endpoint);
                this.removeFromMoving(endpoint);
                for (Token token : tokens) {
                    InetAddress prev = this.tokenToEndpointMap.put(token, endpoint);
                    if (endpoint.equals(prev)) continue;
                    if (prev != null) {
                        logger.warn("Token {} changing ownership from {} to {}", new Object[]{token, prev, endpoint});
                    }
                    shouldSortTokens = true;
                }
            }
            if (shouldSortTokens) {
                this.sortedTokens = this.sortTokens();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHostId(UUID hostId, InetAddress endpoint) {
        assert (hostId != null);
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            InetAddress storedEp = (InetAddress)this.endpointToHostIdMap.inverse().get((Object)hostId);
            if (storedEp != null && !storedEp.equals(endpoint) && FailureDetector.instance.isAlive(storedEp)) {
                throw new RuntimeException(String.format("Host ID collision between active endpoint %s and %s (id=%s)", storedEp, endpoint, hostId));
            }
            UUID storedId = (UUID)this.endpointToHostIdMap.get((Object)endpoint);
            if (storedId != null && !storedId.equals(hostId)) {
                logger.warn("Changing {}'s host ID from {} to {}", new Object[]{endpoint, storedId, hostId});
            }
            this.endpointToHostIdMap.forcePut((Object)endpoint, (Object)hostId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getHostId(InetAddress endpoint) {
        this.lock.readLock().lock();
        try {
            UUID uUID = (UUID)this.endpointToHostIdMap.get((Object)endpoint);
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getEndpointForHostId(UUID hostId) {
        this.lock.readLock().lock();
        try {
            InetAddress inetAddress = (InetAddress)this.endpointToHostIdMap.inverse().get((Object)hostId);
            return inetAddress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<InetAddress, UUID> getEndpointToHostIdMapForReading() {
        this.lock.readLock().lock();
        try {
            HashMap<InetAddress, UUID> readMap = new HashMap<InetAddress, UUID>();
            readMap.putAll((Map<InetAddress, UUID>)this.endpointToHostIdMap);
            HashMap<InetAddress, UUID> hashMap = readMap;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    public void addBootstrapToken(Token token, InetAddress endpoint) {
        this.addBootstrapTokens(Collections.singleton(token), endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBootstrapTokens(Collection<Token> tokens, InetAddress endpoint) {
        assert (tokens != null && !tokens.isEmpty());
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            for (Token token : tokens) {
                InetAddress oldEndpoint = this.bootstrapTokens.get(token);
                if (oldEndpoint != null && !oldEndpoint.equals(endpoint)) {
                    throw new RuntimeException("Bootstrap Token collision between " + oldEndpoint + " and " + endpoint + " (token " + token);
                }
                oldEndpoint = this.tokenToEndpointMap.get(token);
                if (oldEndpoint == null || oldEndpoint.equals(endpoint)) continue;
                throw new RuntimeException("Bootstrap Token collision between " + oldEndpoint + " and " + endpoint + " (token " + token);
            }
            this.bootstrapTokens.removeValue(endpoint);
            for (Token token : tokens) {
                this.bootstrapTokens.put(token, endpoint);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBootstrapTokens(Collection<Token> tokens) {
        assert (tokens != null && !tokens.isEmpty());
        this.lock.writeLock().lock();
        try {
            for (Token token : tokens) {
                this.bootstrapTokens.remove(token);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeavingEndpoint(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.leavingEndpoints.add(endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMovingEndpoint(Token token, InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.movingEndpoints.add(Pair.create(token, endpoint));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpoint(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.removeValue(endpoint);
            this.tokenToEndpointMap.removeValue(endpoint);
            this.topology.removeEndpoint(endpoint);
            this.leavingEndpoints.remove(endpoint);
            this.endpointToHostIdMap.remove((Object)endpoint);
            this.sortedTokens = this.sortTokens();
            this.invalidateCachedRings();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMoving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            for (Pair<Token, InetAddress> pair : this.movingEndpoints) {
                if (!((InetAddress)pair.right).equals(endpoint)) continue;
                this.movingEndpoints.remove(pair);
                break;
            }
            this.invalidateCachedRings();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Token> getTokens(InetAddress endpoint) {
        assert (endpoint != null);
        assert (this.isMember(endpoint));
        this.lock.readLock().lock();
        try {
            ArrayList<Token> arrayList = new ArrayList<Token>(this.tokenToEndpointMap.inverse().get((Object)endpoint));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    public Token getToken(InetAddress endpoint) {
        return this.getTokens(endpoint).iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMember(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.tokenToEndpointMap.inverse().containsKey((Object)endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.leavingEndpoints.contains(endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMoving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            for (Pair<Token, InetAddress> pair : this.movingEndpoints) {
                if (!((InetAddress)pair.right).equals(endpoint)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneOnlyTokenMap() {
        this.lock.readLock().lock();
        try {
            TokenMetadata tokenMetadata = new TokenMetadata(SortedBiMultiValMap.create(this.tokenToEndpointMap, null, inetaddressCmp), (BiMap<InetAddress, UUID>)HashBiMap.create(this.endpointToHostIdMap), new Topology(this.topology));
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cachedOnlyTokenMap() {
        TokenMetadata tm = this.cachedTokenMap.get();
        if (tm != null) {
            return tm;
        }
        TokenMetadata tokenMetadata = this;
        synchronized (tokenMetadata) {
            tm = this.cachedTokenMap.get();
            if (tm != null) {
                return tm;
            }
            tm = this.cloneOnlyTokenMap();
            this.cachedTokenMap.set(tm);
            return tm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneAfterAllLeft() {
        this.lock.readLock().lock();
        try {
            TokenMetadata allLeftMetadata = this.cloneOnlyTokenMap();
            for (InetAddress endpoint : this.leavingEndpoints) {
                allLeftMetadata.removeEndpoint(endpoint);
            }
            TokenMetadata tokenMetadata = allLeftMetadata;
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneAfterAllSettled() {
        this.lock.readLock().lock();
        try {
            TokenMetadata metadata = this.cloneOnlyTokenMap();
            for (InetAddress inetAddress : this.leavingEndpoints) {
                metadata.removeEndpoint(inetAddress);
            }
            for (Pair pair : this.movingEndpoints) {
                metadata.updateNormalToken((Token)pair.left, (InetAddress)pair.right);
            }
            TokenMetadata tokenMetadata = metadata;
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getEndpoint(Token token) {
        this.lock.readLock().lock();
        try {
            InetAddress inetAddress = this.tokenToEndpointMap.get(token);
            return inetAddress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Range<Token>> getPrimaryRangesFor(Collection<Token> tokens) {
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(tokens.size());
        for (Token right : tokens) {
            ranges.add(new Range<Token>(this.getPredecessor(right), right));
        }
        return ranges;
    }

    @Deprecated
    public Range<Token> getPrimaryRangeFor(Token right) {
        return this.getPrimaryRangesFor(Arrays.asList(right)).iterator().next();
    }

    public ArrayList<Token> sortedTokens() {
        return this.sortedTokens;
    }

    private Multimap<Range<Token>, InetAddress> getPendingRangesMM(String keyspaceName) {
        Multimap<Range<Token>, InetAddress> priorMap;
        Multimap<Range<Token>, InetAddress> map = (Multimap<Range<Token>, InetAddress>)this.pendingRanges.get(keyspaceName);
        if (map == null && (priorMap = this.pendingRanges.putIfAbsent(keyspaceName, map = HashMultimap.create())) != null) {
            map = priorMap;
        }
        return map;
    }

    public Map<Range<Token>, Collection<InetAddress>> getPendingRanges(String keyspaceName) {
        return this.getPendingRangesMM(keyspaceName).asMap();
    }

    public List<Range<Token>> getPendingRanges(String keyspaceName, InetAddress endpoint) {
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>();
        for (Map.Entry entry : this.getPendingRangesMM(keyspaceName).entries()) {
            if (!((InetAddress)entry.getValue()).equals(endpoint)) continue;
            ranges.add((Range<Token>)entry.getKey());
        }
        return ranges;
    }

    public void setPendingRanges(String keyspaceName, Multimap<Range<Token>, InetAddress> rangeMap) {
        this.pendingRanges.put(keyspaceName, rangeMap);
    }

    public Token getPredecessor(Token token) {
        ArrayList<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + StringUtils.join(this.tokenToEndpointMap.keySet(), (String)", ");
        return (Token)(index == 0 ? tokens.get(tokens.size() - 1) : tokens.get(index - 1));
    }

    public Token getSuccessor(Token token) {
        ArrayList<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + StringUtils.join(this.tokenToEndpointMap.keySet(), (String)", ");
        return (Token)(index == tokens.size() - 1 ? tokens.get(0) : tokens.get(index + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiMultiValMap<Token, InetAddress> getBootstrapTokens() {
        this.lock.readLock().lock();
        try {
            BiMultiValMap<Token, InetAddress> biMultiValMap = new BiMultiValMap<Token, InetAddress>(this.bootstrapTokens);
            return biMultiValMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InetAddress> getAllEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.endpointToHostIdMap.keySet());
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InetAddress> getLeavingEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.leavingEndpoints);
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Pair<Token, InetAddress>> getMovingEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.movingEndpoints);
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static int firstTokenIndex(ArrayList ring, Token start, boolean insertMin) {
        assert (ring.size() > 0);
        int i = Collections.binarySearch(ring, start);
        if (i < 0 && (i = (i + 1) * -1) >= ring.size()) {
            i = insertMin ? -1 : 0;
        }
        return i;
    }

    public static Token firstToken(ArrayList<Token> ring, Token start) {
        return ring.get(TokenMetadata.firstTokenIndex(ring, start, false));
    }

    public static Iterator<Token> ringIterator(final ArrayList<Token> ring, Token start, boolean includeMin) {
        if (ring.isEmpty()) {
            return includeMin ? Iterators.singletonIterator(StorageService.getPartitioner().getMinimumToken()) : Iterators.emptyIterator();
        }
        final boolean insertMin = includeMin && !ring.get(0).isMinimum();
        final int startIndex = TokenMetadata.firstTokenIndex(ring, start, insertMin);
        return new AbstractIterator<Token>(){
            int j;
            {
                this.j = startIndex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Token computeNext() {
                Token token;
                block10: {
                    block8: {
                        Object t;
                        block9: {
                            if (this.j < -1) {
                                return (Token)this.endOfData();
                            }
                            try {
                                if (this.j != -1) break block8;
                                t = StorageService.getPartitioner().getMinimumToken();
                                ++this.j;
                                if (this.j != ring.size()) break block9;
                                int n = this.j = insertMin ? -1 : 0;
                            }
                            catch (Throwable throwable) {
                                ++this.j;
                                if (this.j == ring.size()) {
                                    int n = this.j = insertMin ? -1 : 0;
                                }
                                if (this.j == startIndex) {
                                    this.j = -2;
                                }
                                throw throwable;
                            }
                        }
                        if (this.j == startIndex) {
                            this.j = -2;
                        }
                        return t;
                    }
                    token = (Token)ring.get(this.j);
                    ++this.j;
                    if (this.j != ring.size()) break block10;
                    int n = this.j = insertMin ? -1 : 0;
                }
                if (this.j == startIndex) {
                    this.j = -2;
                }
                return token;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnsafe() {
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.clear();
            this.tokenToEndpointMap.clear();
            this.topology.clear();
            this.leavingEndpoints.clear();
            this.pendingRanges.clear();
            this.endpointToHostIdMap.clear();
            this.invalidateCachedRings();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.lock.readLock().lock();
        try {
            Set eps = this.tokenToEndpointMap.inverse().keySet();
            if (!eps.isEmpty()) {
                sb.append("Normal Tokens:");
                sb.append(System.getProperty("line.separator"));
                for (InetAddress inetAddress : eps) {
                    sb.append(inetAddress);
                    sb.append(":");
                    sb.append(this.tokenToEndpointMap.inverse().get((Object)inetAddress));
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.bootstrapTokens.isEmpty()) {
                sb.append("Bootstrapping Tokens:");
                sb.append(System.getProperty("line.separator"));
                for (Map.Entry entry : this.bootstrapTokens.entrySet()) {
                    sb.append(entry.getValue()).append(":").append(entry.getKey());
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.leavingEndpoints.isEmpty()) {
                sb.append("Leaving Endpoints:");
                sb.append(System.getProperty("line.separator"));
                for (InetAddress inetAddress : this.leavingEndpoints) {
                    sb.append(inetAddress);
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.pendingRanges.isEmpty()) {
                sb.append("Pending Ranges:");
                sb.append(System.getProperty("line.separator"));
                sb.append(this.printPendingRanges());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return sb.toString();
    }

    public String printPendingRanges() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.pendingRanges.entrySet()) {
            for (Map.Entry rmap : ((Multimap)entry.getValue()).entries()) {
                sb.append(rmap.getValue()).append(":").append(rmap.getKey());
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    public Collection<InetAddress> pendingEndpointsFor(Token token, String keyspaceName) {
        Map<Range<Token>, Collection<InetAddress>> ranges = this.getPendingRanges(keyspaceName);
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<InetAddress> endpoints = new HashSet<InetAddress>();
        for (Map.Entry<Range<Token>, Collection<InetAddress>> entry : ranges.entrySet()) {
            if (!entry.getKey().contains(token)) continue;
            endpoints.addAll(entry.getValue());
        }
        return endpoints;
    }

    public Collection<InetAddress> getWriteEndpoints(Token token, String keyspaceName, Collection<InetAddress> naturalEndpoints) {
        return ImmutableList.copyOf((Iterable)Iterables.concat(naturalEndpoints, this.pendingEndpointsFor(token, keyspaceName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<InetAddress, Token> getEndpointToTokenMapForReading() {
        this.lock.readLock().lock();
        try {
            HashMultimap cloned = HashMultimap.create();
            for (Map.Entry<Token, InetAddress> entry : this.tokenToEndpointMap.entrySet()) {
                cloned.put((Object)entry.getValue(), (Object)entry.getKey());
            }
            HashMultimap hashMultimap = cloned;
            return hashMultimap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Token, InetAddress> getNormalAndBootstrappingTokenToEndpointMap() {
        this.lock.readLock().lock();
        try {
            HashMap<Token, InetAddress> map = new HashMap<Token, InetAddress>(this.tokenToEndpointMap.size() + this.bootstrapTokens.size());
            map.putAll(this.tokenToEndpointMap);
            map.putAll(this.bootstrapTokens);
            HashMap<Token, InetAddress> hashMap = map;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Topology getTopology() {
        assert (this != StorageService.instance.getTokenMetadata());
        return this.topology;
    }

    public long getRingVersion() {
        return this.ringVersion;
    }

    public void invalidateCachedRings() {
        ++this.ringVersion;
        this.cachedTokenMap.set(null);
    }

    public static class Topology {
        private final Multimap<String, InetAddress> dcEndpoints;
        private final Map<String, Multimap<String, InetAddress>> dcRacks;
        private final Map<InetAddress, Pair<String, String>> currentLocations;

        protected Topology() {
            this.dcEndpoints = HashMultimap.create();
            this.dcRacks = new HashMap<String, Multimap<String, InetAddress>>();
            this.currentLocations = new HashMap<InetAddress, Pair<String, String>>();
        }

        protected void clear() {
            this.dcEndpoints.clear();
            this.dcRacks.clear();
            this.currentLocations.clear();
        }

        protected Topology(Topology other) {
            this.dcEndpoints = HashMultimap.create(other.dcEndpoints);
            this.dcRacks = new HashMap<String, Multimap<String, InetAddress>>();
            for (String dc : other.dcRacks.keySet()) {
                this.dcRacks.put(dc, (Multimap<String, InetAddress>)HashMultimap.create(other.dcRacks.get(dc)));
            }
            this.currentLocations = new HashMap<InetAddress, Pair<String, String>>(other.currentLocations);
        }

        protected void addEndpoint(InetAddress ep) {
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            String dc = snitch.getDatacenter(ep);
            String rack = snitch.getRack(ep);
            Pair<String, String> current = this.currentLocations.get(ep);
            if (current != null) {
                if (((String)current.left).equals(dc) && ((String)current.right).equals(rack)) {
                    return;
                }
                this.dcRacks.get(current.left).remove(current.right, (Object)ep);
                this.dcEndpoints.remove(current.left, (Object)ep);
            }
            this.dcEndpoints.put((Object)dc, (Object)ep);
            if (!this.dcRacks.containsKey(dc)) {
                this.dcRacks.put(dc, (Multimap<String, InetAddress>)HashMultimap.create());
            }
            this.dcRacks.get(dc).put((Object)rack, (Object)ep);
            this.currentLocations.put(ep, Pair.create(dc, rack));
        }

        protected void removeEndpoint(InetAddress ep) {
            if (!this.currentLocations.containsKey(ep)) {
                return;
            }
            Pair<String, String> current = this.currentLocations.remove(ep);
            this.dcEndpoints.remove(current.left, (Object)ep);
            this.dcRacks.get(current.left).remove(current.right, (Object)ep);
        }

        public Multimap<String, InetAddress> getDatacenterEndpoints() {
            return this.dcEndpoints;
        }

        public Map<String, Multimap<String, InetAddress>> getDatacenterRacks() {
            return this.dcRacks;
        }
    }
}

