/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.AbstractCompoundCellNameType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundCType;
import org.apache.cassandra.db.composites.CompoundComposite;
import org.apache.cassandra.db.composites.CompoundDenseCellName;
import org.apache.cassandra.db.composites.SimpleDenseCellNameType;
import org.apache.cassandra.db.marshal.AbstractType;

public class CompoundDenseCellNameType
extends AbstractCompoundCellNameType {
    public CompoundDenseCellNameType(List<AbstractType<?>> types) {
        this(new CompoundCType(types));
    }

    private CompoundDenseCellNameType(CompoundCType type) {
        super(type, type);
    }

    @Override
    public CellNameType setSubtype(int position, AbstractType<?> newType) {
        if (position != 0) {
            throw new IllegalArgumentException();
        }
        return new SimpleDenseCellNameType(newType);
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public CellName create(Composite prefix, ColumnDefinition column) {
        assert (prefix.size() == this.fullSize);
        if (prefix instanceof CellName) {
            return (CellName)prefix;
        }
        assert (prefix instanceof CompoundComposite);
        CompoundComposite lc = (CompoundComposite)prefix;
        assert (lc.elements.length == lc.size);
        return new CompoundDenseCellName(lc.elements);
    }

    @Override
    protected Composite makeWith(ByteBuffer[] components, int size, Composite.EOC eoc, boolean isStatic) {
        assert (!isStatic);
        CompoundDenseCellName c = new CompoundDenseCellName(components, size);
        return eoc != Composite.EOC.NONE ? c.withEOC(eoc) : c;
    }

    @Override
    protected Composite copyAndMakeWith(ByteBuffer[] components, int size, Composite.EOC eoc, boolean isStatic) {
        return this.makeWith(Arrays.copyOfRange(components, 0, size), size, eoc, isStatic);
    }

    @Override
    public void addCQL3Column(ColumnIdentifier id) {
    }

    @Override
    public void removeCQL3Column(ColumnIdentifier id) {
    }

    @Override
    public CQL3Row.Builder CQL3RowBuilder(CFMetaData metadata, long now) {
        return CompoundDenseCellNameType.makeDenseCQL3RowBuilder(now);
    }
}

