/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTask
extends AbstractCompactionTask {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionTask.class);
    protected final int gcBefore;
    private final boolean offline;
    protected static long totalBytesCompacted = 0L;
    private CompactionManager.CompactionExecutorStatsCollector collector;

    public CompactionTask(ColumnFamilyStore cfs, Iterable<SSTableReader> sstables, int gcBefore, boolean offline) {
        super(cfs, Sets.newHashSet(sstables));
        this.gcBefore = gcBefore;
        this.offline = offline;
    }

    public static synchronized long addToTotalBytesCompacted(long bytesCompacted) {
        return totalBytesCompacted += bytesCompacted;
    }

    @Override
    protected int executeInternal(CompactionManager.CompactionExecutorStatsCollector collector) {
        this.collector = collector;
        this.run();
        return this.sstables.size();
    }

    @Override
    public long getExpectedWriteSize() {
        return this.cfs.getExpectedCompactedFileSize(this.sstables, this.compactionType);
    }

    @Override
    public boolean reduceScopeForLimitedSpace() {
        if (this.partialCompactionsAcceptable() && this.sstables.size() > 1) {
            logger.warn("insufficient space to compact all requested files {}", (Object)StringUtils.join((Iterable)this.sstables, (String)", "));
            return this.sstables.remove(this.cfs.getMaxSizeFile(this.sstables));
        }
        return false;
    }

    @Override
    protected void runWith(File sstableDirectory) throws Exception {
        assert (this.sstables != null && sstableDirectory != null);
        if (this.sstables.size() == 0) {
            return;
        }
        AbstractCompactionStrategy strategy = this.cfs.getCompactionStrategy();
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            this.cfs.snapshotWithoutFlush(System.currentTimeMillis() + "-compact-" + this.cfs.name);
        }
        assert (!Iterables.any((Iterable)this.sstables, (Predicate)new Predicate<SSTableReader>(){

            public boolean apply(SSTableReader sstable) {
                return !sstable.descriptor.cfname.equals(CompactionTask.this.cfs.name);
            }
        }));
        UUID taskId = SystemKeyspace.startCompaction(this.cfs, this.sstables);
        CompactionController controller = this.getCompactionController(this.sstables);
        Sets.SetView actuallyCompact = Sets.difference((Set)this.sstables, controller.getFullyExpiredSSTables());
        logger.info("Compacting {}", (Object)this.sstables);
        long start = System.nanoTime();
        long totalKeysWritten = 0L;
        long estimatedTotalKeys = Math.max((long)this.cfs.metadata.getMinIndexInterval(), SSTableReader.getApproximateKeyCount((Collection<SSTableReader>)actuallyCompact));
        long estimatedSSTables = Math.max(1L, SSTableReader.getTotalBytes((Iterable<SSTableReader>)actuallyCompact) / strategy.getMaxSSTableBytes());
        long keysPerSSTable = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
        logger.debug("Expected bloom filter size : {}", (Object)keysPerSSTable);
        CompactionIterable ci = new CompactionIterable(this.compactionType, strategy.getScanners((Collection<SSTableReader>)actuallyCompact), controller);
        Iterator iter = ((AbstractCompactionIterable)ci).iterator();
        long minRepairedAt = this.getMinRepairedAt((Set<SSTableReader>)actuallyCompact);
        long maxAge = CompactionTask.getMaxDataAge((Collection<SSTableReader>)actuallyCompact);
        if (this.collector != null) {
            this.collector.beginCompaction(ci);
        }
        SSTableRewriter writer = new SSTableRewriter(this.cfs, this.sstables, maxAge, this.compactionType, this.offline);
        try {
            if (!iter.hasNext()) {
                this.cfs.markObsolete(this.sstables, this.compactionType);
                return;
            }
            writer.switchWriter(this.createCompactionWriter(sstableDirectory, keysPerSSTable, minRepairedAt));
            while (iter.hasNext()) {
                if (ci.isStopRequested()) {
                    throw new CompactionInterruptedException(ci.getCompactionInfo());
                }
                AbstractCompactedRow row = (AbstractCompactedRow)iter.next();
                if (writer.append(row) == null) continue;
                ++totalKeysWritten;
                if (!this.newSSTableSegmentThresholdReached(writer.currentWriter())) continue;
                writer.switchWriter(this.createCompactionWriter(sstableDirectory, keysPerSSTable, minRepairedAt));
            }
            writer.finish(false);
        }
        catch (Throwable t) {
            writer.abort();
            throw t;
        }
        finally {
            controller.close();
            if (taskId != null) {
                SystemKeyspace.finishCompaction(taskId);
            }
            if (this.collector != null) {
                this.collector.finishCompaction(ci);
            }
            try {
                iter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Set oldSStables = this.sstables;
        List<SSTableReader> newSStables = writer.finished();
        if (!this.offline) {
            this.cfs.getDataTracker().markCompactedSSTablesReplaced(oldSStables, newSStables, this.compactionType);
        }
        long dTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        long startsize = SSTableReader.getTotalBytes(oldSStables);
        long endsize = SSTableReader.getTotalBytes(newSStables);
        double ratio = (double)endsize / (double)startsize;
        StringBuilder newSSTableNames = new StringBuilder();
        for (SSTableReader reader : newSStables) {
            newSSTableNames.append(reader.descriptor.baseFilename()).append(",");
        }
        double mbps = dTime > 0L ? (double)endsize / 1048576.0 / ((double)dTime / 1000.0) : 0.0;
        long totalSourceRows = 0L;
        long[] counts = ci.getMergedRowCounts();
        StringBuilder mergeSummary = new StringBuilder(counts.length * 10);
        HashMap<Integer, Long> mergedRows = new HashMap<Integer, Long>();
        for (int i = 0; i < counts.length; ++i) {
            long count = counts[i];
            if (count == 0L) continue;
            int rows = i + 1;
            totalSourceRows += (long)rows * count;
            mergeSummary.append(String.format("%d:%d, ", rows, count));
            mergedRows.put(rows, count);
        }
        SystemKeyspace.updateCompactionHistory(this.cfs.keyspace.getName(), this.cfs.name, System.currentTimeMillis(), startsize, endsize, mergedRows);
        logger.info(String.format("Compacted %d sstables to [%s].  %,d bytes to %,d (~%d%% of original) in %,dms = %fMB/s.  %,d total partitions merged to %,d.  Partition merge counts were {%s}", oldSStables.size(), newSSTableNames.toString(), startsize, endsize, (int)(ratio * 100.0), dTime, mbps, totalSourceRows, totalKeysWritten, mergeSummary.toString()));
        logger.debug(String.format("CF Total Bytes Compacted: %,d", CompactionTask.addToTotalBytesCompacted(endsize)));
        logger.debug("Actual #keys: {}, Estimated #keys:{}, Err%: {}", new Object[]{totalKeysWritten, estimatedTotalKeys, (double)(totalKeysWritten - estimatedTotalKeys) / (double)totalKeysWritten});
    }

    private long getMinRepairedAt(Set<SSTableReader> actuallyCompact) {
        long minRepairedAt = Long.MAX_VALUE;
        for (SSTableReader sstable : actuallyCompact) {
            minRepairedAt = Math.min(minRepairedAt, sstable.getSSTableMetadata().repairedAt);
        }
        if (minRepairedAt == Long.MAX_VALUE) {
            return 0L;
        }
        return minRepairedAt;
    }

    private SSTableWriter createCompactionWriter(File sstableDirectory, long keysPerSSTable, long repairedAt) {
        return new SSTableWriter(this.cfs.getTempSSTablePath(sstableDirectory), keysPerSSTable, repairedAt, this.cfs.metadata, this.cfs.partitioner, new MetadataCollector(this.sstables, this.cfs.metadata.comparator, this.getLevel()));
    }

    protected int getLevel() {
        return 0;
    }

    protected CompactionController getCompactionController(Set<SSTableReader> toCompact) {
        return new CompactionController(this.cfs, toCompact, this.gcBefore);
    }

    protected boolean partialCompactionsAcceptable() {
        return !this.isUserDefined;
    }

    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer) {
        return false;
    }

    public static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }
}

