/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.AtomDeserializer;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SSTableNamesIterator
extends AbstractIterator<OnDiskAtom>
implements OnDiskAtomIterator {
    private ColumnFamily cf;
    private final SSTableReader sstable;
    private FileDataInput fileToClose;
    private Iterator<OnDiskAtom> iter;
    public final SortedSet<CellName> columns;
    public final DecoratedKey key;

    public SSTableNamesIterator(SSTableReader sstable, DecoratedKey key, SortedSet<CellName> columns) {
        assert (columns != null);
        this.sstable = sstable;
        this.columns = columns;
        this.key = key;
        RowIndexEntry indexEntry = sstable.getPosition(key, SSTableReader.Operator.EQ);
        if (indexEntry == null) {
            return;
        }
        try {
            this.read(sstable, null, indexEntry);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, sstable.getFilename());
        }
        finally {
            if (this.fileToClose != null) {
                FileUtils.closeQuietly(this.fileToClose);
            }
        }
    }

    public SSTableNamesIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, SortedSet<CellName> columns, RowIndexEntry indexEntry) {
        assert (columns != null);
        this.sstable = sstable;
        this.columns = columns;
        this.key = key;
        try {
            this.read(sstable, file, indexEntry);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, sstable.getFilename());
        }
    }

    private FileDataInput createFileDataInput(long position) {
        this.fileToClose = this.sstable.getFileDataInput(position);
        return this.fileToClose;
    }

    private void read(SSTableReader sstable, FileDataInput file, RowIndexEntry indexEntry) throws IOException {
        if (!indexEntry.isIndexed()) {
            if (file == null) {
                file = this.createFileDataInput(indexEntry.position);
            } else {
                file.seek(indexEntry.position);
            }
            DecoratedKey keyInDisk = sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(file));
            assert (keyInDisk.equals(this.key)) : String.format("%s != %s in %s", keyInDisk, this.key, file.getPath());
        }
        List<IndexHelper.IndexInfo> indexList = indexEntry.columnsIndex();
        if (!indexEntry.isIndexed()) {
            ColumnFamilySerializer serializer = ColumnFamily.serializer;
            try {
                this.cf = ArrayBackedSortedColumns.factory.create(sstable.metadata);
                this.cf.delete(DeletionTime.serializer.deserialize(file));
            }
            catch (Exception e) {
                throw new IOException(serializer + " failed to deserialize " + sstable.getColumnFamilyName() + " with " + sstable.metadata + " from " + file, e);
            }
        } else {
            this.cf = ArrayBackedSortedColumns.factory.create(sstable.metadata);
            this.cf.delete(indexEntry.deletionTime());
        }
        ArrayList<OnDiskAtom> result = new ArrayList<OnDiskAtom>();
        if (indexList.isEmpty()) {
            this.readSimpleColumns(file, this.columns, result);
        } else {
            this.readIndexedColumns(sstable.metadata, file, this.columns, indexList, indexEntry.position, result);
        }
        this.iter = result.iterator();
    }

    private void readSimpleColumns(FileDataInput file, SortedSet<CellName> columnNames, List<OnDiskAtom> result) {
        Iterator<OnDiskAtom> atomIterator = this.cf.metadata().getOnDiskIterator(file, this.sstable.descriptor.version);
        int n = 0;
        while (atomIterator.hasNext()) {
            OnDiskAtom column = atomIterator.next();
            if (column instanceof Cell) {
                if (!columnNames.contains(column.name())) continue;
                result.add(column);
                if (++n < this.columns.size()) continue;
                break;
            }
            result.add(column);
        }
    }

    private void readIndexedColumns(CFMetaData metadata, FileDataInput file, SortedSet<CellName> columnNames, List<IndexHelper.IndexInfo> indexList, long basePosition, List<OnDiskAtom> result) throws IOException {
        CellNameType comparator = metadata.comparator;
        ArrayList<IndexHelper.IndexInfo> ranges = new ArrayList<IndexHelper.IndexInfo>();
        int lastIndexIdx = -1;
        for (CellName name : columnNames) {
            int index = IndexHelper.indexFor(name, indexList, comparator, false, lastIndexIdx);
            if (index < 0 || index == indexList.size()) continue;
            IndexHelper.IndexInfo indexInfo = indexList.get(index);
            if (comparator.compare(name, indexInfo.firstName) < 0 || index == lastIndexIdx) continue;
            ranges.add(indexInfo);
            lastIndexIdx = index;
        }
        if (ranges.isEmpty()) {
            return;
        }
        Iterator toFetch = columnNames.iterator();
        CellName nextToFetch = (CellName)toFetch.next();
        for (IndexHelper.IndexInfo indexInfo : ranges) {
            long positionToSeek = basePosition + indexInfo.offset;
            if (file == null) {
                file = this.createFileDataInput(positionToSeek);
            }
            AtomDeserializer deserializer = this.cf.metadata().getOnDiskDeserializer(file, this.sstable.descriptor.version);
            file.seek(positionToSeek);
            FileMark mark = file.mark();
            while (file.bytesPastMark(mark) < indexInfo.width && nextToFetch != null) {
                int cmp = deserializer.compareNextTo(nextToFetch);
                if (cmp == 0) {
                    nextToFetch = toFetch.hasNext() ? (CellName)toFetch.next() : null;
                    result.add(deserializer.readNext());
                    continue;
                }
                deserializer.skipNext();
                if (cmp <= 0) continue;
                nextToFetch = toFetch.hasNext() ? (CellName)toFetch.next() : null;
            }
        }
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.cf;
    }

    protected OnDiskAtom computeNext() {
        if (this.iter == null || !this.iter.hasNext()) {
            return (OnDiskAtom)this.endOfData();
        }
        return this.iter.next();
    }

    @Override
    public void close() throws IOException {
    }
}

