/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class SingleColumnRestriction
implements Restriction {
    @Override
    public boolean isMultiColumn() {
        return false;
    }

    public static class Contains
    extends SingleColumnRestriction {
        private List<Term> values;
        private List<Term> keys;

        public boolean hasContains() {
            return this.values != null;
        }

        public boolean hasContainsKey() {
            return this.keys != null;
        }

        public void add(Term t, boolean isKey) {
            if (isKey) {
                this.addKey(t);
            } else {
                this.addValue(t);
            }
        }

        public void addValue(Term t) {
            if (this.values == null) {
                this.values = new ArrayList<Term>();
            }
            this.values.add(t);
        }

        public void addKey(Term t) {
            if (this.keys == null) {
                this.keys = new ArrayList<Term>();
            }
            this.keys.add(t);
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            if (this.values == null) {
                return Collections.emptyList();
            }
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
            for (Term value : this.values) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        public List<ByteBuffer> keys(QueryOptions options) throws InvalidRequestException {
            if (this.keys == null) {
                return Collections.emptyList();
            }
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.keys.size());
            for (Term value : this.keys) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return true;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        public String toString() {
            return String.format("CONTAINS(values=%s, keys=%s)", this.values, this.keys);
        }
    }

    public static class Slice
    extends SingleColumnRestriction
    implements Restriction.Slice {
        protected final Term[] bounds = new Term[2];
        protected final boolean[] boundInclusive = new boolean[2];
        protected final boolean onToken;

        public Slice(boolean onToken) {
            this.onToken = onToken;
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        @Override
        public boolean hasBound(Bound b) {
            return this.bounds[b.idx] != null;
        }

        @Override
        public ByteBuffer bound(Bound b, QueryOptions options) throws InvalidRequestException {
            return this.bounds[b.idx].bindAndGet(options);
        }

        @Override
        public boolean isInclusive(Bound b) {
            return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
        }

        @Override
        public Relation.Type getRelation(Bound eocBound, Bound inclusiveBound) {
            switch (eocBound) {
                case START: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.GTE : Relation.Type.GT;
                }
                case END: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.LTE : Relation.Type.LT;
                }
            }
            throw new AssertionError();
        }

        @Override
        public IndexExpression.Operator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? IndexExpression.Operator.GTE : IndexExpression.Operator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? IndexExpression.Operator.LTE : IndexExpression.Operator.LT;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void setBound(ColumnIdentifier name, Relation.Type type, Term t) throws InvalidRequestException {
            boolean inclusive;
            Bound b;
            switch (type) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = false;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.bounds[b.idx] != null) {
                throw new InvalidRequestException(String.format("More than one restriction was found for the %s bound on %s", b.name().toLowerCase(), name));
            }
            this.bounds[b.idx] = t;
            this.boundInclusive[b.idx] = inclusive;
        }

        public String toString() {
            return String.format("SLICE(%s %s, %s %s)%s", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1], this.onToken ? "*" : "");
        }
    }

    public static class InWithMarker
    extends SingleColumnRestriction
    implements Restriction.IN {
        protected final AbstractMarker marker;

        public InWithMarker(AbstractMarker marker) {
            this.marker = marker;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            Term.MultiItemTerminal lval = (Term.MultiItemTerminal)this.marker.bind(options);
            if (lval == null) {
                throw new InvalidRequestException("Invalid null value for IN restriction");
            }
            return lval.getElements();
        }

        @Override
        public boolean canHaveOnlyOneValue() {
            return false;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        public String toString() {
            return "IN ?";
        }
    }

    public static class InWithValues
    extends SingleColumnRestriction
    implements Restriction.IN {
        protected final List<Term> values;

        public InWithValues(List<Term> values) {
            this.values = values;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
            for (Term value : this.values) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        @Override
        public boolean canHaveOnlyOneValue() {
            return this.values.size() == 1;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        public String toString() {
            return String.format("IN(%s)", this.values);
        }
    }

    public static class EQ
    extends SingleColumnRestriction
    implements Restriction.EQ {
        protected final Term value;
        private final boolean onToken;

        public EQ(Term value, boolean onToken) {
            this.value = value;
            this.onToken = onToken;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.value.bindAndGet(options));
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return true;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        public String toString() {
            return String.format("EQ(%s)%s", this.value, this.onToken ? "*" : "");
        }
    }
}

