/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public class DropTableStatement
extends SchemaAlteringStatement {
    private final boolean ifExists;

    public DropTableStatement(CFName name, boolean ifExists) {
        super(name);
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        block2: {
            try {
                state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.DROP);
            }
            catch (InvalidRequestException e) {
                if (this.ifExists) break block2;
                throw e;
            }
        }
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public void announceMigration(boolean isLocalOnly) throws ConfigurationException {
        block2: {
            try {
                MigrationManager.announceColumnFamilyDrop(this.keyspace(), this.columnFamily(), isLocalOnly);
            }
            catch (ConfigurationException e) {
                if (this.ifExists) break block2;
                throw e;
            }
        }
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

