/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.UTName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public class CreateTypeStatement
extends SchemaAlteringStatement {
    private final UTName name;
    private final List<ColumnIdentifier> columnNames = new ArrayList<ColumnIdentifier>();
    private final List<CQL3Type.Raw> columnTypes = new ArrayList<CQL3Type.Raw>();
    private final boolean ifNotExists;

    public CreateTypeStatement(UTName name, boolean ifNotExists) {
        this.name = name;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.name.hasKeyspace()) {
            this.name.setKeyspace(state.getKeyspace());
        }
    }

    public void addDefinition(ColumnIdentifier name, CQL3Type.Raw type) {
        this.columnNames.add(name);
        this.columnTypes.add(type);
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace(), Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        KSMetaData ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        if (ksm == null) {
            throw new InvalidRequestException(String.format("Cannot add type in unknown keyspace %s", this.name.getKeyspace()));
        }
        if (ksm.userTypes.getType(this.name.getUserTypeName()) != null && !this.ifNotExists) {
            throw new InvalidRequestException(String.format("A user type of name %s already exists", this.name));
        }
        for (CQL3Type.Raw type : this.columnTypes) {
            if (!type.isCounter()) continue;
            throw new InvalidRequestException("A user type cannot contain counters");
        }
    }

    public static void checkForDuplicateNames(UserType type) throws InvalidRequestException {
        for (int i = 0; i < type.size() - 1; ++i) {
            ByteBuffer fieldName = type.fieldName(i);
            for (int j = i + 1; j < type.size(); ++j) {
                if (!fieldName.equals(type.fieldName(j))) continue;
                throw new InvalidRequestException(String.format("Duplicate field name %s in type %s", UTF8Type.instance.getString(fieldName), UTF8Type.instance.getString(type.name)));
            }
        }
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TYPE, this.keyspace(), this.name.getStringTypeName());
    }

    @Override
    public String keyspace() {
        return this.name.getKeyspace();
    }

    private UserType createType() throws InvalidRequestException {
        ArrayList<ByteBuffer> names = new ArrayList<ByteBuffer>(this.columnNames.size());
        for (ColumnIdentifier name : this.columnNames) {
            names.add(name.bytes);
        }
        ArrayList types = new ArrayList(this.columnTypes.size());
        for (CQL3Type.Raw type : this.columnTypes) {
            types.add(type.prepare(this.keyspace()).getType());
        }
        return new UserType(this.name.getKeyspace(), this.name.getUserTypeName(), names, types);
    }

    @Override
    public void announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        KSMetaData ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        assert (ksm != null);
        if (ksm.userTypes.getType(this.name.getUserTypeName()) != null) {
            return;
        }
        UserType type = this.createType();
        CreateTypeStatement.checkForDuplicateNames(type);
        MigrationManager.announceNewType(type, isLocalOnly);
    }
}

