/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.TracingAwareExecutorService;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTracingAwareExecutorService
implements TracingAwareExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTracingAwareExecutorService.class);

    protected abstract void addTask(FutureTask<?> var1);

    protected abstract void onCompletion();

    public <T> FutureTask<T> submit(Callable<T> task) {
        return this.submit(this.newTaskFor(task));
    }

    public FutureTask<?> submit(Runnable task) {
        return this.submit(this.newTaskFor(task, null));
    }

    public <T> FutureTask<T> submit(Runnable task, T result) {
        return this.submit(this.newTaskFor(task, result));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    protected <T> FutureTask<T> newTaskFor(Runnable runnable, T result) {
        return this.newTaskFor(runnable, result, Tracing.instance.get());
    }

    protected <T> FutureTask<T> newTaskFor(Runnable runnable, T result, TraceState traceState) {
        if (traceState != null) {
            if (runnable instanceof TraceSessionFutureTask) {
                return (TraceSessionFutureTask)runnable;
            }
            return new TraceSessionFutureTask<T>(runnable, result, traceState);
        }
        if (runnable instanceof FutureTask) {
            return (FutureTask)runnable;
        }
        return new FutureTask<T>(runnable, result);
    }

    protected <T> FutureTask<T> newTaskFor(Callable<T> callable) {
        if (Tracing.isTracing()) {
            if (callable instanceof TraceSessionFutureTask) {
                return (TraceSessionFutureTask)((Object)callable);
            }
            return new TraceSessionFutureTask<T>(callable, Tracing.instance.get());
        }
        if (callable instanceof FutureTask) {
            return (FutureTask)((Object)callable);
        }
        return new FutureTask<T>(callable);
    }

    private <T> FutureTask<T> submit(FutureTask<T> task) {
        this.addTask(task);
        return task;
    }

    @Override
    public void execute(Runnable command) {
        this.addTask(this.newTaskFor(command, null));
    }

    @Override
    public void execute(Runnable command, TraceState state) {
        this.addTask(this.newTaskFor(command, null, state));
    }

    class FutureTask<T>
    extends SimpleCondition
    implements Future<T>,
    Runnable {
        private boolean failure;
        private Object result = this;
        private final Callable<T> callable;

        public FutureTask(Callable<T> callable) {
            this.callable = callable;
        }

        public FutureTask(Runnable runnable, T result) {
            this(Executors.callable(runnable, result));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.result = this.callable.call();
            }
            catch (Throwable t) {
                logger.warn("Uncaught exception on thread {}: {}", (Object)Thread.currentThread(), (Object)t);
                this.result = t;
                this.failure = true;
            }
            finally {
                this.signalAll();
                AbstractTracingAwareExecutorService.this.onCompletion();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.isSignaled();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.await();
            Object result = this.result;
            if (this.failure) {
                throw new ExecutionException((Throwable)result);
            }
            return (T)result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.await(timeout, unit);
            Object result = this.result;
            if (this.failure) {
                throw new ExecutionException((Throwable)result);
            }
            return (T)result;
        }
    }

    private class TraceSessionFutureTask<T>
    extends FutureTask<T> {
        private final TraceState state;

        public TraceSessionFutureTask(Callable<T> callable, TraceState state) {
            super(callable);
            this.state = state;
        }

        public TraceSessionFutureTask(Runnable runnable, T result, TraceState state) {
            super(runnable, result);
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TraceState oldState = Tracing.instance.get();
            Tracing.instance.set(this.state);
            try {
                super.run();
            }
            finally {
                Tracing.instance.set(oldState);
            }
        }
    }
}

