/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;

public class KeyCacheKey
implements CacheKey {
    public final UUID cfId;
    public final Descriptor desc;
    private static final long EMPTY_SIZE = ObjectSizes.measure(new KeyCacheKey(null, null, ByteBufferUtil.EMPTY_BYTE_BUFFER));
    public final byte[] key;

    public KeyCacheKey(UUID cfId, Descriptor desc, ByteBuffer key) {
        this.cfId = cfId;
        this.desc = desc;
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    @Override
    public CacheKey.PathInfo getPathInfo() {
        return new CacheKey.PathInfo(this.desc.ksname, this.desc.cfname, this.cfId);
    }

    public String toString() {
        return String.format("KeyCacheKey(%s, %s)", this.desc, ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.key)));
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyCacheKey that = (KeyCacheKey)o;
        return this.cfId.equals(that.cfId) && this.desc.equals(that.desc) && Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.cfId.hashCode();
        result = 31 * result + this.desc.hashCode();
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }
}

