/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.github.jamm.MemoryLayoutSpecification;
import org.github.jamm.MemoryMeter;

public class ObjectSizes {
    private static final MemoryMeter meter = new MemoryMeter().omitSharedBufferOverhead().withGuessing(MemoryMeter.Guess.FALLBACK_UNSAFE);
    private static final long BUFFER_EMPTY_SIZE = ObjectSizes.measure(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    private static final long STRING_EMPTY_SIZE = ObjectSizes.measure("");

    public static long sizeOfArray(byte[] bytes) {
        return ObjectSizes.sizeOfArray(bytes.length, 1L);
    }

    public static long sizeOfArray(long[] longs) {
        return ObjectSizes.sizeOfArray(longs.length, 8L);
    }

    public static long sizeOfArray(int[] ints) {
        return ObjectSizes.sizeOfArray(ints.length, 4L);
    }

    public static long sizeOfReferenceArray(int length) {
        return ObjectSizes.sizeOfArray(length, MemoryLayoutSpecification.SPEC.getReferenceSize());
    }

    public static long sizeOfArray(Object[] objects) {
        return ObjectSizes.sizeOfReferenceArray(objects.length);
    }

    private static long sizeOfArray(int length, long elementSize) {
        return MemoryLayoutSpecification.sizeOfArray((int)length, (long)elementSize);
    }

    public static long sizeOnHeapOf(ByteBuffer[] array) {
        long allElementsSize = 0L;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            allElementsSize += ObjectSizes.sizeOnHeapOf(array[i]);
        }
        return allElementsSize + ObjectSizes.sizeOfArray(array);
    }

    public static long sizeOnHeapExcludingData(ByteBuffer[] array) {
        return BUFFER_EMPTY_SIZE * (long)array.length + ObjectSizes.sizeOfArray(array);
    }

    public static long sizeOnHeapOf(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            return BUFFER_EMPTY_SIZE;
        }
        if (buffer.capacity() > buffer.remaining()) {
            return buffer.remaining();
        }
        return BUFFER_EMPTY_SIZE + ObjectSizes.sizeOfArray(buffer.capacity(), 1L);
    }

    public static long sizeOnHeapExcludingData(ByteBuffer buffer) {
        return BUFFER_EMPTY_SIZE;
    }

    public static long sizeOf(String str) {
        return STRING_EMPTY_SIZE + ObjectSizes.sizeOfArray(str.length(), 2L);
    }

    public static long measureDeep(Object pojo) {
        return meter.measureDeep(pojo);
    }

    public static long measure(Object pojo) {
        return meter.measure(pojo);
    }
}

