/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;

public class NodePair {
    public static IVersionedSerializer<NodePair> serializer = new NodePairSerializer();
    public final InetAddress endpoint1;
    public final InetAddress endpoint2;

    public NodePair(InetAddress endpoint1, InetAddress endpoint2) {
        this.endpoint1 = endpoint1;
        this.endpoint2 = endpoint2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePair nodePair = (NodePair)o;
        return this.endpoint1.equals(nodePair.endpoint1) && this.endpoint2.equals(nodePair.endpoint2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.endpoint1, this.endpoint2});
    }

    public static class NodePairSerializer
    implements IVersionedSerializer<NodePair> {
        @Override
        public void serialize(NodePair nodePair, DataOutputPlus out, int version) throws IOException {
            CompactEndpointSerializationHelper.serialize(nodePair.endpoint1, out);
            CompactEndpointSerializationHelper.serialize(nodePair.endpoint2, out);
        }

        @Override
        public NodePair deserialize(DataInput in, int version) throws IOException {
            InetAddress ep1 = CompactEndpointSerializationHelper.deserialize(in);
            InetAddress ep2 = CompactEndpointSerializationHelper.deserialize(in);
            return new NodePair(ep1, ep2);
        }

        @Override
        public long serializedSize(NodePair nodePair, int version) {
            return 2 * CompactEndpointSerializationHelper.serializedSize(nodePair.endpoint1);
        }
    }
}

