/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.io.util.FastByteArrayOutputStream;

public final class DataOutputBuffer
extends DataOutputStreamPlus {
    public DataOutputBuffer() {
        this(128);
    }

    public DataOutputBuffer(int size) {
        super(new FastByteArrayOutputStream(size));
    }

    @Override
    public void write(int b) {
        try {
            super.write(b);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        try {
            super.write(b, off, len);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        ((FastByteArrayOutputStream)this.out).write(buffer);
    }

    public byte[] getData() {
        return ((FastByteArrayOutputStream)this.out).buf;
    }

    public byte[] toByteArray() {
        FastByteArrayOutputStream out = (FastByteArrayOutputStream)this.out;
        return Arrays.copyOfRange(out.buf, 0, out.count);
    }

    public ByteBuffer asByteBuffer() {
        FastByteArrayOutputStream out = (FastByteArrayOutputStream)this.out;
        return ByteBuffer.wrap(out.buf, 0, out.count);
    }

    public int getLength() {
        return ((FastByteArrayOutputStream)this.out).count;
    }
}

