/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractPartitioner;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;

public class LocalPartitioner
extends AbstractPartitioner<LocalToken> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new LocalToken(null, null));
    private final AbstractType<?> comparator;

    public LocalPartitioner(AbstractType<?> comparator) {
        this.comparator = comparator;
    }

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new BufferDecoratedKey(this.getToken(key), key);
    }

    @Override
    public Token midpoint(Token left, Token right) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalToken getMinimumToken() {
        return new LocalToken(this.comparator, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public LocalToken getToken(ByteBuffer key) {
        return new LocalToken(this.comparator, key);
    }

    @Override
    public long getHeapSizeOf(LocalToken token) {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf((ByteBuffer)token.token);
    }

    @Override
    public LocalToken getRandomToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        return Collections.singletonMap(this.getMinimumToken(), new Float(1.0));
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return this.comparator;
    }
}

