/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public class BufferDeletedCell
extends BufferCell
implements DeletedCell {
    public BufferDeletedCell(CellName name, int localDeletionTime, long timestamp) {
        this(name, ByteBufferUtil.bytes(localDeletionTime), timestamp);
    }

    public BufferDeletedCell(CellName name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    @Override
    public Cell withUpdatedName(CellName newName) {
        return new BufferDeletedCell(newName, this.value, this.timestamp);
    }

    @Override
    public Cell withUpdatedTimestamp(long newTimestamp) {
        return new BufferDeletedCell(this.name, this.value, newTimestamp);
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public boolean isLive(long now) {
        return false;
    }

    @Override
    public int getLocalDeletionTime() {
        return this.value().getInt(this.value.position());
    }

    @Override
    public Cell reconcile(Cell cell) {
        if (cell instanceof DeletedCell) {
            return super.reconcile(cell);
        }
        return cell.reconcile(this);
    }

    @Override
    public DeletedCell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        return new BufferDeletedCell(this.name.copy(metadata, allocator), allocator.clone(this.value), this.timestamp);
    }

    @Override
    public DeletedCell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        return allocator.clone(this, metadata, opGroup);
    }

    @Override
    public int serializationFlags() {
        return 1;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        if (this.value().remaining() != 4) {
            throw new MarshalException("A tombstone value should be 4 bytes long");
        }
        if (this.getLocalDeletionTime() < 0) {
            throw new MarshalException("The local deletion time should not be negative");
        }
    }

    @Override
    public boolean equals(Cell cell) {
        return this.timestamp() == cell.timestamp() && this.getLocalDeletionTime() == cell.getLocalDeletionTime() && this.name().equals(cell.name());
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name().toByteBuffer().duplicate());
        FBUtilities.updateWithLong(digest, this.timestamp());
        FBUtilities.updateWithByte(digest, this.serializationFlags());
    }
}

