/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Constants {
    private static final Logger logger = LoggerFactory.getLogger(Constants.class);
    public static final Term.Raw NULL_LITERAL = new Term.Raw(){
        private final Term.Terminal NULL_VALUE = new Value(null){

            @Override
            public Term.Terminal bind(QueryOptions options) {
                return null;
            }
        };

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!this.isAssignableTo(keyspace, receiver)) {
                throw new InvalidRequestException("Invalid null value for counter increment/decrement");
            }
            return this.NULL_VALUE;
        }

        @Override
        public boolean isAssignableTo(String keyspace, ColumnSpecification receiver) {
            return !(receiver.type instanceof CounterColumnType);
        }

        public String toString() {
            return null;
        }
    };

    public static class Deleter
    extends Operation {
        public Deleter(ColumnDefinition column) {
            super(column, null);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            CellName cname = cf.getComparator().create(prefix, this.column);
            if (this.column.type.isCollection()) {
                cf.addAtom(params.makeRangeTombstone(cname.slice()));
            } else {
                cf.addColumn(params.makeTombstone(cname));
            }
        }
    }

    public static class Substracter
    extends Operation {
        public Substracter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer bytes = this.t.bindAndGet(params.options);
            if (bytes == null) {
                throw new InvalidRequestException("Invalid null value for counter increment");
            }
            long increment = ByteBufferUtil.toLong(bytes);
            if (increment == Long.MIN_VALUE) {
                throw new InvalidRequestException("The negation of " + increment + " overflows supported counter precision (signed 8 bytes integer)");
            }
            CellName cname = cf.getComparator().create(prefix, this.column);
            cf.addCounter(cname, -increment);
        }
    }

    public static class Adder
    extends Operation {
        public Adder(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer bytes = this.t.bindAndGet(params.options);
            if (bytes == null) {
                throw new InvalidRequestException("Invalid null value for counter increment");
            }
            long increment = ByteBufferUtil.toLong(bytes);
            CellName cname = cf.getComparator().create(prefix, this.column);
            cf.addCounter(cname, increment);
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            CellName cname = cf.getComparator().create(prefix, this.column);
            ByteBuffer value = this.t.bindAndGet(params.options);
            cf.addColumn(value == null ? params.makeTombstone(cname) : params.makeColumn(cname, value));
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (!receiver.type.isCollection());
        }

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            try {
                ByteBuffer value = options.getValues().get(this.bindIndex);
                if (value != null) {
                    this.receiver.type.validate(value);
                }
                return value;
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer bytes = this.bindAndGet(options);
            return bytes == null ? null : new Value(bytes);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final ByteBuffer bytes;

        public Value(ByteBuffer bytes) {
            this.bytes = bytes;
        }

        @Override
        public ByteBuffer get(QueryOptions options) {
            return this.bytes;
        }

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) {
            return this.bytes;
        }

        public String toString() {
            return ByteBufferUtil.bytesToHex(this.bytes);
        }
    }

    public static class Literal
    implements Term.Raw {
        private final Type type;
        private final String text;

        private Literal(Type type, String text) {
            assert (type != null && text != null);
            this.type = type;
            this.text = text;
        }

        public static Literal string(String text) {
            return new Literal(Type.STRING, text);
        }

        public static Literal integer(String text) {
            return new Literal(Type.INTEGER, text);
        }

        public static Literal floatingPoint(String text) {
            return new Literal(Type.FLOAT, text);
        }

        public static Literal uuid(String text) {
            return new Literal(Type.UUID, text);
        }

        public static Literal bool(String text) {
            return new Literal(Type.BOOLEAN, text);
        }

        public static Literal hex(String text) {
            return new Literal(Type.HEX, text);
        }

        @Override
        public Value prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!this.isAssignableTo(keyspace, receiver)) {
                throw new InvalidRequestException(String.format("Invalid %s constant (%s) for \"%s\" of type %s", new Object[]{this.type, this.text, receiver.name, receiver.type.asCQL3Type()}));
            }
            return new Value(this.parsedValue(receiver.type));
        }

        private ByteBuffer parsedValue(AbstractType<?> validator) throws InvalidRequestException {
            if (validator instanceof ReversedType) {
                validator = ((ReversedType)validator).baseType;
            }
            try {
                if (this.type == Type.HEX && validator instanceof BytesType) {
                    return validator.fromString(this.text.substring(2));
                }
                if (validator instanceof CounterColumnType) {
                    return LongType.instance.fromString(this.text);
                }
                return validator.fromString(this.text);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        public String getRawText() {
            return this.text;
        }

        @Override
        public boolean isAssignableTo(String keyspace, ColumnSpecification receiver) {
            CQL3Type receiverType = receiver.type.asCQL3Type();
            if (receiverType.isCollection()) {
                return false;
            }
            if (!(receiverType instanceof CQL3Type.Native)) {
                return true;
            }
            CQL3Type.Native nt = (CQL3Type.Native)receiverType;
            switch (this.type) {
                case STRING: {
                    switch (nt) {
                        case ASCII: 
                        case TEXT: 
                        case INET: 
                        case VARCHAR: 
                        case TIMESTAMP: {
                            return true;
                        }
                    }
                    return false;
                }
                case INTEGER: {
                    switch (nt) {
                        case TIMESTAMP: 
                        case BIGINT: 
                        case COUNTER: 
                        case DECIMAL: 
                        case DOUBLE: 
                        case FLOAT: 
                        case INT: 
                        case VARINT: {
                            return true;
                        }
                    }
                    return false;
                }
                case UUID: {
                    switch (nt) {
                        case UUID: 
                        case TIMEUUID: {
                            return true;
                        }
                    }
                    return false;
                }
                case FLOAT: {
                    switch (nt) {
                        case DECIMAL: 
                        case DOUBLE: 
                        case FLOAT: {
                            return true;
                        }
                    }
                    return false;
                }
                case BOOLEAN: {
                    switch (nt) {
                        case BOOLEAN: {
                            return true;
                        }
                    }
                    return false;
                }
                case HEX: {
                    switch (nt) {
                        case BLOB: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        public String toString() {
            return this.type == Type.STRING ? String.format("'%s'", this.text) : this.text;
        }
    }

    public static enum Type {
        STRING,
        INTEGER,
        UUID,
        FLOAT,
        BOOLEAN,
        HEX;

    }
}

