/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.config.ReadRepairDecision;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.TriggerDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.db.AbstractCell;
import org.apache.cassandra.db.AtomDeserializer;
import org.apache.cassandra.db.CFRowAdder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundCType;
import org.apache.cassandra.db.composites.SimpleCType;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.LZ4Compressor;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CFMetaData {
    private static final Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final double DEFAULT_READ_REPAIR_CHANCE = 0.0;
    public static final double DEFAULT_DCLOCAL_READ_REPAIR_CHANCE = 0.1;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final Class<? extends AbstractCompactionStrategy> DEFAULT_COMPACTION_STRATEGY_CLASS = SizeTieredCompactionStrategy.class;
    public static final CachingOptions DEFAULT_CACHING_STRATEGY = CachingOptions.KEYS_ONLY;
    public static final int DEFAULT_DEFAULT_TIME_TO_LIVE = 0;
    public static final SpeculativeRetry DEFAULT_SPECULATIVE_RETRY = new SpeculativeRetry(SpeculativeRetry.RetryType.PERCENTILE, 0.99);
    public static final int DEFAULT_MIN_INDEX_INTERVAL = 128;
    public static final int DEFAULT_MAX_INDEX_INTERVAL = 2048;
    public static final String DEFAULT_COMPRESSOR = LZ4Compressor.class.getCanonicalName();
    private static final Comparator<ColumnDefinition> regularColumnComparator = new Comparator<ColumnDefinition>(){

        @Override
        public int compare(ColumnDefinition def1, ColumnDefinition def2) {
            return ByteBufferUtil.compareUnsigned(def1.name.bytes, def2.name.bytes);
        }
    };
    public static final CFMetaData IndexCf = CFMetaData.compile("CREATE TABLE \"IndexInfo\" (table_name text,index_name text,PRIMARY KEY (table_name, index_name)) WITH COMPACT STORAGE AND COMMENT='indexes that have been completed'");
    public static final CFMetaData SchemaKeyspacesCf = CFMetaData.compile("CREATE TABLE schema_keyspaces (keyspace_name text PRIMARY KEY,durable_writes boolean,strategy_class text,strategy_options text) WITH COMPACT STORAGE AND COMMENT='keyspace definitions' AND gc_grace_seconds=8640");
    public static final CFMetaData SchemaColumnFamiliesCf = CFMetaData.compile("CREATE TABLE schema_columnfamilies (keyspace_name text,columnfamily_name text,cf_id uuid,type text,comparator text,subcomparator text,comment text,read_repair_chance double,local_read_repair_chance double,gc_grace_seconds int,default_validator text,key_validator text,min_compaction_threshold int,max_compaction_threshold int,memtable_flush_period_in_ms int,key_aliases text,bloom_filter_fp_chance double,caching text,default_time_to_live int,compaction_strategy_class text,compression_parameters text,value_alias text,column_aliases text,compaction_strategy_options text,speculative_retry text,populate_io_cache_on_flush boolean,index_interval int,min_index_interval int,max_index_interval int,dropped_columns map<text, bigint>,rows_per_partition_to_cache text,PRIMARY KEY (keyspace_name, columnfamily_name)) WITH COMMENT='ColumnFamily definitions' AND gc_grace_seconds=8640");
    public static final CFMetaData SchemaColumnsCf = CFMetaData.compile("CREATE TABLE schema_columns (keyspace_name text,columnfamily_name text,column_name text,validator text,index_type text,index_options text,index_name text,component_index int,type text,PRIMARY KEY(keyspace_name, columnfamily_name, column_name)) WITH COMMENT='ColumnFamily column attributes' AND gc_grace_seconds=8640");
    public static final CFMetaData SchemaTriggersCf = CFMetaData.compile("CREATE TABLE schema_triggers (keyspace_name text,columnfamily_name text,trigger_name text,trigger_options map<text, text>,PRIMARY KEY (keyspace_name, columnfamily_name, trigger_name)) WITH COMMENT='triggers metadata table'");
    public static final CFMetaData SchemaUserTypesCf = CFMetaData.compile("CREATE TABLE schema_usertypes (keyspace_name text,type_name text,field_names list<text>,field_types list<text>,PRIMARY KEY (keyspace_name, type_name)) WITH COMMENT='Defined user types' AND gc_grace_seconds=8640");
    public static final CFMetaData HintsCf = CFMetaData.compile("CREATE TABLE hints (target_id uuid,hint_id timeuuid,message_version int,mutation blob,PRIMARY KEY (target_id, hint_id, message_version)) WITH COMPACT STORAGE AND COMPACTION={'class' : 'SizeTieredCompactionStrategy', 'enabled' : false} AND COMMENT='hints awaiting delivery'AND gc_grace_seconds=0");
    public static final CFMetaData PeersCf = CFMetaData.compile("CREATE TABLE peers (peer inet PRIMARY KEY,host_id uuid,tokens set<varchar>,schema_version uuid,release_version text,rpc_address inet,preferred_ip inet,data_center text,rack text) WITH COMMENT='known peers in the cluster'");
    public static final CFMetaData PeerEventsCf = CFMetaData.compile("CREATE TABLE peer_events (peer inet PRIMARY KEY,hints_dropped map<uuid, int>) WITH COMMENT='cf contains events related to peers'");
    public static final CFMetaData LocalCf = CFMetaData.compile("CREATE TABLE local (key text PRIMARY KEY,tokens set<varchar>,cluster_name text,gossip_generation int,bootstrapped text,host_id uuid,release_version text,thrift_version text,cql_version text,native_protocol_version text,data_center text,rack text,partitioner text,schema_version uuid,truncated_at map<uuid, blob>) WITH COMMENT='information about the local node'");
    public static final CFMetaData TraceSessionsCf = CFMetaData.compile("CREATE TABLE sessions (session_id uuid PRIMARY KEY,coordinator inet,request text,started_at timestamp,parameters map<text, text>,duration int) WITH COMMENT='traced sessions'", "system_traces");
    public static final CFMetaData TraceEventsCf = CFMetaData.compile("CREATE TABLE events (session_id uuid,event_id timeuuid,source inet,thread text,activity text,source_elapsed int,PRIMARY KEY (session_id, event_id))", "system_traces");
    public static final CFMetaData BatchlogCf = CFMetaData.compile("CREATE TABLE batchlog (id uuid PRIMARY KEY,written_at timestamp,data blob,version int,) WITH COMMENT='uncommited batches' AND gc_grace_seconds=0 AND COMPACTION={'class' : 'SizeTieredCompactionStrategy', 'min_threshold' : 2}");
    public static final CFMetaData RangeXfersCf = CFMetaData.compile("CREATE TABLE range_xfers (token_bytes blob PRIMARY KEY,requested_at timestamp) WITH COMMENT='ranges requested for transfer here'");
    public static final CFMetaData CompactionLogCf = CFMetaData.compile("CREATE TABLE compactions_in_progress (id uuid PRIMARY KEY,keyspace_name text,columnfamily_name text,inputs set<int>) WITH COMMENT='unfinished compactions'");
    public static final CFMetaData PaxosCf = CFMetaData.compile("CREATE TABLE paxos (row_key blob,cf_id UUID,in_progress_ballot timeuuid,proposal_ballot timeuuid,proposal blob,most_recent_commit_at timeuuid,most_recent_commit blob,PRIMARY KEY (row_key, cf_id)) WITH COMMENT='in-progress paxos proposals'");
    public static final CFMetaData SSTableActivityCF = CFMetaData.compile("CREATE TABLE sstable_activity (keyspace_name text,columnfamily_name text,generation int,rate_15m double,rate_120m double,PRIMARY KEY ((keyspace_name, columnfamily_name, generation))) WITH COMMENT='historic sstable read rates'");
    public static final CFMetaData CompactionHistoryCf = CFMetaData.compile("CREATE TABLE compaction_history (id uuid,keyspace_name text,columnfamily_name text,compacted_at timestamp,bytes_in bigint,bytes_out bigint,rows_merged map<int, bigint>,PRIMARY KEY (id)) WITH COMMENT='show all compaction history' AND DEFAULT_TIME_TO_LIVE=604800");
    public final UUID cfId;
    public final String ksName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public volatile CellNameType comparator;
    private volatile String comment = "";
    private volatile double readRepairChance = 0.0;
    private volatile double dcLocalReadRepairChance = 0.1;
    private volatile int gcGraceSeconds = 864000;
    private volatile AbstractType<?> defaultValidator = BytesType.instance;
    private volatile AbstractType<?> keyValidator = BytesType.instance;
    private volatile int minCompactionThreshold = 4;
    private volatile int maxCompactionThreshold = 32;
    private volatile Double bloomFilterFpChance = null;
    private volatile CachingOptions caching = DEFAULT_CACHING_STRATEGY;
    private volatile int minIndexInterval = 128;
    private volatile int maxIndexInterval = 2048;
    private volatile int memtableFlushPeriod = 0;
    private volatile int defaultTimeToLive = 0;
    private volatile SpeculativeRetry speculativeRetry = DEFAULT_SPECULATIVE_RETRY;
    private volatile Map<ColumnIdentifier, Long> droppedColumns = new HashMap<ColumnIdentifier, Long>();
    private volatile Map<String, TriggerDefinition> triggers = new HashMap<String, TriggerDefinition>();
    private volatile boolean isPurged = false;
    public static final String DEFAULT_KEY_ALIAS = "key";
    public static final String DEFAULT_COLUMN_ALIAS = "column";
    public static final String DEFAULT_VALUE_ALIAS = "value";
    private volatile Map<ByteBuffer, ColumnDefinition> columnMetadata = new HashMap<ByteBuffer, ColumnDefinition>();
    private volatile List<ColumnDefinition> partitionKeyColumns;
    private volatile List<ColumnDefinition> clusteringColumns;
    private volatile SortedSet<ColumnDefinition> regularColumns;
    private volatile SortedSet<ColumnDefinition> staticColumns;
    private volatile ColumnDefinition compactValueColumn;
    public volatile Class<? extends AbstractCompactionStrategy> compactionStrategyClass = DEFAULT_COMPACTION_STRATEGY_CLASS;
    public volatile Map<String, String> compactionStrategyOptions = new HashMap<String, String>();
    public volatile CompressionParameters compressionParameters = new CompressionParameters(null);

    public CFMetaData comment(String prop) {
        this.comment = Strings.nullToEmpty((String)prop);
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData dcLocalReadRepairChance(double prop) {
        this.dcLocalReadRepairChance = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData defaultValidator(AbstractType<?> prop) {
        this.defaultValidator = prop;
        return this;
    }

    public CFMetaData keyValidator(AbstractType<?> prop) {
        this.keyValidator = prop;
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData compactionStrategyClass(Class<? extends AbstractCompactionStrategy> prop) {
        this.compactionStrategyClass = prop;
        return this;
    }

    public CFMetaData compactionStrategyOptions(Map<String, String> prop) {
        this.compactionStrategyOptions = prop;
        return this;
    }

    public CFMetaData compressionParameters(CompressionParameters prop) {
        this.compressionParameters = prop;
        return this;
    }

    public CFMetaData bloomFilterFpChance(Double prop) {
        this.bloomFilterFpChance = prop;
        return this;
    }

    public CFMetaData caching(CachingOptions prop) {
        this.caching = prop;
        return this;
    }

    public CFMetaData minIndexInterval(int prop) {
        this.minIndexInterval = prop;
        return this;
    }

    public CFMetaData maxIndexInterval(int prop) {
        this.maxIndexInterval = prop;
        return this;
    }

    public CFMetaData memtableFlushPeriod(int prop) {
        this.memtableFlushPeriod = prop;
        return this;
    }

    public CFMetaData defaultTimeToLive(int prop) {
        this.defaultTimeToLive = prop;
        return this;
    }

    public CFMetaData speculativeRetry(SpeculativeRetry prop) {
        this.speculativeRetry = prop;
        return this;
    }

    public CFMetaData droppedColumns(Map<ColumnIdentifier, Long> cols) {
        this.droppedColumns = cols;
        return this;
    }

    public CFMetaData triggers(Map<String, TriggerDefinition> prop) {
        this.triggers = prop;
        return this;
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, CellNameType comp) {
        this(keyspace, name, type, comp, UUIDGen.getTimeUUID());
    }

    private CFMetaData(String keyspace, String name, ColumnFamilyType type, CellNameType comp, UUID id) {
        this.cfId = id;
        this.ksName = keyspace;
        this.cfName = name;
        this.cfType = type;
        this.comparator = comp;
    }

    public static CFMetaData denseCFMetaData(String keyspace, String name, AbstractType<?> comp, AbstractType<?> subcc) {
        CellNameType cellNameType = CellNames.fromAbstractType(CFMetaData.makeRawAbstractType(comp, subcc), true);
        return new CFMetaData(keyspace, name, subcc == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super, cellNameType);
    }

    public static CFMetaData sparseCFMetaData(String keyspace, String name, AbstractType<?> comp) {
        CellNameType cellNameType = CellNames.fromAbstractType(comp, false);
        return new CFMetaData(keyspace, name, ColumnFamilyType.Standard, cellNameType);
    }

    public static CFMetaData denseCFMetaData(String keyspace, String name, AbstractType<?> comp) {
        return CFMetaData.denseCFMetaData(keyspace, name, comp, null);
    }

    private static AbstractType<?> makeRawAbstractType(AbstractType<?> comparator, AbstractType<?> subComparator) {
        return subComparator == null ? comparator : CompositeType.getInstance(Arrays.asList(comparator, subComparator));
    }

    public Map<String, TriggerDefinition> getTriggers() {
        return this.triggers;
    }

    private static CFMetaData compile(String cql) {
        return CFMetaData.compile(cql, "system");
    }

    @VisibleForTesting
    public static CFMetaData compile(String cql, String keyspace) {
        try {
            CFStatement parsed = (CFStatement)QueryProcessor.parseStatement(cql);
            parsed.prepareKeyspace(keyspace);
            CreateTableStatement statement = (CreateTableStatement)parsed.prepare().statement;
            CFMetaData cfm = CFMetaData.newSystemMetadata(keyspace, statement.columnFamily(), "", statement.comparator);
            statement.applyPropertiesTo(cfm);
            return cfm.rebuild();
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static UUID generateLegacyCfId(String ksName, String cfName) {
        return UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])ksName.getBytes(), (byte[])cfName.getBytes()));
    }

    private static CFMetaData newSystemMetadata(String keyspace, String cfName, String comment, CellNameType comparator) {
        return new CFMetaData(keyspace, cfName, ColumnFamilyType.Standard, comparator, CFMetaData.generateLegacyCfId(keyspace, cfName)).comment(comment).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).memtableFlushPeriod(3600000);
    }

    public static CFMetaData newIndexMetadata(CFMetaData parent, ColumnDefinition info, CellNameType indexComparator) {
        CachingOptions indexCaching = parent.getCaching().keyCache.isEnabled() ? CachingOptions.KEYS_ONLY : CachingOptions.NONE;
        return new CFMetaData(parent.ksName, parent.indexColumnFamilyName(info), ColumnFamilyType.Standard, indexComparator, parent.cfId).keyValidator(info.type).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).caching(indexCaching).speculativeRetry(parent.speculativeRetry).compactionStrategyClass(parent.compactionStrategyClass).compactionStrategyOptions(parent.compactionStrategyOptions).reloadSecondaryIndexMetadata(parent).rebuild();
    }

    public CFMetaData reloadSecondaryIndexMetadata(CFMetaData parent) {
        this.minCompactionThreshold(parent.minCompactionThreshold);
        this.maxCompactionThreshold(parent.maxCompactionThreshold);
        this.compactionStrategyClass(parent.compactionStrategyClass);
        this.compactionStrategyOptions(parent.compactionStrategyOptions);
        this.compressionParameters(parent.compressionParameters);
        return this;
    }

    public CFMetaData copy() {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, this.cfType, this.comparator, this.cfId), this);
    }

    public CFMetaData copy(UUID newCfId) {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, this.cfType, this.comparator, newCfId), this);
    }

    static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        ArrayList<ColumnDefinition> clonedColumns = new ArrayList<ColumnDefinition>(oldCFMD.allColumns().size());
        for (ColumnDefinition cd : oldCFMD.allColumns()) {
            clonedColumns.add(cd.copy());
        }
        return newCFMD.addAllColumnDefinitions(clonedColumns).comment(oldCFMD.comment).readRepairChance(oldCFMD.readRepairChance).dcLocalReadRepairChance(oldCFMD.dcLocalReadRepairChance).gcGraceSeconds(oldCFMD.gcGraceSeconds).defaultValidator(oldCFMD.defaultValidator).keyValidator(oldCFMD.keyValidator).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).compactionStrategyClass(oldCFMD.compactionStrategyClass).compactionStrategyOptions(new HashMap<String, String>(oldCFMD.compactionStrategyOptions)).compressionParameters(oldCFMD.compressionParameters.copy()).bloomFilterFpChance(oldCFMD.bloomFilterFpChance).caching(oldCFMD.caching).defaultTimeToLive(oldCFMD.defaultTimeToLive).minIndexInterval(oldCFMD.minIndexInterval).maxIndexInterval(oldCFMD.maxIndexInterval).speculativeRetry(oldCFMD.speculativeRetry).memtableFlushPeriod(oldCFMD.memtableFlushPeriod).droppedColumns(new HashMap<ColumnIdentifier, Long>(oldCFMD.droppedColumns)).triggers(new HashMap<String, TriggerDefinition>(oldCFMD.triggers)).rebuild();
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + "." + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name.bytes) : info.getIndexName());
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isSuper() {
        return this.cfType == ColumnFamilyType.Super;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getDcLocalReadRepair() {
        return this.dcLocalReadRepairChance;
    }

    public ReadRepairDecision newReadRepairDecision() {
        double chance = FBUtilities.threadLocalRandom().nextDouble();
        if (this.getReadRepairChance() > chance) {
            return ReadRepairDecision.GLOBAL;
        }
        if (this.getDcLocalReadRepair() > chance) {
            return ReadRepairDecision.DC_LOCAL;
        }
        return ReadRepairDecision.NONE;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType<?> getDefaultValidator() {
        return this.defaultValidator;
    }

    public AbstractType<?> getKeyValidator() {
        return this.keyValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public String getCQL2KeyName() {
        if (this.partitionKeyColumns.size() > 1) {
            throw new IllegalStateException("Cannot acces column family with composite key from CQL < 3.0.0");
        }
        String str = this.partitionKeyColumns.get((int)0).name.toString();
        return str.equalsIgnoreCase(DEFAULT_KEY_ALIAS) ? str.toUpperCase() : str;
    }

    public CompressionParameters compressionParameters() {
        return this.compressionParameters;
    }

    public Collection<ColumnDefinition> allColumns() {
        return this.columnMetadata.values();
    }

    public Iterator<ColumnDefinition> allColumnsInSelectOrder() {
        return new AbstractIterator<ColumnDefinition>(){
            private final Iterator<ColumnDefinition> partitionKeyIter;
            private final Iterator<ColumnDefinition> clusteringIter;
            private boolean valueDone;
            private final Iterator<ColumnDefinition> staticIter;
            private final Iterator<ColumnDefinition> regularIter;
            {
                this.partitionKeyIter = CFMetaData.this.partitionKeyColumns.iterator();
                this.clusteringIter = CFMetaData.this.clusteringColumns.iterator();
                this.staticIter = CFMetaData.this.staticColumns.iterator();
                this.regularIter = CFMetaData.this.regularColumns.iterator();
            }

            protected ColumnDefinition computeNext() {
                if (this.partitionKeyIter.hasNext()) {
                    return this.partitionKeyIter.next();
                }
                if (this.clusteringIter.hasNext()) {
                    return this.clusteringIter.next();
                }
                if (this.staticIter.hasNext()) {
                    return this.staticIter.next();
                }
                if (CFMetaData.this.compactValueColumn != null && !this.valueDone) {
                    this.valueDone = true;
                    if (((CFMetaData)CFMetaData.this).compactValueColumn.name.bytes.hasRemaining()) {
                        return CFMetaData.this.compactValueColumn;
                    }
                }
                if (this.regularIter.hasNext()) {
                    return this.regularIter.next();
                }
                return (ColumnDefinition)this.endOfData();
            }
        };
    }

    public List<ColumnDefinition> partitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    public List<ColumnDefinition> clusteringColumns() {
        return this.clusteringColumns;
    }

    public Set<ColumnDefinition> regularColumns() {
        return this.regularColumns;
    }

    public Set<ColumnDefinition> staticColumns() {
        return this.staticColumns;
    }

    public Iterable<ColumnDefinition> regularAndStaticColumns() {
        return Iterables.concat(this.staticColumns, this.regularColumns);
    }

    public ColumnDefinition compactValueColumn() {
        return this.compactValueColumn;
    }

    public CType getKeyValidatorAsCType() {
        return this.keyValidator instanceof CompositeType ? new CompoundCType(((CompositeType)this.keyValidator).types) : new SimpleCType(this.keyValidator);
    }

    public double getBloomFilterFpChance() {
        return this.bloomFilterFpChance == null || this.bloomFilterFpChance == 0.0 ? (this.compactionStrategyClass == LeveledCompactionStrategy.class ? 0.1 : 0.01) : this.bloomFilterFpChance;
    }

    public CachingOptions getCaching() {
        return this.caching;
    }

    public int getMinIndexInterval() {
        return this.minIndexInterval;
    }

    public int getMaxIndexInterval() {
        return this.maxIndexInterval;
    }

    public SpeculativeRetry getSpeculativeRetry() {
        return this.speculativeRetry;
    }

    public int getMemtableFlushPeriod() {
        return this.memtableFlushPeriod;
    }

    public int getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public Map<ColumnIdentifier, Long> getDroppedColumns() {
        return this.droppedColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CFMetaData)) {
            return false;
        }
        CFMetaData other = (CFMetaData)o;
        return Objects.equal((Object)this.cfId, (Object)other.cfId) && Objects.equal((Object)this.ksName, (Object)other.ksName) && Objects.equal((Object)this.cfName, (Object)other.cfName) && Objects.equal((Object)((Object)this.cfType), (Object)((Object)other.cfType)) && Objects.equal((Object)this.comparator, (Object)other.comparator) && Objects.equal((Object)this.comment, (Object)other.comment) && Objects.equal((Object)this.readRepairChance, (Object)other.readRepairChance) && Objects.equal((Object)this.dcLocalReadRepairChance, (Object)other.dcLocalReadRepairChance) && Objects.equal((Object)this.gcGraceSeconds, (Object)other.gcGraceSeconds) && Objects.equal(this.defaultValidator, other.defaultValidator) && Objects.equal(this.keyValidator, other.keyValidator) && Objects.equal((Object)this.minCompactionThreshold, (Object)other.minCompactionThreshold) && Objects.equal((Object)this.maxCompactionThreshold, (Object)other.maxCompactionThreshold) && Objects.equal(this.columnMetadata, other.columnMetadata) && Objects.equal(this.compactionStrategyClass, other.compactionStrategyClass) && Objects.equal(this.compactionStrategyOptions, other.compactionStrategyOptions) && Objects.equal((Object)this.compressionParameters, (Object)other.compressionParameters) && Objects.equal((Object)this.bloomFilterFpChance, (Object)other.bloomFilterFpChance) && Objects.equal((Object)this.memtableFlushPeriod, (Object)other.memtableFlushPeriod) && Objects.equal((Object)this.caching, (Object)other.caching) && Objects.equal((Object)this.defaultTimeToLive, (Object)other.defaultTimeToLive) && Objects.equal((Object)this.minIndexInterval, (Object)other.minIndexInterval) && Objects.equal((Object)this.maxIndexInterval, (Object)other.maxIndexInterval) && Objects.equal((Object)this.speculativeRetry, (Object)other.speculativeRetry) && Objects.equal(this.droppedColumns, other.droppedColumns) && Objects.equal(this.triggers, other.triggers);
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.cfId).append((Object)this.ksName).append((Object)this.cfName).append((Object)this.cfType).append((Object)this.comparator).append((Object)this.comment).append(this.readRepairChance).append(this.dcLocalReadRepairChance).append(this.gcGraceSeconds).append(this.defaultValidator).append(this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append(this.columnMetadata).append(this.compactionStrategyClass).append(this.compactionStrategyOptions).append((Object)this.compressionParameters).append((Object)this.bloomFilterFpChance).append(this.memtableFlushPeriod).append((Object)this.caching).append(this.defaultTimeToLive).append(this.minIndexInterval).append(this.maxIndexInterval).append((Object)this.speculativeRetry).append(this.droppedColumns).append(this.triggers).toHashCode();
    }

    public AbstractType<?> getValueValidator(CellName cellName) {
        ColumnDefinition def = this.getColumnDefinition(cellName);
        return def == null ? this.defaultValidator : def.type;
    }

    private static void applyImplicitDefaults(CfDef cf_def) {
        if (!cf_def.isSetComment()) {
            cf_def.setComment("");
        }
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (cf_def.compaction_strategy == null) {
            cf_def.compaction_strategy = DEFAULT_COMPACTION_STRATEGY_CLASS.getSimpleName();
        }
        if (cf_def.compaction_strategy_options == null) {
            cf_def.compaction_strategy_options = Collections.emptyMap();
        }
        if (!cf_def.isSetCompression_options()) {
            cf_def.setCompression_options((Map)new HashMap<String, String>(){
                {
                    if (DEFAULT_COMPRESSOR != null) {
                        this.put("sstable_compression", DEFAULT_COMPRESSOR);
                    }
                }
            });
        }
        if (!cf_def.isSetDefault_time_to_live()) {
            cf_def.setDefault_time_to_live(0);
        }
        if (!cf_def.isSetDclocal_read_repair_chance()) {
            cf_def.setDclocal_read_repair_chance(0.1);
        }
        if (!cf_def.isSetMin_index_interval()) {
            if (cf_def.isSetIndex_interval()) {
                cf_def.setMin_index_interval(cf_def.getIndex_interval());
            } else {
                cf_def.setMin_index_interval(128);
            }
        }
        if (!cf_def.isSetMax_index_interval()) {
            cf_def.setMax_index_interval(Math.max(cf_def.min_index_interval, 2048));
        }
    }

    public static CFMetaData fromThrift(CfDef cf_def) throws InvalidRequestException, ConfigurationException {
        return CFMetaData.internalFromThrift(cf_def, Collections.emptyList());
    }

    public static CFMetaData fromThriftForUpdate(CfDef cf_def, CFMetaData toUpdate) throws InvalidRequestException, ConfigurationException {
        return CFMetaData.internalFromThrift(cf_def, toUpdate.allColumns());
    }

    private static CFMetaData internalFromThrift(CfDef cf_def, Collection<ColumnDefinition> previousCQLMetadata) throws InvalidRequestException, ConfigurationException {
        ColumnFamilyType cfType = ColumnFamilyType.create(cf_def.column_type);
        if (cfType == null) {
            throw new InvalidRequestException("Invalid column type " + cf_def.column_type);
        }
        CFMetaData.applyImplicitDefaults(cf_def);
        try {
            boolean hasKeyAlias;
            AbstractType<?> rawComparator = TypeParser.parse(cf_def.comparator_type);
            BytesType subComparator = cfType == ColumnFamilyType.Standard ? null : (cf_def.subcomparator_type == null ? BytesType.instance : TypeParser.parse(cf_def.subcomparator_type));
            AbstractType<?> fullRawComparator = CFMetaData.makeRawAbstractType(rawComparator, subComparator);
            AbstractType<?> keyValidator = cf_def.isSetKey_validation_class() ? TypeParser.parse(cf_def.key_validation_class) : null;
            List<ColumnDefinition> defs = ColumnDefinition.fromThrift(cf_def.keyspace, cf_def.name, rawComparator, subComparator, cf_def.column_metadata);
            boolean bl = hasKeyAlias = cf_def.isSetKey_alias() && keyValidator != null && !(keyValidator instanceof CompositeType);
            if (hasKeyAlias) {
                defs.add(ColumnDefinition.partitionKeyDef(cf_def.keyspace, cf_def.name, cf_def.key_alias, keyValidator, null));
            }
            for (ColumnDefinition def : previousCQLMetadata) {
                if (def.isPartOfCellName() || def.kind == ColumnDefinition.Kind.PARTITION_KEY && hasKeyAlias) continue;
                defs.add(def);
            }
            CellNameType comparator = CellNames.fromAbstractType(fullRawComparator, CFMetaData.isDense(fullRawComparator, defs));
            UUID cfId = Schema.instance.getId(cf_def.keyspace, cf_def.name);
            if (cfId == null) {
                cfId = UUIDGen.getTimeUUID();
            }
            CFMetaData newCFMD = new CFMetaData(cf_def.keyspace, cf_def.name, cfType, comparator, cfId);
            newCFMD.addAllColumnDefinitions(defs);
            if (keyValidator != null) {
                newCFMD.keyValidator(keyValidator);
            }
            if (cf_def.isSetGc_grace_seconds()) {
                newCFMD.gcGraceSeconds(cf_def.gc_grace_seconds);
            }
            if (cf_def.isSetMin_compaction_threshold()) {
                newCFMD.minCompactionThreshold(cf_def.min_compaction_threshold);
            }
            if (cf_def.isSetMax_compaction_threshold()) {
                newCFMD.maxCompactionThreshold(cf_def.max_compaction_threshold);
            }
            if (cf_def.isSetCompaction_strategy()) {
                newCFMD.compactionStrategyClass(CFMetaData.createCompactionStrategy(cf_def.compaction_strategy));
            }
            if (cf_def.isSetCompaction_strategy_options()) {
                newCFMD.compactionStrategyOptions(new HashMap<String, String>(cf_def.compaction_strategy_options));
            }
            if (cf_def.isSetBloom_filter_fp_chance()) {
                newCFMD.bloomFilterFpChance(cf_def.bloom_filter_fp_chance);
            }
            if (cf_def.isSetMemtable_flush_period_in_ms()) {
                newCFMD.memtableFlushPeriod(cf_def.memtable_flush_period_in_ms);
            }
            if (cf_def.isSetCaching() || cf_def.isSetCells_per_row_to_cache()) {
                newCFMD.caching(CachingOptions.fromThrift(cf_def.caching, cf_def.cells_per_row_to_cache));
            }
            if (cf_def.isSetRead_repair_chance()) {
                newCFMD.readRepairChance(cf_def.read_repair_chance);
            }
            if (cf_def.isSetDefault_time_to_live()) {
                newCFMD.defaultTimeToLive(cf_def.default_time_to_live);
            }
            if (cf_def.isSetDclocal_read_repair_chance()) {
                newCFMD.dcLocalReadRepairChance(cf_def.dclocal_read_repair_chance);
            }
            if (cf_def.isSetMin_index_interval()) {
                newCFMD.minIndexInterval(cf_def.min_index_interval);
            }
            if (cf_def.isSetMax_index_interval()) {
                newCFMD.maxIndexInterval(cf_def.max_index_interval);
            }
            if (cf_def.isSetSpeculative_retry()) {
                newCFMD.speculativeRetry(SpeculativeRetry.fromString(cf_def.speculative_retry));
            }
            if (cf_def.isSetTriggers()) {
                newCFMD.triggers(TriggerDefinition.fromThrift(cf_def.triggers));
            }
            return newCFMD.comment(cf_def.comment).defaultValidator(TypeParser.parse(cf_def.default_validation_class)).compressionParameters(CompressionParameters.create(cf_def.compression_options)).rebuild();
        }
        catch (SyntaxException | MarshalException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static CFMetaData fromThriftCqlRow(CqlRow cf, CqlResult columnsRes) {
        UntypedResultSet.Row cfRow = new UntypedResultSet.Row(CFMetaData.convertThriftCqlRow(cf));
        ArrayList<Map<String, ByteBuffer>> cols = new ArrayList<Map<String, ByteBuffer>>(columnsRes.rows.size());
        for (CqlRow row : columnsRes.rows) {
            cols.add(CFMetaData.convertThriftCqlRow(row));
        }
        UntypedResultSet colsRow = UntypedResultSet.create(cols);
        return CFMetaData.fromSchemaNoTriggers(cfRow, colsRow);
    }

    private static Map<String, ByteBuffer> convertThriftCqlRow(CqlRow row) {
        HashMap<String, ByteBuffer> m = new HashMap<String, ByteBuffer>();
        for (Column column : row.getColumns()) {
            m.put(UTF8Type.instance.getString(column.bufferForName()), column.value);
        }
        return m;
    }

    public void reload() {
        Row cfDefRow = SystemKeyspace.readSchemaRow("schema_columnfamilies", this.ksName, this.cfName);
        if (cfDefRow.cf == null || !cfDefRow.cf.hasColumns()) {
            throw new RuntimeException(String.format("%s not found in the schema definitions keyspace.", this.ksName + ":" + this.cfName));
        }
        try {
            this.apply(CFMetaData.fromSchema(cfDefRow));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    void apply(CFMetaData cfm) throws ConfigurationException {
        logger.debug("applying {} to {}", (Object)cfm, (Object)this);
        this.validateCompatility(cfm);
        this.comparator = cfm.comparator;
        this.comment = Strings.nullToEmpty((String)cfm.comment);
        this.readRepairChance = cfm.readRepairChance;
        this.dcLocalReadRepairChance = cfm.dcLocalReadRepairChance;
        this.gcGraceSeconds = cfm.gcGraceSeconds;
        this.defaultValidator = cfm.defaultValidator;
        this.keyValidator = cfm.keyValidator;
        this.minCompactionThreshold = cfm.minCompactionThreshold;
        this.maxCompactionThreshold = cfm.maxCompactionThreshold;
        this.bloomFilterFpChance = cfm.bloomFilterFpChance;
        this.caching = cfm.caching;
        this.minIndexInterval = cfm.minIndexInterval;
        this.maxIndexInterval = cfm.maxIndexInterval;
        this.memtableFlushPeriod = cfm.memtableFlushPeriod;
        this.defaultTimeToLive = cfm.defaultTimeToLive;
        this.speculativeRetry = cfm.speculativeRetry;
        if (!cfm.droppedColumns.isEmpty()) {
            this.droppedColumns = cfm.droppedColumns;
        }
        MapDifference columnDiff = Maps.difference(this.columnMetadata, cfm.columnMetadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            this.removeColumnDefinition(cd);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            this.addColumnDefinition(cd);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition oldDef = this.columnMetadata.get(name);
            ColumnDefinition def = cfm.columnMetadata.get(name);
            this.addOrReplaceColumnDefinition(oldDef.apply(def));
        }
        this.compactionStrategyClass = cfm.compactionStrategyClass;
        this.compactionStrategyOptions = cfm.compactionStrategyOptions;
        this.compressionParameters = cfm.compressionParameters;
        this.triggers = cfm.triggers;
        this.rebuild();
        logger.debug("application result is {}", (Object)this);
    }

    public void validateCompatility(CFMetaData cfm) throws ConfigurationException {
        if (!cfm.ksName.equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cfm.ksName, this.ksName));
        }
        if (!cfm.cfName.equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cfm.cfName, this.cfName));
        }
        if (!cfm.cfId.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cfm.cfId, this.cfId));
        }
        if (!cfm.cfType.equals((Object)this.cfType)) {
            throw new ConfigurationException("types do not match.");
        }
        if (!cfm.comparator.isCompatibleWith(this.comparator)) {
            throw new ConfigurationException("comparators do not match or are not compatible.");
        }
    }

    public static void validateCompactionOptions(Class<? extends AbstractCompactionStrategy> strategyClass, Map<String, String> options) throws ConfigurationException {
        try {
            if (options == null) {
                return;
            }
            Map unknownOptions = (Map)strategyClass.getMethod("validateOptions", Map.class).invoke(null, options);
            if (!unknownOptions.isEmpty()) {
                throw new ConfigurationException(String.format("Properties specified %s are not understood by %s", unknownOptions.keySet(), strategyClass.getSimpleName()));
            }
        }
        catch (NoSuchMethodException e) {
            logger.warn("Compaction Strategy {} does not have a static validateOptions method. Validation ignored", (Object)strategyClass.getName());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getTargetException();
            }
            throw new ConfigurationException("Failed to validate compaction options");
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to validate compaction options");
        }
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionStrategy(String className) throws ConfigurationException {
        Class strategyClass = FBUtilities.classForName(className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className, "compaction strategy");
        if (!AbstractCompactionStrategy.class.isAssignableFrom(strategyClass)) {
            throw new ConfigurationException(String.format("Specified compaction strategy class (%s) is not derived from AbstractReplicationStrategy", className));
        }
        return strategyClass;
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = this.compactionStrategyClass.getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, this.compactionStrategyOptions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CfDef toThrift() {
        CfDef def = new CfDef(this.ksName, this.cfName);
        def.setColumn_type(this.cfType.name());
        if (this.isSuper()) {
            def.setComparator_type(this.comparator.subtype(0).toString());
            def.setSubcomparator_type(this.comparator.subtype(1).toString());
        } else {
            def.setComparator_type(this.comparator.toString());
        }
        def.setComment(Strings.nullToEmpty((String)this.comment));
        def.setRead_repair_chance(this.readRepairChance);
        def.setDclocal_read_repair_chance(this.dcLocalReadRepairChance);
        def.setGc_grace_seconds(this.gcGraceSeconds);
        def.setDefault_validation_class(this.defaultValidator == null ? null : this.defaultValidator.toString());
        def.setKey_validation_class(this.keyValidator.toString());
        def.setMin_compaction_threshold(this.minCompactionThreshold);
        def.setMax_compaction_threshold(this.maxCompactionThreshold);
        if (this.partitionKeyColumns.size() == 1) {
            def.setKey_alias(this.partitionKeyColumns.get((int)0).name.bytes);
        }
        def.setColumn_metadata(ColumnDefinition.toThrift(this.columnMetadata));
        def.setCompaction_strategy(this.compactionStrategyClass.getName());
        def.setCompaction_strategy_options(new HashMap<String, String>(this.compactionStrategyOptions));
        def.setCompression_options(this.compressionParameters.asThriftOptions());
        if (this.bloomFilterFpChance != null) {
            def.setBloom_filter_fp_chance(this.bloomFilterFpChance.doubleValue());
        }
        def.setMin_index_interval(this.minIndexInterval);
        def.setMax_index_interval(this.maxIndexInterval);
        def.setMemtable_flush_period_in_ms(this.memtableFlushPeriod);
        def.setCaching(this.caching.toThriftCaching());
        def.setCells_per_row_to_cache(this.caching.toThriftCellsPerRow());
        def.setDefault_time_to_live(this.defaultTimeToLive);
        def.setSpeculative_retry(this.speculativeRetry.toString());
        def.setTriggers(TriggerDefinition.toThrift(this.triggers));
        return def;
    }

    public ColumnDefinition getColumnDefinition(ColumnIdentifier name) {
        return this.columnMetadata.get(name.bytes);
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.columnMetadata.get(name);
    }

    public ColumnDefinition getColumnDefinition(CellName cellName) {
        ColumnIdentifier id = cellName.cql3ColumnName(this);
        ColumnDefinition def = id == null ? this.getColumnDefinition(cellName.toByteBuffer()) : this.getColumnDefinition(id);
        return def != null && def.isPartOfCellName() ? def : null;
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.allColumns()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public void addDefaultIndexNames() throws ConfigurationException {
        UUID cfId = Schema.instance.getId(this.ksName, this.cfName);
        if (cfId != null) {
            CFMetaData cfm = Schema.instance.getCFMetaData(cfId);
            for (ColumnDefinition newDef : this.allColumns()) {
                String oldIndexName;
                if (!cfm.columnMetadata.containsKey(newDef.name.bytes) || newDef.getIndexType() == null || (oldIndexName = cfm.getColumnDefinition(newDef.name).getIndexName()) == null) continue;
                if (newDef.getIndexName() != null && !oldIndexName.equals(newDef.getIndexName())) {
                    throw new ConfigurationException("Can't modify index name: was '" + oldIndexName + "' changed to '" + newDef.getIndexName() + "'.");
                }
                newDef.setIndexName(oldIndexName);
            }
        }
        Set<String> existingNames = CFMetaData.existingIndexNames(null);
        for (ColumnDefinition column : this.allColumns()) {
            String baseName;
            if (column.getIndexType() == null || column.getIndexName() != null) continue;
            String indexName = baseName = CFMetaData.getDefaultIndexName(this.cfName, column.name);
            int i = 0;
            while (existingNames.contains(indexName)) {
                indexName = baseName + '_' + ++i;
            }
            column.setIndexName(indexName);
        }
    }

    public static String getDefaultIndexName(String cfName, ColumnIdentifier columnName) {
        return (cfName + "_" + columnName + "_idx").replaceAll("\\W", "");
    }

    public Iterator<OnDiskAtom> getOnDiskIterator(DataInput in, Descriptor.Version version) {
        return this.getOnDiskIterator(in, ColumnSerializer.Flag.LOCAL, Integer.MIN_VALUE, version);
    }

    public Iterator<OnDiskAtom> getOnDiskIterator(DataInput in, ColumnSerializer.Flag flag, int expireBefore, Descriptor.Version version) {
        return AbstractCell.onDiskIterator(in, flag, expireBefore, version, this.comparator);
    }

    public AtomDeserializer getOnDiskDeserializer(DataInput in, Descriptor.Version version) {
        return new AtomDeserializer(this.comparator, in, ColumnSerializer.Flag.LOCAL, Integer.MIN_VALUE, version);
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && name.length() <= 48 && name.matches("\\w+");
    }

    public static boolean isIndexNameValid(String name) {
        return name != null && !name.isEmpty() && name.matches("\\w+");
    }

    public CFMetaData validate() throws ConfigurationException {
        this.rebuild();
        if (!CFMetaData.isNameValid(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.ksName));
        }
        if (!CFMetaData.isNameValid(this.cfName)) {
            throw new ConfigurationException(String.format("ColumnFamily name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.cfName));
        }
        if (this.cfType == null) {
            throw new ConfigurationException(String.format("Invalid column family type for %s", this.cfName));
        }
        for (int i = 0; i < this.comparator.size(); ++i) {
            if (!(this.comparator.subtype(i) instanceof CounterColumnType)) continue;
            throw new ConfigurationException("CounterColumnType is not a valid comparator");
        }
        if (this.keyValidator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid key validator");
        }
        if (this.defaultValidator instanceof CounterColumnType) {
            for (ColumnDefinition def : this.regularAndStaticColumns()) {
                if (def.type instanceof CounterColumnType) continue;
                throw new ConfigurationException("Cannot add a non counter column (" + def.name + ") in a counter column family");
            }
        } else {
            for (ColumnDefinition def : this.allColumns()) {
                if (!(def.type instanceof CounterColumnType)) continue;
                throw new ConfigurationException("Cannot add a counter column (" + def.name + ") in a non counter column family");
            }
        }
        Set<String> indexNames = CFMetaData.existingIndexNames(this.cfName);
        for (ColumnDefinition c : this.allColumns()) {
            if (c.getIndexType() == null) {
                if (c.getIndexName() == null) continue;
                throw new ConfigurationException("Index name cannot be set without index type");
            }
            if (this.cfType == ColumnFamilyType.Super) {
                throw new ConfigurationException("Secondary indexes are not supported on super column families");
            }
            if (!CFMetaData.isIndexNameValid(c.getIndexName())) {
                throw new ConfigurationException("Illegal index name " + c.getIndexName());
            }
            if (indexNames.contains(c.getIndexName())) {
                throw new ConfigurationException("Duplicate index name " + c.getIndexName());
            }
            indexNames.add(c.getIndexName());
            if (!(c.getIndexType() != IndexType.CUSTOM || c.getIndexOptions() != null && c.getIndexOptions().containsKey("class_name"))) {
                throw new ConfigurationException("Required index option missing: class_name");
            }
            SecondaryIndex.createInstance(null, c);
        }
        this.validateCompactionThresholds();
        if (this.bloomFilterFpChance != null && this.bloomFilterFpChance == 0.0) {
            throw new ConfigurationException("Zero false positives is impossible; bloom filter false positive chance bffpc must be 0 < bffpc <= 1");
        }
        this.validateIndexIntervalThresholds();
        return this;
    }

    private static Set<String> existingIndexNames(String cfToExclude) {
        HashSet<String> indexNames = new HashSet<String>();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (cfToExclude != null && cfs.name.equals(cfToExclude)) continue;
            for (ColumnDefinition cd : cfs.metadata.allColumns()) {
                indexNames.add(cd.getIndexName());
            }
        }
        return indexNames;
    }

    private void validateCompactionThresholds() throws ConfigurationException {
        if (this.maxCompactionThreshold == 0) {
            logger.warn("Disabling compaction by setting max or min compaction has been deprecated, set the compaction strategy option 'enabled' to 'false' instead");
            return;
        }
        if (this.minCompactionThreshold <= 1) {
            throw new ConfigurationException(String.format("Min compaction threshold cannot be less than 2 (got %d).", this.minCompactionThreshold));
        }
        if (this.minCompactionThreshold > this.maxCompactionThreshold) {
            throw new ConfigurationException(String.format("Min compaction threshold (got %d) cannot be greater than max compaction threshold (got %d)", this.minCompactionThreshold, this.maxCompactionThreshold));
        }
    }

    private void validateIndexIntervalThresholds() throws ConfigurationException {
        if (this.minIndexInterval <= 0) {
            throw new ConfigurationException(String.format("Min index interval must be greater than 0 (got %d).", this.minIndexInterval));
        }
        if (this.maxIndexInterval < this.minIndexInterval) {
            throw new ConfigurationException(String.format("Max index interval (%d) must be greater than the min index interval (%d).", this.maxIndexInterval, this.minIndexInterval));
        }
    }

    public Mutation toSchemaUpdate(CFMetaData newState, long modificationTimestamp, boolean fromThrift) {
        Mutation mutation = new Mutation("system", SystemKeyspace.getSchemaKSKey(this.ksName));
        newState.toSchemaNoColumnsNoTriggers(mutation, modificationTimestamp);
        MapDifference columnDiff = Maps.difference(this.columnMetadata, newState.columnMetadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            if (fromThrift && cd.kind != ColumnDefinition.Kind.REGULAR) continue;
            cd.deleteFromSchema(mutation, modificationTimestamp);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            cd.toSchema(mutation, modificationTimestamp);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition cd = newState.columnMetadata.get(name);
            cd.toSchema(mutation, modificationTimestamp);
        }
        MapDifference triggerDiff = Maps.difference(this.triggers, newState.triggers);
        for (TriggerDefinition td : triggerDiff.entriesOnlyOnLeft().values()) {
            td.deleteFromSchema(mutation, this.cfName, modificationTimestamp);
        }
        for (TriggerDefinition td : triggerDiff.entriesOnlyOnRight().values()) {
            td.toSchema(mutation, this.cfName, modificationTimestamp);
        }
        return mutation;
    }

    public Mutation dropFromSchema(long timestamp) {
        Mutation mutation = new Mutation("system", SystemKeyspace.getSchemaKSKey(this.ksName));
        ColumnFamily cf = mutation.addOrGet(SchemaColumnFamiliesCf);
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        Composite prefix = CFMetaData.SchemaColumnFamiliesCf.comparator.make(this.cfName);
        cf.addAtom(new RangeTombstone(prefix, prefix.end(), timestamp, ldt));
        for (ColumnDefinition cd : this.allColumns()) {
            cd.deleteFromSchema(mutation, timestamp);
        }
        for (TriggerDefinition td : this.triggers.values()) {
            td.deleteFromSchema(mutation, this.cfName, timestamp);
        }
        for (String indexName : Keyspace.open(this.ksName).getColumnFamilyStore(this.cfName).getBuiltIndexes()) {
            ColumnFamily indexCf = mutation.addOrGet(IndexCf);
            indexCf.addTombstone(indexCf.getComparator().makeCellName(indexName), ldt, timestamp);
        }
        return mutation;
    }

    public boolean isPurged() {
        return this.isPurged;
    }

    void markPurged() {
        this.isPurged = true;
    }

    public void toSchema(Mutation mutation, long timestamp) {
        this.toSchemaNoColumnsNoTriggers(mutation, timestamp);
        for (TriggerDefinition td : this.triggers.values()) {
            td.toSchema(mutation, this.cfName, timestamp);
        }
        for (ColumnDefinition cd : this.allColumns()) {
            cd.toSchema(mutation, timestamp);
        }
    }

    private void toSchemaNoColumnsNoTriggers(Mutation mutation, long timestamp) {
        ColumnFamily cf = mutation.addOrGet(SchemaColumnFamiliesCf);
        Composite prefix = CFMetaData.SchemaColumnFamiliesCf.comparator.make(this.cfName);
        CFRowAdder adder = new CFRowAdder(cf, prefix, timestamp);
        adder.add("cf_id", this.cfId);
        adder.add("type", this.cfType.toString());
        if (this.isSuper()) {
            adder.add("comparator", this.comparator.subtype(0).toString());
            adder.add("subcomparator", this.comparator.subtype(1).toString());
        } else {
            adder.add("comparator", this.comparator.toString());
        }
        adder.add("comment", this.comment);
        adder.add("read_repair_chance", this.readRepairChance);
        adder.add("local_read_repair_chance", this.dcLocalReadRepairChance);
        adder.add("gc_grace_seconds", this.gcGraceSeconds);
        adder.add("default_validator", this.defaultValidator.toString());
        adder.add("key_validator", this.keyValidator.toString());
        adder.add("min_compaction_threshold", this.minCompactionThreshold);
        adder.add("max_compaction_threshold", this.maxCompactionThreshold);
        adder.add("bloom_filter_fp_chance", this.bloomFilterFpChance);
        adder.add("memtable_flush_period_in_ms", this.memtableFlushPeriod);
        adder.add("caching", this.caching.toString());
        adder.add("default_time_to_live", this.defaultTimeToLive);
        adder.add("compaction_strategy_class", this.compactionStrategyClass.getName());
        adder.add("compression_parameters", FBUtilities.json(this.compressionParameters.asThriftOptions()));
        adder.add("compaction_strategy_options", FBUtilities.json(this.compactionStrategyOptions));
        adder.add("min_index_interval", this.minIndexInterval);
        adder.add("max_index_interval", this.maxIndexInterval);
        adder.add("index_interval", null);
        adder.add("speculative_retry", this.speculativeRetry.toString());
        for (Map.Entry<ColumnIdentifier, Long> entry : this.droppedColumns.entrySet()) {
            adder.addMapEntry("dropped_columns", entry.getKey().toString(), entry.getValue());
        }
        adder.add("key_aliases", this.aliasesToJson(this.partitionKeyColumns));
        adder.add("column_aliases", this.aliasesToJson(this.clusteringColumns));
        adder.add("value_alias", this.compactValueColumn == null ? null : this.compactValueColumn.name.toString());
    }

    static CFMetaData fromSchemaNoTriggers(UntypedResultSet.Row result, UntypedResultSet serializedColumnDefinitions) {
        try {
            String ksName = result.getString("keyspace_name");
            String cfName = result.getString("columnfamily_name");
            AbstractType<?> rawComparator = TypeParser.parse(result.getString("comparator"));
            AbstractType<?> subComparator = result.has("subcomparator") ? TypeParser.parse(result.getString("subcomparator")) : null;
            ColumnFamilyType cfType = ColumnFamilyType.valueOf(result.getString("type"));
            AbstractType<?> fullRawComparator = CFMetaData.makeRawAbstractType(rawComparator, subComparator);
            List<ColumnDefinition> columnDefs = ColumnDefinition.fromSchema(serializedColumnDefinitions, ksName, cfName, fullRawComparator, cfType == ColumnFamilyType.Super);
            CellNameType comparator = CellNames.fromAbstractType(fullRawComparator, CFMetaData.isDense(fullRawComparator, columnDefs));
            UUID cfId = result.has("cf_id") ? result.getUUID("cf_id") : CFMetaData.generateLegacyCfId(ksName, cfName);
            CFMetaData cfm = new CFMetaData(ksName, cfName, cfType, comparator, cfId);
            cfm.readRepairChance(result.getDouble("read_repair_chance"));
            cfm.dcLocalReadRepairChance(result.getDouble("local_read_repair_chance"));
            cfm.gcGraceSeconds(result.getInt("gc_grace_seconds"));
            cfm.defaultValidator(TypeParser.parse(result.getString("default_validator")));
            cfm.keyValidator(TypeParser.parse(result.getString("key_validator")));
            cfm.minCompactionThreshold(result.getInt("min_compaction_threshold"));
            cfm.maxCompactionThreshold(result.getInt("max_compaction_threshold"));
            if (result.has("comment")) {
                cfm.comment(result.getString("comment"));
            }
            if (result.has("bloom_filter_fp_chance")) {
                cfm.bloomFilterFpChance(result.getDouble("bloom_filter_fp_chance"));
            }
            if (result.has("memtable_flush_period_in_ms")) {
                cfm.memtableFlushPeriod(result.getInt("memtable_flush_period_in_ms"));
            }
            cfm.caching(CachingOptions.fromString(result.getString("caching")));
            if (result.has("default_time_to_live")) {
                cfm.defaultTimeToLive(result.getInt("default_time_to_live"));
            }
            if (result.has("speculative_retry")) {
                cfm.speculativeRetry(SpeculativeRetry.fromString(result.getString("speculative_retry")));
            }
            cfm.compactionStrategyClass(CFMetaData.createCompactionStrategy(result.getString("compaction_strategy_class")));
            cfm.compressionParameters(CompressionParameters.create(FBUtilities.fromJsonMap(result.getString("compression_parameters"))));
            cfm.compactionStrategyOptions(FBUtilities.fromJsonMap(result.getString("compaction_strategy_options")));
            if (result.has("min_index_interval")) {
                cfm.minIndexInterval(result.getInt("min_index_interval"));
            } else if (result.has("index_interval")) {
                cfm.minIndexInterval(result.getInt("index_interval"));
            }
            if (result.has("max_index_interval")) {
                cfm.maxIndexInterval(result.getInt("max_index_interval"));
            }
            if (result.has("key_aliases")) {
                cfm.addColumnMetadataFromAliases(CFMetaData.aliasesFromStrings(FBUtilities.fromJsonList(result.getString("key_aliases"))), cfm.keyValidator, ColumnDefinition.Kind.PARTITION_KEY);
            }
            if (result.has("column_aliases")) {
                cfm.addColumnMetadataFromAliases(CFMetaData.aliasesFromStrings(FBUtilities.fromJsonList(result.getString("column_aliases"))), cfm.comparator.asAbstractType(), ColumnDefinition.Kind.CLUSTERING_COLUMN);
            }
            if (result.has("value_alias")) {
                cfm.addColumnMetadataFromAliases(Collections.singletonList(result.getBytes("value_alias")), cfm.defaultValidator, ColumnDefinition.Kind.COMPACT_VALUE);
            }
            if (result.has("dropped_columns")) {
                cfm.droppedColumns(CFMetaData.convertDroppedColumns(result.getMap("dropped_columns", UTF8Type.instance, LongType.instance)));
            }
            for (ColumnDefinition cd : columnDefs) {
                cfm.addOrReplaceColumnDefinition(cd);
            }
            return cfm.rebuild();
        }
        catch (ConfigurationException | SyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void addColumnMetadataFromAliases(List<ByteBuffer> aliases, AbstractType<?> comparator, ColumnDefinition.Kind kind) {
        if (comparator instanceof CompositeType) {
            CompositeType ct = (CompositeType)comparator;
            for (int i = 0; i < aliases.size(); ++i) {
                if (aliases.get(i) == null) continue;
                this.addOrReplaceColumnDefinition(new ColumnDefinition(this, aliases.get(i), ct.types.get(i), i, kind));
            }
        } else {
            assert (aliases.size() <= 1);
            if (!aliases.isEmpty() && aliases.get(0) != null) {
                this.addOrReplaceColumnDefinition(new ColumnDefinition(this, aliases.get(0), comparator, null, kind));
            }
        }
    }

    public static CFMetaData fromSchema(UntypedResultSet.Row result) {
        String ksName = result.getString("keyspace_name");
        String cfName = result.getString("columnfamily_name");
        Row serializedColumns = SystemKeyspace.readSchemaRow("schema_columns", ksName, cfName);
        CFMetaData cfm = CFMetaData.fromSchemaNoTriggers(result, ColumnDefinition.resultify(serializedColumns));
        Row serializedTriggers = SystemKeyspace.readSchemaRow("schema_triggers", ksName, cfName);
        CFMetaData.addTriggerDefinitionsFromSchema(cfm, serializedTriggers);
        return cfm;
    }

    private static CFMetaData fromSchema(Row row) {
        UntypedResultSet.Row result = QueryProcessor.resultify("SELECT * FROM system.schema_columnfamilies", row).one();
        return CFMetaData.fromSchema(result);
    }

    private String aliasesToJson(List<ColumnDefinition> rawAliases) {
        if (rawAliases == null) {
            return null;
        }
        ArrayList<String> aliases = new ArrayList<String>(rawAliases.size());
        for (ColumnDefinition rawAlias : rawAliases) {
            aliases.add(rawAlias.name.toString());
        }
        return FBUtilities.json(aliases);
    }

    private static List<ByteBuffer> aliasesFromStrings(List<String> aliases) {
        ArrayList<ByteBuffer> rawAliases = new ArrayList<ByteBuffer>(aliases.size());
        for (String alias : aliases) {
            rawAliases.add(UTF8Type.instance.decompose(alias));
        }
        return rawAliases;
    }

    private static Map<ColumnIdentifier, Long> convertDroppedColumns(Map<String, Long> raw) {
        HashMap converted = Maps.newHashMap();
        for (Map.Entry<String, Long> entry : raw.entrySet()) {
            converted.put(new ColumnIdentifier(entry.getKey(), true), entry.getValue());
        }
        return converted;
    }

    public Mutation toSchema(long timestamp) throws ConfigurationException {
        Mutation mutation = new Mutation("system", SystemKeyspace.getSchemaKSKey(this.ksName));
        this.toSchema(mutation, timestamp);
        return mutation;
    }

    public AbstractType<?> getColumnDefinitionComparator(ColumnDefinition def) {
        return this.getComponentComparator(def.isOnAllComponents() ? null : Integer.valueOf(def.position()), def.kind);
    }

    public AbstractType<?> getComponentComparator(Integer componentIndex, ColumnDefinition.Kind kind) {
        switch (kind) {
            case REGULAR: {
                if (componentIndex == null) {
                    return this.comparator.asAbstractType();
                }
                AbstractType<?> t = this.comparator.subtype(componentIndex);
                assert (t != null) : "Non-sensical component index";
                return t;
            }
        }
        return UTF8Type.instance;
    }

    public CFMetaData addAllColumnDefinitions(Collection<ColumnDefinition> defs) {
        for (ColumnDefinition def : defs) {
            this.addOrReplaceColumnDefinition(def);
        }
        return this;
    }

    public CFMetaData addColumnDefinition(ColumnDefinition def) throws ConfigurationException {
        if (this.columnMetadata.containsKey(def.name.bytes)) {
            throw new ConfigurationException(String.format("Cannot add column %s, a column with the same name already exists", def.name));
        }
        return this.addOrReplaceColumnDefinition(def);
    }

    public CFMetaData addOrReplaceColumnDefinition(ColumnDefinition def) {
        if (def.kind == ColumnDefinition.Kind.REGULAR) {
            this.comparator.addCQL3Column(def.name);
        }
        this.columnMetadata.put(def.name.bytes, def);
        return this;
    }

    public boolean removeColumnDefinition(ColumnDefinition def) {
        if (def.kind == ColumnDefinition.Kind.REGULAR) {
            this.comparator.removeCQL3Column(def.name);
        }
        return this.columnMetadata.remove(def.name.bytes) != null;
    }

    private static void addTriggerDefinitionsFromSchema(CFMetaData cfDef, Row serializedTriggerDefinitions) {
        for (TriggerDefinition td : TriggerDefinition.fromSchema(serializedTriggerDefinitions)) {
            cfDef.triggers.put(td.name, td);
        }
    }

    public void addTriggerDefinition(TriggerDefinition def) throws ConfigurationException {
        if (this.triggers.containsKey(def.name)) {
            throw new ConfigurationException(String.format("Cannot create trigger %s, a trigger with the same name already exists", def.name));
        }
        this.triggers.put(def.name, def);
    }

    public boolean removeTrigger(String name) {
        return this.triggers.remove(name) != null;
    }

    public void recordColumnDrop(ColumnDefinition def) {
        assert (!def.isOnAllComponents());
        this.droppedColumns.put(def.name, FBUtilities.timestampMicros());
    }

    public void renameColumn(ColumnIdentifier from, ColumnIdentifier to) throws InvalidRequestException {
        ColumnDefinition def = this.getColumnDefinition(from);
        if (def == null) {
            throw new InvalidRequestException(String.format("Cannot rename unknown column %s in keyspace %s", from, this.cfName));
        }
        if (this.getColumnDefinition(to) != null) {
            throw new InvalidRequestException(String.format("Cannot rename column %s to %s in keyspace %s; another column of that name already exist", from, to, this.cfName));
        }
        if (def.isPartOfCellName()) {
            throw new InvalidRequestException(String.format("Cannot rename non PRIMARY KEY part %s", from));
        }
        if (def.isIndexed()) {
            throw new InvalidRequestException(String.format("Cannot rename column %s because it is secondary indexed", from));
        }
        ColumnDefinition newDef = def.withNewName(to);
        this.addOrReplaceColumnDefinition(newDef);
        this.removeColumnDefinition(def);
    }

    public CFMetaData rebuild() {
        List<ColumnDefinition> pkCols = CFMetaData.nullInitializedList(this.keyValidator.componentsCount());
        List<ColumnDefinition> ckCols = CFMetaData.nullInitializedList(this.comparator.clusteringPrefixSize());
        TreeSet<ColumnDefinition> regCols = new TreeSet<ColumnDefinition>(regularColumnComparator);
        TreeSet<ColumnDefinition> statCols = new TreeSet<ColumnDefinition>(regularColumnComparator);
        ColumnDefinition compactCol = null;
        for (ColumnDefinition def : this.allColumns()) {
            switch (def.kind) {
                case PARTITION_KEY: {
                    assert (!def.isOnAllComponents() || !(this.keyValidator instanceof CompositeType));
                    pkCols.set(def.position(), def);
                    break;
                }
                case CLUSTERING_COLUMN: {
                    assert (!def.isOnAllComponents() || !this.comparator.isCompound());
                    ckCols.set(def.position(), def);
                    break;
                }
                case REGULAR: {
                    regCols.add(def);
                    break;
                }
                case STATIC: {
                    statCols.add(def);
                    break;
                }
                case COMPACT_VALUE: {
                    assert (compactCol == null) : "There shouldn't be more than one compact value defined: got " + compactCol + " and " + def;
                    compactCol = def;
                }
            }
        }
        this.partitionKeyColumns = this.addDefaultKeyAliases(pkCols);
        this.clusteringColumns = this.addDefaultColumnAliases(ckCols);
        this.regularColumns = regCols;
        this.staticColumns = statCols;
        this.compactValueColumn = this.addDefaultValueAlias(compactCol, this.comparator.isDense());
        return this;
    }

    private List<ColumnDefinition> addDefaultKeyAliases(List<ColumnDefinition> pkCols) {
        for (int i = 0; i < pkCols.size(); ++i) {
            if (pkCols.get(i) != null) continue;
            Integer idx = null;
            AbstractType<?> type = this.keyValidator;
            if (this.keyValidator instanceof CompositeType) {
                idx = i;
                type = ((CompositeType)this.keyValidator).types.get(i);
            }
            ByteBuffer name = ByteBufferUtil.bytes(i == 0 ? DEFAULT_KEY_ALIAS : DEFAULT_KEY_ALIAS + (i + 1));
            ColumnDefinition newDef = ColumnDefinition.partitionKeyDef(this, name, type, idx);
            this.addOrReplaceColumnDefinition(newDef);
            pkCols.set(i, newDef);
        }
        return pkCols;
    }

    private List<ColumnDefinition> addDefaultColumnAliases(List<ColumnDefinition> ckCols) {
        for (int i = 0; i < ckCols.size(); ++i) {
            AbstractType<?> type;
            Integer idx;
            if (ckCols.get(i) != null) continue;
            if (this.comparator.isCompound()) {
                idx = i;
                type = this.comparator.subtype(i);
            } else {
                idx = null;
                type = this.comparator.asAbstractType();
            }
            ByteBuffer name = ByteBufferUtil.bytes(DEFAULT_COLUMN_ALIAS + (i + 1));
            ColumnDefinition newDef = ColumnDefinition.clusteringKeyDef(this, name, type, idx);
            this.addOrReplaceColumnDefinition(newDef);
            ckCols.set(i, newDef);
        }
        return ckCols;
    }

    private ColumnDefinition addDefaultValueAlias(ColumnDefinition compactValueDef, boolean isDense) {
        if (isDense) {
            if (compactValueDef != null) {
                return compactValueDef;
            }
            ColumnDefinition newDef = ColumnDefinition.compactValueDef(this, ByteBufferUtil.bytes(DEFAULT_VALUE_ALIAS), this.defaultValidator);
            this.addOrReplaceColumnDefinition(newDef);
            return newDef;
        }
        assert (compactValueDef == null);
        return null;
    }

    private static boolean isDense(AbstractType<?> comparator, Collection<ColumnDefinition> defs) {
        boolean hasRegular = false;
        int maxClusteringIdx = -1;
        for (ColumnDefinition def : defs) {
            switch (def.kind) {
                case CLUSTERING_COLUMN: {
                    maxClusteringIdx = Math.max(maxClusteringIdx, def.position());
                    break;
                }
                case REGULAR: {
                    hasRegular = true;
                }
            }
        }
        return maxClusteringIdx >= 0 ? maxClusteringIdx == comparator.componentsCount() - 1 : !hasRegular && !CFMetaData.isCQL3OnlyPKComparator(comparator);
    }

    private static boolean isCQL3OnlyPKComparator(AbstractType<?> comparator) {
        if (!(comparator instanceof CompositeType)) {
            return false;
        }
        CompositeType ct = (CompositeType)comparator;
        return ct.types.size() == 1 && ct.types.get(0) instanceof UTF8Type;
    }

    public boolean isCQL3Table() {
        return !this.isSuper() && !this.comparator.isDense() && this.comparator.isCompound();
    }

    private static <T> List<T> nullInitializedList(int size) {
        ArrayList<Object> l = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            l.add(null);
        }
        return l;
    }

    public boolean isThriftCompatible() {
        if (this.isSuper()) {
            return true;
        }
        for (ColumnDefinition def : this.allColumns()) {
            if (def.kind != ColumnDefinition.Kind.REGULAR || def.isThriftCompatible()) continue;
            return false;
        }
        return true;
    }

    public boolean isCounter() {
        return this.defaultValidator.isCounter();
    }

    public boolean hasStaticColumns() {
        return !this.staticColumns.isEmpty();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", (Object)this.comparator).append("comment", (Object)this.comment).append("readRepairChance", this.readRepairChance).append("dcLocalReadRepairChance", this.dcLocalReadRepairChance).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", this.defaultValidator).append("keyValidator", this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("columnMetadata", this.columnMetadata).append("compactionStrategyClass", this.compactionStrategyClass).append("compactionStrategyOptions", this.compactionStrategyOptions).append("compressionParameters", this.compressionParameters.asThriftOptions()).append("bloomFilterFpChance", (Object)this.bloomFilterFpChance).append("memtableFlushPeriod", this.memtableFlushPeriod).append("caching", (Object)this.caching).append("defaultTimeToLive", this.defaultTimeToLive).append("minIndexInterval", this.minIndexInterval).append("maxIndexInterval", this.maxIndexInterval).append("speculativeRetry", (Object)this.speculativeRetry).append("droppedColumns", this.droppedColumns).append("triggers", this.triggers).toString();
    }

    public static class SpeculativeRetry {
        public final RetryType type;
        public final double value;

        private SpeculativeRetry(RetryType type, double value) {
            this.type = type;
            this.value = value;
        }

        public static SpeculativeRetry fromString(String retry) throws ConfigurationException {
            String name = retry.toUpperCase();
            try {
                if (name.endsWith(RetryType.PERCENTILE.toString())) {
                    double value = Double.parseDouble(name.substring(0, name.length() - 10));
                    if (value > 100.0 || value < 0.0) {
                        throw new ConfigurationException("PERCENTILE should be between 0 and 100");
                    }
                    return new SpeculativeRetry(RetryType.PERCENTILE, value / 100.0);
                }
                if (name.endsWith("MS")) {
                    double value = Double.parseDouble(name.substring(0, name.length() - 2));
                    return new SpeculativeRetry(RetryType.CUSTOM, value);
                }
                return new SpeculativeRetry(RetryType.valueOf(name), 0.0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigurationException("invalid speculative_retry type: " + retry);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpeculativeRetry)) {
                return false;
            }
            SpeculativeRetry rhs = (SpeculativeRetry)obj;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)rhs.type)) && Objects.equal((Object)this.value, (Object)rhs.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.value});
        }

        public String toString() {
            switch (this.type) {
                case PERCENTILE: {
                    return this.value * 100.0 + "PERCENTILE";
                }
                case CUSTOM: {
                    return this.value + "ms";
                }
            }
            return this.type.toString();
        }

        public static enum RetryType {
            NONE,
            CUSTOM,
            PERCENTILE,
            ALWAYS;

        }
    }
}

