/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.cache.SerializingCache;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataOutputPlus;

public class SerializingCacheProvider {
    public ICache<RowCacheKey, IRowCacheEntry> create(long capacity) {
        return SerializingCache.create(capacity, new RowCacheSerializer());
    }

    static class RowCacheSerializer
    implements ISerializer<IRowCacheEntry> {
        RowCacheSerializer() {
        }

        @Override
        public void serialize(IRowCacheEntry entry, DataOutputPlus out) throws IOException {
            assert (entry != null);
            boolean isSentinel = entry instanceof RowCacheSentinel;
            out.writeBoolean(isSentinel);
            if (isSentinel) {
                out.writeLong(((RowCacheSentinel)entry).sentinelId);
            } else {
                ColumnFamily.serializer.serialize((ColumnFamily)entry, out, 8);
            }
        }

        @Override
        public IRowCacheEntry deserialize(DataInput in) throws IOException {
            boolean isSentinel = in.readBoolean();
            if (isSentinel) {
                return new RowCacheSentinel(in.readLong());
            }
            return ColumnFamily.serializer.deserialize(in, 8);
        }

        @Override
        public long serializedSize(IRowCacheEntry entry, TypeSizes typeSizes) {
            int size = typeSizes.sizeof(true);
            size = entry instanceof RowCacheSentinel ? (size += typeSizes.sizeof(((RowCacheSentinel)entry).sentinelId)) : (int)((long)size + ColumnFamily.serializer.serializedSize((ColumnFamily)entry, typeSizes, 8));
            return size;
        }
    }
}

