/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.OptionCodec;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.Pair;

public final class DataType
extends Enum<DataType>
implements OptionCodec.Codecable<DataType> {
    public static final /* enum */ DataType CUSTOM = new DataType(0, null);
    public static final /* enum */ DataType ASCII = new DataType(1, AsciiType.instance);
    public static final /* enum */ DataType BIGINT = new DataType(2, LongType.instance);
    public static final /* enum */ DataType BLOB = new DataType(3, BytesType.instance);
    public static final /* enum */ DataType BOOLEAN = new DataType(4, BooleanType.instance);
    public static final /* enum */ DataType COUNTER = new DataType(5, CounterColumnType.instance);
    public static final /* enum */ DataType DECIMAL = new DataType(6, DecimalType.instance);
    public static final /* enum */ DataType DOUBLE = new DataType(7, DoubleType.instance);
    public static final /* enum */ DataType FLOAT = new DataType(8, FloatType.instance);
    public static final /* enum */ DataType INT = new DataType(9, Int32Type.instance);
    public static final /* enum */ DataType TEXT = new DataType(10, UTF8Type.instance);
    public static final /* enum */ DataType TIMESTAMP = new DataType(11, TimestampType.instance);
    public static final /* enum */ DataType UUID = new DataType(12, UUIDType.instance);
    public static final /* enum */ DataType VARCHAR = new DataType(13, UTF8Type.instance);
    public static final /* enum */ DataType VARINT = new DataType(14, IntegerType.instance);
    public static final /* enum */ DataType TIMEUUID = new DataType(15, TimeUUIDType.instance);
    public static final /* enum */ DataType INET = new DataType(16, InetAddressType.instance);
    public static final /* enum */ DataType LIST = new DataType(32, null);
    public static final /* enum */ DataType MAP = new DataType(33, null);
    public static final /* enum */ DataType SET = new DataType(34, null);
    public static final /* enum */ DataType UDT = new DataType(48, null);
    public static final OptionCodec<DataType> codec;
    private final int id;
    private final AbstractType type;
    private static final Map<AbstractType, DataType> dataTypeMap;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(int id, AbstractType type) {
        this.id = id;
        this.type = type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Object readValue(ByteBuf cb, int version) {
        switch (this) {
            case CUSTOM: {
                return CBUtil.readString(cb);
            }
            case LIST: {
                return DataType.toType(codec.decodeOne(cb, version));
            }
            case SET: {
                return DataType.toType(codec.decodeOne(cb, version));
            }
            case MAP: {
                ArrayList<AbstractType> l = new ArrayList<AbstractType>(2);
                l.add(DataType.toType(codec.decodeOne(cb, version)));
                l.add(DataType.toType(codec.decodeOne(cb, version)));
                return l;
            }
            case UDT: {
                String ks = CBUtil.readString(cb);
                ByteBuffer name = UTF8Type.instance.decompose(CBUtil.readString(cb));
                int n = cb.readUnsignedShort();
                ArrayList<ByteBuffer> fieldNames = new ArrayList<ByteBuffer>(n);
                ArrayList fieldTypes = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    fieldNames.add(UTF8Type.instance.decompose(CBUtil.readString(cb)));
                    fieldTypes.add(DataType.toType(codec.decodeOne(cb, version)));
                }
                return new UserType(ks, name, fieldNames, fieldTypes);
            }
        }
        return null;
    }

    @Override
    public void writeValue(Object value, ByteBuf cb, int version) {
        switch (this) {
            case CUSTOM: {
                assert (value instanceof String);
                CBUtil.writeString((String)value, cb);
                break;
            }
            case LIST: {
                codec.writeOne(DataType.fromType((AbstractType)value, version), cb, version);
                break;
            }
            case SET: {
                codec.writeOne(DataType.fromType((AbstractType)value, version), cb, version);
                break;
            }
            case MAP: {
                List l = (List)value;
                codec.writeOne(DataType.fromType((AbstractType)l.get(0), version), cb, version);
                codec.writeOne(DataType.fromType((AbstractType)l.get(1), version), cb, version);
                break;
            }
            case UDT: {
                UserType udt = (UserType)value;
                CBUtil.writeString(udt.keyspace, cb);
                CBUtil.writeString((String)UTF8Type.instance.compose(udt.name), cb);
                cb.writeShort(udt.columnNames.size());
                for (int i = 0; i < udt.columnNames.size(); ++i) {
                    CBUtil.writeString((String)UTF8Type.instance.compose(udt.columnNames.get(i)), cb);
                    codec.writeOne(DataType.fromType((AbstractType)udt.types.get(i), version), cb, version);
                }
                break;
            }
        }
    }

    @Override
    public int serializedValueSize(Object value, int version) {
        switch (this) {
            case CUSTOM: {
                return CBUtil.sizeOfString((String)value);
            }
            case LIST: 
            case SET: {
                return codec.oneSerializedSize(DataType.fromType((AbstractType)value, version), version);
            }
            case MAP: {
                List l = (List)value;
                int s = 0;
                s += codec.oneSerializedSize(DataType.fromType((AbstractType)l.get(0), version), version);
                return s += codec.oneSerializedSize(DataType.fromType((AbstractType)l.get(1), version), version);
            }
            case UDT: {
                UserType udt = (UserType)value;
                int size = 0;
                size += CBUtil.sizeOfString(udt.keyspace);
                size += CBUtil.sizeOfString((String)UTF8Type.instance.compose(udt.name));
                size += 2;
                for (int i = 0; i < udt.columnNames.size(); ++i) {
                    size += CBUtil.sizeOfString((String)UTF8Type.instance.compose(udt.columnNames.get(i)));
                    size += codec.oneSerializedSize(DataType.fromType((AbstractType)udt.types.get(i), version), version);
                }
                return size;
            }
        }
        return 0;
    }

    public static Pair<DataType, Object> fromType(AbstractType type, int version) {
        if (type instanceof ReversedType) {
            type = ((ReversedType)((Object)type)).baseType;
        } else if (type instanceof DateType) {
            type = TimestampType.instance;
        }
        DataType dt = dataTypeMap.get(type);
        if (dt == null) {
            if (type.isCollection()) {
                if (type instanceof ListType) {
                    return Pair.create(LIST, ((ListType)((Object)type)).elements);
                }
                if (type instanceof MapType) {
                    MapType mt = (MapType)((Object)type);
                    return Pair.create(MAP, Arrays.asList(mt.keys, mt.values));
                }
                assert (type instanceof SetType);
                return Pair.create(SET, ((SetType)((Object)type)).elements);
            }
            if (type instanceof UserType && version >= 3) {
                return Pair.create(UDT, type);
            }
            return Pair.create(CUSTOM, type.toString());
        }
        return Pair.create(dt, null);
    }

    public static AbstractType toType(Pair<DataType, Object> entry) {
        try {
            switch ((DataType)entry.left) {
                case CUSTOM: {
                    return TypeParser.parse((String)entry.right);
                }
                case LIST: {
                    return ListType.getInstance((AbstractType)entry.right);
                }
                case SET: {
                    return SetType.getInstance((AbstractType)entry.right);
                }
                case MAP: {
                    List l = (List)entry.right;
                    return MapType.getInstance((AbstractType)l.get(0), (AbstractType)l.get(1));
                }
                case UDT: {
                    return (AbstractType)entry.right;
                }
            }
            return ((DataType)entry.left).type;
        }
        catch (RequestValidationException e) {
            throw new ProtocolException(e.getMessage());
        }
    }

    static {
        $VALUES = new DataType[]{CUSTOM, ASCII, BIGINT, BLOB, BOOLEAN, COUNTER, DECIMAL, DOUBLE, FLOAT, INT, TEXT, TIMESTAMP, UUID, VARCHAR, VARINT, TIMEUUID, INET, LIST, MAP, SET, UDT};
        codec = new OptionCodec<DataType>(DataType.class);
        dataTypeMap = new HashMap<AbstractType, DataType>();
        for (DataType type : DataType.values()) {
            if (type.type == null) continue;
            dataTypeMap.put(type.type, type);
        }
    }
}

