/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.Pair;

public class MapSerializer<K, V>
extends CollectionSerializer<Map<K, V>> {
    private static final Map<Pair<TypeSerializer<?>, TypeSerializer<?>>, MapSerializer> instances = new HashMap();
    public final TypeSerializer<K> keys;
    public final TypeSerializer<V> values;

    public static synchronized <K, V> MapSerializer<K, V> getInstance(TypeSerializer<K> keys, TypeSerializer<V> values) {
        Pair<TypeSerializer<K>, TypeSerializer<V>> p = Pair.create(keys, values);
        MapSerializer<K, V> t = instances.get(p);
        if (t == null) {
            t = new MapSerializer<K, V>(keys, values);
            instances.put(p, t);
        }
        return t;
    }

    private MapSerializer(TypeSerializer<K> keys, TypeSerializer<V> values) {
        this.keys = keys;
        this.values = values;
    }

    @Override
    public List<ByteBuffer> serializeValues(Map<K, V> map) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(map.size() * 2);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            buffers.add(this.keys.serialize(entry.getKey()));
            buffers.add(this.values.serialize(entry.getValue()));
        }
        return buffers;
    }

    @Override
    public int getElementCount(Map<K, V> value) {
        return value.size();
    }

    @Override
    public Map<K, V> deserializeForNativeProtocol(ByteBuffer bytes, int version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = MapSerializer.readCollectionSize(input, version);
            LinkedHashMap<K, V> m = new LinkedHashMap<K, V>(n);
            for (int i = 0; i < n; ++i) {
                ByteBuffer kbb = MapSerializer.readValue(input, version);
                this.keys.validate(kbb);
                ByteBuffer vbb = MapSerializer.readValue(input, version);
                this.values.validate(vbb);
                m.put(this.keys.deserialize(kbb), this.values.deserialize(vbb));
            }
            return m;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public String toString(Map<K, V> value) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<K, V> element : value.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("; ");
            }
            sb.append('(');
            sb.append(this.keys.toString(element.getKey()));
            sb.append(", ");
            sb.append(this.values.toString(element.getValue()));
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public Class<Map<K, V>> getType() {
        return Map.class;
    }
}

