/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnitchProperties {
    private static final Logger logger = LoggerFactory.getLogger(SnitchProperties.class);
    public static final String RACKDC_PROPERTY_FILENAME = "cassandra-rackdc.properties";
    private Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnitchProperties() {
        InputStream stream = null;
        String configURL = System.getProperty("cassandra.rackdc.properties");
        try {
            URL url = new URL(configURL);
            if (configURL == null) {
                url = SnitchProperties.class.getClassLoader().getResource(RACKDC_PROPERTY_FILENAME);
            }
            stream = url.openStream();
            this.properties.load(stream);
            FileUtils.closeQuietly(stream);
        }
        catch (Exception e) {
            logger.warn("Unable to read {}", (Object)RACKDC_PROPERTY_FILENAME);
        }
        finally {
            FileUtils.closeQuietly(stream);
        }
    }

    public String get(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }
}

