/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.utils.WrappedRunnable;

public abstract class DiskAwareRunnable
extends WrappedRunnable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runMayThrow() throws Exception {
        long writeSize;
        Directories.DataDirectory directory;
        do {
            writeSize = this.getExpectedWriteSize();
        } while ((directory = this.getWriteableLocation()) == null && this.reduceScopeForLimitedSpace());
        if (directory == null) {
            throw new RuntimeException("Insufficient disk space to write " + writeSize + " bytes");
        }
        directory.currentTasks.incrementAndGet();
        directory.estimatedWorkingSize.addAndGet(writeSize);
        try {
            this.runWith(this.getDirectories().getLocationForDisk(directory));
        }
        finally {
            directory.estimatedWorkingSize.addAndGet(-1L * writeSize);
            directory.currentTasks.decrementAndGet();
        }
    }

    protected abstract Directories.DataDirectory getWriteableLocation();

    protected abstract Directories getDirectories();

    protected abstract void runWith(File var1) throws Exception;

    public abstract long getExpectedWriteSize();

    public boolean reduceScopeForLimitedSpace() {
        return false;
    }
}

