/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ListType<T>
extends CollectionType<List<T>> {
    private static final Map<AbstractType<?>, ListType> instances = new HashMap();
    public final AbstractType<T> elements;
    public final ListSerializer<T> serializer;

    public static ListType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("ListType takes exactly 1 type parameter");
        }
        return ListType.getInstance(l.get(0));
    }

    public static synchronized <T> ListType<T> getInstance(AbstractType<T> elements) {
        ListType<T> t = instances.get(elements);
        if (t == null) {
            t = new ListType<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    private ListType(AbstractType<T> elements) {
        super(CollectionType.Kind.LIST);
        this.elements = elements;
        this.serializer = ListSerializer.getInstance(elements.getSerializer());
    }

    @Override
    public AbstractType<UUID> nameComparator() {
        return TimeUUIDType.instance;
    }

    @Override
    public AbstractType<T> valueComparator() {
        return this.elements;
    }

    @Override
    public ListSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ListType.compareListOrSet(this.elements, o1, o2);
    }

    static int compareListOrSet(AbstractType<?> elementsComparator, ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        int size1 = ByteBufferUtil.readShortLength(bb1);
        int size2 = ByteBufferUtil.readShortLength(bb2);
        for (int i = 0; i < Math.min(size1, size2); ++i) {
            ByteBuffer v2;
            ByteBuffer v1 = ByteBufferUtil.readBytesWithShortLength(bb1);
            int cmp = elementsComparator.compare(v1, v2 = ByteBufferUtil.readBytesWithShortLength(bb2));
            if (cmp == 0) continue;
            return cmp;
        }
        return size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements)));
    }

    @Override
    public List<ByteBuffer> serializedValues(List<Cell> cells) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(cells.size());
        for (Cell c : cells) {
            bbs.add(c.value());
        }
        return bbs;
    }
}

