/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.db.composites.AbstractCType;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.CompoundComposite;
import org.apache.cassandra.db.composites.CompoundDenseCellName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;

public class CompoundCType
extends AbstractCType {
    final List<AbstractType<?>> types;

    public CompoundCType(List<AbstractType<?>> types) {
        super(CompoundCType.isByteOrderComparable(types));
        this.types = types;
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public int size() {
        return this.types.size();
    }

    @Override
    public AbstractType<?> subtype(int i) {
        return this.types.get(i);
    }

    @Override
    public Composite fromByteBuffer(ByteBuffer bytes) {
        if (!bytes.hasRemaining()) {
            return Composites.EMPTY;
        }
        ByteBuffer[] elements = new ByteBuffer[this.size()];
        int idx = bytes.position();
        int i = 0;
        int eoc = 0;
        boolean isStatic = false;
        if (CompositeType.isStaticName(bytes)) {
            isStatic = true;
            idx += 2;
        }
        while (idx < bytes.limit()) {
            CompoundCType.checkRemaining(bytes, idx, 2);
            int length = bytes.getShort(idx) & 0xFFFF;
            CompoundCType.checkRemaining(bytes, idx += 2, length + 1);
            elements[i++] = CompoundCType.sliceBytes(bytes, idx, length);
            idx += length;
            eoc = bytes.get(idx++);
        }
        return new CompoundComposite(elements, i, isStatic).withEOC(Composite.EOC.from(eoc));
    }

    @Override
    public CBuilder builder() {
        return new CompoundCBuilder(this);
    }

    @Override
    public CompoundCType setSubtype(int position, AbstractType<?> newType) {
        ArrayList newTypes = new ArrayList(this.types);
        newTypes.set(position, newType);
        return new CompoundCType(newTypes);
    }

    @Override
    public AbstractType<?> asAbstractType() {
        return CompositeType.getInstance(this.types);
    }

    public static class CompoundCBuilder
    implements CBuilder {
        private final CType type;
        private final ByteBuffer[] values;
        private int size;
        private boolean built;

        public CompoundCBuilder(CType type) {
            this.type = type;
            this.values = new ByteBuffer[type.size()];
        }

        @Override
        public int remainingCount() {
            return this.values.length - this.size;
        }

        @Override
        public CBuilder add(ByteBuffer value) {
            if (this.isDone()) {
                throw new IllegalStateException();
            }
            this.values[this.size++] = value;
            return this;
        }

        @Override
        public CBuilder add(Object value) {
            return this.add(this.type.subtype(this.size).decompose(value));
        }

        private boolean isDone() {
            return this.remainingCount() == 0 || this.built;
        }

        @Override
        public Composite build() {
            if (this.size == 0) {
                return Composites.EMPTY;
            }
            this.built = true;
            if (this.size == this.values.length && this.type instanceof CellNameType && ((CellNameType)this.type).isDense()) {
                return new CompoundDenseCellName(this.values);
            }
            return new CompoundComposite(this.values, this.size, false);
        }

        @Override
        public Composite buildWith(ByteBuffer value) {
            ByteBuffer[] newValues = Arrays.copyOf(this.values, this.values.length);
            newValues[this.size] = value;
            if (this.size + 1 == newValues.length && this.type instanceof CellNameType && ((CellNameType)this.type).isDense()) {
                return new CompoundDenseCellName(newValues);
            }
            return new CompoundComposite(newValues, this.size + 1, false);
        }
    }
}

