/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Throwables;
import java.io.File;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.AtomicBTreeColumns;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.dht.LongToken;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.DiskAwareRunnable;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.HeapAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtablePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memtable {
    private static final Logger logger = LoggerFactory.getLogger(Memtable.class);
    static final MemtablePool MEMORY_POOL = DatabaseDescriptor.getMemtableAllocatorPool();
    private static final int ROW_OVERHEAD_HEAP_SIZE;
    private final MemtableAllocator allocator;
    private final AtomicLong liveDataSize = new AtomicLong(0L);
    private final AtomicLong currentOperations = new AtomicLong(0L);
    private volatile OpOrder.Barrier writeBarrier;
    private final AtomicReference<ReplayPosition> lastReplayPosition = new AtomicReference();
    private final ReplayPosition minReplayPosition = CommitLog.instance.getContext();
    private final ConcurrentNavigableMap<RowPosition, AtomicBTreeColumns> rows = new ConcurrentSkipListMap<RowPosition, AtomicBTreeColumns>();
    public final ColumnFamilyStore cfs;
    private final long creationTime = System.currentTimeMillis();
    private final long creationNano = System.nanoTime();
    public final CellNameType initialComparator;

    public Memtable(ColumnFamilyStore cfs) {
        this.cfs = cfs;
        this.allocator = MEMORY_POOL.newAllocator();
        this.initialComparator = cfs.metadata.comparator;
        this.cfs.scheduleFlush();
    }

    public MemtableAllocator getAllocator() {
        return this.allocator;
    }

    public long getLiveDataSize() {
        return this.liveDataSize.get();
    }

    public long getOperations() {
        return this.currentOperations.get();
    }

    void setDiscarding(OpOrder.Barrier writeBarrier, ReplayPosition minLastReplayPosition) {
        assert (this.writeBarrier == null);
        this.lastReplayPosition.set(minLastReplayPosition);
        this.writeBarrier = writeBarrier;
        this.allocator.setDiscarding();
    }

    void setDiscarded() {
        this.allocator.setDiscarded();
    }

    public boolean accepts(OpOrder.Group opGroup) {
        OpOrder.Barrier barrier = this.writeBarrier;
        return barrier == null || barrier.isAfter(opGroup);
    }

    public boolean isLive() {
        return this.allocator.isLive();
    }

    public boolean isClean() {
        return this.rows.isEmpty();
    }

    public boolean isCleanAfter(ReplayPosition position) {
        return this.isClean() || position != null && this.minReplayPosition.compareTo(position) >= 0;
    }

    public boolean isExpired() {
        int period = this.cfs.metadata.getMemtableFlushPeriod();
        return period > 0 && System.nanoTime() - this.creationNano >= TimeUnit.MILLISECONDS.toNanos(period);
    }

    void put(DecoratedKey key, ColumnFamily cf, SecondaryIndexManager.Updater indexer, OpOrder.Group opGroup, ReplayPosition replayPosition) {
        AtomicBTreeColumns previous;
        if (replayPosition != null && this.writeBarrier != null) {
            ReplayPosition last;
            replayPosition = replayPosition.clone();
            while ((last = this.lastReplayPosition.get()).compareTo(replayPosition) < 0 && !this.lastReplayPosition.compareAndSet(last, replayPosition)) {
            }
        }
        if ((previous = (AtomicBTreeColumns)this.rows.get(key)) == null) {
            AtomicBTreeColumns empty = cf.cloneMeShallow(AtomicBTreeColumns.factory, false);
            DecoratedKey cloneKey = this.allocator.clone(key, opGroup);
            previous = this.rows.putIfAbsent(cloneKey, empty);
            if (previous == null) {
                previous = empty;
                int overhead = (int)(this.cfs.partitioner.getHeapSizeOf(key.getToken()) + (long)ROW_OVERHEAD_HEAP_SIZE);
                this.allocator.onHeap().allocate(overhead, opGroup);
            } else {
                this.allocator.reclaimer().reclaimImmediately(cloneKey);
            }
        }
        this.liveDataSize.addAndGet(previous.addAllWithSizeDelta(cf, this.allocator, opGroup, indexer));
        this.currentOperations.addAndGet(cf.getColumnCount() + (cf.isMarkedForDelete() ? 1 : 0) + cf.deletionInfo().rangeCount());
    }

    public String contents() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Map.Entry entry : this.rows.entrySet()) {
            builder.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    public FlushRunnable flushRunnable() {
        return new FlushRunnable(this.lastReplayPosition.get());
    }

    public String toString() {
        return String.format("Memtable-%s@%s(%s serialized bytes, %s ops, %.0f%%/%.0f%% of on/off-heap limit)", this.cfs.name, this.hashCode(), this.liveDataSize, this.currentOperations, Float.valueOf(100.0f * this.allocator.onHeap().ownershipRatio()), Float.valueOf(100.0f * this.allocator.offHeap().ownershipRatio()));
    }

    public Iterator<Map.Entry<DecoratedKey, ColumnFamily>> getEntryIterator(final RowPosition startWith, final RowPosition stopAt) {
        return new Iterator<Map.Entry<DecoratedKey, ColumnFamily>>(){
            private Iterator<? extends Map.Entry<? extends RowPosition, AtomicBTreeColumns>> iter;
            private Map.Entry<? extends RowPosition, ? extends ColumnFamily> currentEntry;
            {
                this.iter = stopAt.isMinimum(Memtable.this.cfs.partitioner) ? Memtable.this.rows.tailMap(startWith).entrySet().iterator() : Memtable.this.rows.subMap(startWith, true, stopAt, true).entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<DecoratedKey, ColumnFamily> next() {
                Map.Entry<? extends RowPosition, AtomicBTreeColumns> entry = this.iter.next();
                assert (entry.getKey() instanceof DecoratedKey);
                if (MEMORY_POOL.needToCopyOnHeap()) {
                    DecoratedKey key = (DecoratedKey)entry.getKey();
                    key = new BufferDecoratedKey(key.getToken(), HeapAllocator.instance.clone(key.getKey()));
                    ArrayBackedSortedColumns cells = ArrayBackedSortedColumns.localCopy(entry.getValue(), HeapAllocator.instance);
                    entry = new AbstractMap.SimpleImmutableEntry<DecoratedKey, ArrayBackedSortedColumns>(key, cells);
                }
                this.currentEntry = entry;
                return entry;
            }

            @Override
            public void remove() {
                this.iter.remove();
                Memtable.this.liveDataSize.addAndGet(-this.currentEntry.getValue().dataSize());
                this.currentEntry = null;
            }
        };
    }

    public ColumnFamily getColumnFamily(DecoratedKey key) {
        return (ColumnFamily)this.rows.get(key);
    }

    public long creationTime() {
        return this.creationTime;
    }

    public ReplayPosition getLastReplayPosition() {
        return this.lastReplayPosition.get();
    }

    static {
        OpOrder.Group group = new OpOrder().start();
        MemtableAllocator allocator = MEMORY_POOL.newAllocator();
        ConcurrentSkipListMap<DecoratedKey, Object> rows = new ConcurrentSkipListMap<DecoratedKey, Object>();
        int count = 100000;
        Object val = new Object();
        for (int i = 0; i < 100000; ++i) {
            rows.put(allocator.clone(new BufferDecoratedKey(new LongToken(Long.valueOf(i)), ByteBufferUtil.EMPTY_BYTE_BUFFER), group), val);
        }
        double avgSize = (double)ObjectSizes.measureDeep(rows) / 100000.0;
        int rowOverhead = (int)(avgSize - Math.floor(avgSize) < 0.05 ? Math.floor(avgSize) : Math.ceil(avgSize));
        rowOverhead = (int)((long)rowOverhead - ObjectSizes.measureDeep(new LongToken(0L)));
        rowOverhead = (int)((long)rowOverhead + AtomicBTreeColumns.EMPTY_SIZE);
        allocator.setDiscarding();
        allocator.setDiscarded();
        ROW_OVERHEAD_HEAP_SIZE = rowOverhead;
    }

    class FlushRunnable
    extends DiskAwareRunnable {
        private final ReplayPosition context;
        private final long estimatedSize;

        FlushRunnable(ReplayPosition context) {
            this.context = context;
            long keySize = 0L;
            for (RowPosition key : Memtable.this.rows.keySet()) {
                assert (key instanceof DecoratedKey);
                keySize += (long)((DecoratedKey)key).getKey().remaining();
            }
            this.estimatedSize = (long)((double)(keySize + keySize + Memtable.this.liveDataSize.get()) * 1.2);
        }

        @Override
        protected Directories.DataDirectory getWriteableLocation() {
            return Memtable.this.cfs.directories.getFlushLocation();
        }

        @Override
        public long getExpectedWriteSize() {
            return this.estimatedSize;
        }

        @Override
        protected void runWith(File sstableDirectory) throws Exception {
            assert (sstableDirectory != null) : "Flush task is not bound to any disk";
            SSTableReader sstable = this.writeSortedContents(this.context, sstableDirectory);
            Memtable.this.cfs.replaceFlushed(Memtable.this, sstable);
        }

        @Override
        protected Directories getDirectories() {
            return Memtable.this.cfs.directories;
        }

        private SSTableReader writeSortedContents(ReplayPosition context, File sstableDirectory) throws ExecutionException, InterruptedException {
            logger.info("Writing {}", (Object)Memtable.this.toString());
            SSTableWriter writer = this.createFlushWriter(Memtable.this.cfs.getTempSSTablePath(sstableDirectory));
            try {
                SSTableReader ssTable;
                for (Map.Entry entry : Memtable.this.rows.entrySet()) {
                    ColumnFamily cf = (ColumnFamily)entry.getValue();
                    if (cf.isMarkedForDelete() && cf.hasColumns() && Memtable.this.cfs.name.equals("batchlog") && Memtable.this.cfs.keyspace.getName().equals("system") || cf.isEmpty()) continue;
                    writer.append((DecoratedKey)entry.getKey(), cf);
                }
                if (writer.getFilePointer() > 0L) {
                    writer.isolateReferences();
                    ssTable = writer.closeAndOpenReader();
                    logger.info(String.format("Completed flushing %s (%d bytes) for commitlog position %s", ssTable.getFilename(), new File(ssTable.getFilename()).length(), context));
                } else {
                    writer.abort();
                    ssTable = null;
                    logger.info("Completed flushing; nothing needed to be retained.  Commitlog position was {}", (Object)context);
                }
                return ssTable;
            }
            catch (Throwable e) {
                writer.abort();
                throw Throwables.propagate((Throwable)e);
            }
        }

        public SSTableWriter createFlushWriter(String filename) throws ExecutionException, InterruptedException {
            MetadataCollector sstableMetadataCollector = new MetadataCollector(Memtable.this.cfs.metadata.comparator).replayPosition(this.context);
            return new SSTableWriter(filename, Memtable.this.rows.size(), 0L, Memtable.this.cfs.metadata, Memtable.this.cfs.partitioner, sstableMetadataCollector);
        }
    }
}

