/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class IndexExpression {
    public final ByteBuffer column;
    public final Operator operator;
    public final ByteBuffer value;

    public IndexExpression(ByteBuffer column, Operator operator, ByteBuffer value) {
        this.column = column;
        this.operator = operator;
        this.value = value;
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{ByteBufferUtil.bytesToHex(this.column), this.operator, ByteBufferUtil.bytesToHex(this.value)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexExpression)) {
            return false;
        }
        IndexExpression ie = (IndexExpression)o;
        return Objects.equal((Object)this.column, (Object)ie.column) && Objects.equal((Object)((Object)this.operator), (Object)((Object)ie.operator)) && Objects.equal((Object)this.value, (Object)ie.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.column, this.operator, this.value});
    }

    public static enum Operator {
        EQ,
        GTE,
        GT,
        LTE,
        LT,
        CONTAINS,
        CONTAINS_KEY;


        public static Operator findByOrdinal(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return EQ;
                }
                case 1: {
                    return GTE;
                }
                case 2: {
                    return GT;
                }
                case 3: {
                    return LTE;
                }
                case 4: {
                    return LT;
                }
                case 5: {
                    return CONTAINS;
                }
                case 6: {
                    return CONTAINS_KEY;
                }
            }
            throw new AssertionError();
        }

        public boolean allowsIndexQuery() {
            switch (this) {
                case EQ: 
                case CONTAINS: 
                case CONTAINS_KEY: {
                    return true;
                }
            }
            return false;
        }
    }
}

