/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.BufferCounterCell;
import org.apache.cassandra.db.BufferExpiringCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;

public abstract class AbstractCell
implements Cell {
    public static Iterator<OnDiskAtom> onDiskIterator(final DataInput in, final ColumnSerializer.Flag flag, final int expireBefore, final Descriptor.Version version, final CellNameType type) {
        return new AbstractIterator<OnDiskAtom>(){

            protected OnDiskAtom computeNext() {
                OnDiskAtom atom;
                try {
                    atom = type.onDiskAtomSerializer().deserializeFromSSTable(in, flag, expireBefore, version);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
                if (atom == null) {
                    return (OnDiskAtom)this.endOfData();
                }
                return atom;
            }
        };
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public boolean isLive(long now) {
        return true;
    }

    @Override
    public int cellDataSize() {
        return this.name().dataSize() + this.value().remaining() + TypeSizes.NATIVE.sizeof(this.timestamp());
    }

    @Override
    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        int valueSize = this.value().remaining();
        return (int)type.cellSerializer().serializedSize(this.name(), typeSizes) + 1 + typeSizes.sizeof(this.timestamp()) + typeSizes.sizeof(valueSize) + valueSize;
    }

    @Override
    public int serializationFlags() {
        return 0;
    }

    @Override
    public Cell diff(Cell cell) {
        if (this.timestamp() < cell.timestamp()) {
            return cell;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name().toByteBuffer().duplicate());
        digest.update(this.value().duplicate());
        FBUtilities.updateWithLong(digest, this.timestamp());
        FBUtilities.updateWithByte(digest, this.serializationFlags());
    }

    @Override
    public int getLocalDeletionTime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Cell reconcile(Cell cell) {
        if (!this.isLive()) {
            return this.timestamp() < cell.timestamp() ? cell : this;
        }
        if (!cell.isLive()) {
            return this.timestamp() > cell.timestamp() ? this : cell;
        }
        if (this.timestamp() == cell.timestamp()) {
            return this.value().compareTo(cell.value()) < 0 ? cell : this;
        }
        return this.timestamp() < cell.timestamp() ? cell : this;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Cell && this.equals((Cell)o);
    }

    public boolean equals(Cell cell) {
        return this.timestamp() == cell.timestamp() && this.name().equals(cell.name()) && this.value().equals(cell.value());
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s:%b:%d@%d", comparator.getString(this.name()), !this.isLive(), this.value().remaining(), this.timestamp());
    }

    public void validateName(CFMetaData metadata) throws MarshalException {
        metadata.comparator.validate(this.name());
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        AbstractType<?> valueValidator = metadata.getValueValidator(this.name());
        if (valueValidator != null) {
            valueValidator.validate(this.value());
        }
    }

    public static Cell create(CellName name, ByteBuffer value, long timestamp, int ttl, CFMetaData metadata) {
        if (ttl <= 0) {
            ttl = metadata.getDefaultTimeToLive();
        }
        return ttl > 0 ? new BufferExpiringCell(name, value, timestamp, ttl) : new BufferCell(name, value, timestamp);
    }

    public static Cell diff(CounterCell a, Cell b) {
        if (a.timestamp() < b.timestamp()) {
            return b;
        }
        assert (b instanceof CounterCell) : "Wrong class type: " + b.getClass();
        if (a.timestampOfLastDelete() < ((CounterCell)b).timestampOfLastDelete()) {
            return b;
        }
        CounterContext.Relationship rel = CounterCell.contextManager.diff(b.value(), a.value());
        return rel == CounterContext.Relationship.GREATER_THAN || rel == CounterContext.Relationship.DISJOINT ? b : null;
    }

    public static Cell reconcile(CounterCell a, Cell b) {
        assert (b instanceof CounterCell || b instanceof DeletedCell) : "Wrong class type: " + b.getClass();
        if (!b.isLive()) {
            if (a.timestamp() < b.timestamp()) {
                return b;
            }
            if (a.timestampOfLastDelete() >= b.timestamp()) {
                return a;
            }
            return new BufferCounterCell(a.name(), a.value(), a.timestamp(), b.timestamp());
        }
        assert (b instanceof CounterCell) : "Wrong class type: " + b.getClass();
        if (a.timestamp() < ((CounterCell)b).timestampOfLastDelete()) {
            return b;
        }
        if (a.timestampOfLastDelete() > b.timestamp()) {
            return a;
        }
        ByteBuffer context = CounterCell.contextManager.merge(a.value(), b.value());
        if (context == a.value() && a.timestamp() >= b.timestamp() && a.timestampOfLastDelete() >= ((CounterCell)b).timestampOfLastDelete()) {
            return a;
        }
        if (context == b.value() && b.timestamp() >= a.timestamp() && ((CounterCell)b).timestampOfLastDelete() >= a.timestampOfLastDelete()) {
            return b;
        }
        return new BufferCounterCell(a.name(), context, Math.max(a.timestamp(), b.timestamp()), Math.max(a.timestampOfLastDelete(), ((CounterCell)b).timestampOfLastDelete()));
    }
}

