/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.exceptions.InvalidRequestException;

public interface Restriction {
    public boolean isOnToken();

    public boolean isSlice();

    public boolean isEQ();

    public boolean isIN();

    public boolean isContains();

    public List<ByteBuffer> values(QueryOptions var1) throws InvalidRequestException;

    public static class Contains
    implements Restriction {
        private List<Term> values;
        private List<Term> keys;

        public boolean hasContains() {
            return this.values != null;
        }

        public boolean hasContainsKey() {
            return this.keys != null;
        }

        public void add(Term t, boolean isKey) {
            if (isKey) {
                this.addKey(t);
            } else {
                this.addValue(t);
            }
        }

        public void addValue(Term t) {
            if (this.values == null) {
                this.values = new ArrayList<Term>();
            }
            this.values.add(t);
        }

        public void addKey(Term t) {
            if (this.keys == null) {
                this.keys = new ArrayList<Term>();
            }
            this.keys.add(t);
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            if (this.values == null) {
                return Collections.emptyList();
            }
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
            for (Term value : this.values) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        public List<ByteBuffer> keys(QueryOptions options) throws InvalidRequestException {
            if (this.keys == null) {
                return Collections.emptyList();
            }
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.keys.size());
            for (Term value : this.keys) {
                buffers.add(value.bindAndGet(options));
            }
            return buffers;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return true;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        public String toString() {
            return String.format("CONTAINS(values=%s, keys=%s)", this.values, this.keys);
        }
    }

    public static class Slice
    implements Restriction {
        private final Term[] bounds = new Term[2];
        private final boolean[] boundInclusive = new boolean[2];
        private final boolean onToken;
        private final ColumnIdentifier[] previous = new ColumnIdentifier[2];

        public Slice(boolean onToken) {
            this.onToken = onToken;
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        public boolean hasBound(Bound b) {
            return this.bounds[b.idx] != null;
        }

        public ByteBuffer bound(Bound b, QueryOptions options) throws InvalidRequestException {
            return this.bounds[b.idx].bindAndGet(options);
        }

        public boolean isInclusive(Bound b) {
            return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
        }

        public Relation.Type getRelation(Bound eocBound, Bound inclusiveBound) {
            switch (eocBound) {
                case START: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.GTE : Relation.Type.GT;
                }
                case END: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.LTE : Relation.Type.LT;
                }
            }
            throw new AssertionError();
        }

        public IndexExpression.Operator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? IndexExpression.Operator.GTE : IndexExpression.Operator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? IndexExpression.Operator.LTE : IndexExpression.Operator.LT;
                }
            }
            throw new AssertionError();
        }

        public void setBound(ColumnIdentifier name, Relation.Type type, Term t, ColumnIdentifier previousName) throws InvalidRequestException {
            boolean inclusive;
            Bound b;
            switch (type) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = false;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.bounds[b.idx] != null) {
                throw new InvalidRequestException(String.format("Invalid restrictions found on %s", name));
            }
            this.bounds[b.idx] = t;
            this.boundInclusive[b.idx] = inclusive;
            Bound reverse = Bound.reverse(b);
            if (this.hasBound(reverse) && !Objects.equal((Object)previousName, (Object)this.previous[reverse.idx])) {
                throw new InvalidRequestException(String.format("Clustering column %s cannot be restricted both inside a tuple notation and outside it", name));
            }
            this.previous[b.idx] = previousName;
        }

        public boolean isPartOfTuple() {
            return this.previous[Bound.START.idx] != null || this.previous[Bound.END.idx] != null;
        }

        public String toString() {
            return String.format("SLICE(%s %s, %s %s)%s", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1], this.onToken ? "*" : "");
        }
    }

    public static abstract class IN
    implements Restriction {
        public static IN create(List<Term> values) {
            return new WithValues(values);
        }

        public static IN create(Term value) {
            assert (value instanceof Lists.Marker);
            return new WithMarker((Lists.Marker)value);
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        public abstract boolean canHaveOnlyOneValue();

        @Override
        public boolean isOnToken() {
            return false;
        }

        private static class WithMarker
        extends IN {
            private final Lists.Marker marker;

            private WithMarker(Lists.Marker marker) {
                this.marker = marker;
            }

            @Override
            public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
                Lists.Value lval = this.marker.bind(options);
                if (lval == null) {
                    throw new InvalidRequestException("Invalid null value for IN restriction");
                }
                return lval.elements;
            }

            @Override
            public boolean canHaveOnlyOneValue() {
                return false;
            }

            public String toString() {
                return "IN ?";
            }
        }

        private static class WithValues
        extends IN {
            private final List<Term> values;

            private WithValues(List<Term> values) {
                this.values = values;
            }

            @Override
            public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
                ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
                for (Term value : this.values) {
                    buffers.add(value.bindAndGet(options));
                }
                return buffers;
            }

            @Override
            public boolean canHaveOnlyOneValue() {
                return this.values.size() == 1;
            }

            public String toString() {
                return String.format("IN(%s)", this.values);
            }
        }
    }

    public static class EQ
    implements Restriction {
        private final Term value;
        private final boolean onToken;

        public EQ(Term value, boolean onToken) {
            this.value = value;
            this.onToken = onToken;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.value.bindAndGet(options));
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return true;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isContains() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        public String toString() {
            return String.format("EQ(%s)%s", this.value, this.onToken ? "*" : "");
        }
    }
}

