/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionDetails;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraAuthorizer
implements IAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(CassandraAuthorizer.class);
    private static final String USERNAME = "username";
    private static final String RESOURCE = "resource";
    private static final String PERMISSIONS = "permissions";
    private static final String PERMISSIONS_CF = "permissions";
    private static final String PERMISSIONS_CF_SCHEMA = String.format("CREATE TABLE %s.%s (username text,resource text,permissions set<text>,PRIMARY KEY(username, resource)) WITH gc_grace_seconds=%d", "system_auth", "permissions", 7776000);
    private SelectStatement authorizeStatement;

    @Override
    public Set<Permission> authorize(AuthenticatedUser user, IResource resource) {
        UntypedResultSet result;
        if (user.isSuper()) {
            return Permission.ALL;
        }
        try {
            ResultMessage.Rows rows = this.authorizeStatement.execute(QueryState.forInternalCalls(), QueryOptions.forInternalCalls(ConsistencyLevel.ONE, Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(user.getName()), ByteBufferUtil.bytes(resource.getName())})));
            result = UntypedResultSet.create(rows.result);
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
        catch (RequestExecutionException e) {
            logger.warn("CassandraAuthorizer failed to authorize {} for {}", (Object)user, (Object)resource);
            return Permission.NONE;
        }
        if (result.isEmpty() || !result.one().has("permissions")) {
            return Permission.NONE;
        }
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (String perm : result.one().getSet("permissions", UTF8Type.instance)) {
            permissions.add(Permission.valueOf(perm));
        }
        return permissions;
    }

    @Override
    public void grant(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, String to) throws RequestExecutionException {
        this.modify(permissions, resource, to, "+");
    }

    @Override
    public void revoke(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, String from) throws RequestExecutionException {
        this.modify(permissions, resource, from, "-");
    }

    private void modify(Set<Permission> permissions, IResource resource, String user, String op) throws RequestExecutionException {
        CassandraAuthorizer.process(String.format("UPDATE %s.%s SET permissions = permissions %s {%s} WHERE username = '%s' AND resource = '%s'", "system_auth", "permissions", op, "'" + StringUtils.join(permissions, (String)"','") + "'", CassandraAuthorizer.escape(user), CassandraAuthorizer.escape(resource.getName())));
    }

    @Override
    public Set<PermissionDetails> list(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, String of) throws RequestValidationException, RequestExecutionException {
        if (!performer.isSuper() && !performer.getName().equals(of)) {
            throw new UnauthorizedException(String.format("You are not authorized to view %s's permissions", of == null ? "everyone" : of));
        }
        HashSet<PermissionDetails> details = new HashSet<PermissionDetails>();
        for (UntypedResultSet.Row row : CassandraAuthorizer.process(CassandraAuthorizer.buildListQuery(resource, of))) {
            if (!row.has("permissions")) continue;
            for (String p : row.getSet("permissions", UTF8Type.instance)) {
                Permission permission = Permission.valueOf(p);
                if (!permissions.contains((Object)permission)) continue;
                details.add(new PermissionDetails(row.getString(USERNAME), DataResource.fromName(row.getString(RESOURCE)), permission));
            }
        }
        return details;
    }

    private static String buildListQuery(IResource resource, String of) {
        ArrayList vars = Lists.newArrayList((Object[])new String[]{"system_auth", "permissions"});
        ArrayList<String> conditions = new ArrayList<String>();
        if (resource != null) {
            conditions.add("resource = '%s'");
            vars.add(CassandraAuthorizer.escape(resource.getName()));
        }
        if (of != null) {
            conditions.add("username = '%s'");
            vars.add(CassandraAuthorizer.escape(of));
        }
        String query = "SELECT username, resource, permissions FROM %s.%s";
        if (!conditions.isEmpty()) {
            query = query + " WHERE " + StringUtils.join(conditions, (String)" AND ");
        }
        if (resource != null && of == null) {
            query = query + " ALLOW FILTERING";
        }
        return String.format(query, vars.toArray());
    }

    @Override
    public void revokeAll(String droppedUser) {
        try {
            CassandraAuthorizer.process(String.format("DELETE FROM %s.%s WHERE username = '%s'", "system_auth", "permissions", CassandraAuthorizer.escape(droppedUser)));
        }
        catch (Throwable e) {
            logger.warn("CassandraAuthorizer failed to revoke all permissions of {}: {}", (Object)droppedUser, (Object)e);
        }
    }

    @Override
    public void revokeAll(IResource droppedResource) {
        UntypedResultSet rows;
        try {
            rows = CassandraAuthorizer.process(String.format("SELECT username FROM %s.%s WHERE resource = '%s' ALLOW FILTERING", "system_auth", "permissions", CassandraAuthorizer.escape(droppedResource.getName())));
        }
        catch (Throwable e) {
            logger.warn("CassandraAuthorizer failed to revoke all permissions on {}: {}", (Object)droppedResource, (Object)e);
            return;
        }
        for (UntypedResultSet.Row row : rows) {
            try {
                CassandraAuthorizer.process(String.format("DELETE FROM %s.%s WHERE username = '%s' AND resource = '%s'", "system_auth", "permissions", CassandraAuthorizer.escape(row.getString(USERNAME)), CassandraAuthorizer.escape(droppedResource.getName())));
            }
            catch (Throwable e) {
                logger.warn("CassandraAuthorizer failed to revoke all permissions on {}: {}", (Object)droppedResource, (Object)e);
            }
        }
    }

    public Set<DataResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.columnFamily("system_auth", "permissions"));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public void setup() {
        Auth.setupTable("permissions", PERMISSIONS_CF_SCHEMA);
        try {
            String query = String.format("SELECT permissions FROM %s.%s WHERE username = ? AND resource = ?", "system_auth", "permissions");
            this.authorizeStatement = (SelectStatement)QueryProcessor.parseStatement((String)query).prepare().statement;
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    private static UntypedResultSet process(String query) throws RequestExecutionException {
        return QueryProcessor.process(query, ConsistencyLevel.ONE);
    }
}

