/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.Pool;
import org.apache.cassandra.utils.memory.PoolAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapSlabAllocator
extends PoolAllocator {
    private static final Logger logger = LoggerFactory.getLogger(HeapSlabAllocator.class);
    private static final int REGION_SIZE = 0x100000;
    private static final int MAX_CLONED_SIZE = 131072;
    private static final ConcurrentLinkedQueue<Region> RACE_ALLOCATED = new ConcurrentLinkedQueue();
    private final AtomicReference<Region> currentRegion = new AtomicReference();
    private final AtomicInteger regionCount = new AtomicInteger(0);
    private AtomicLong unslabbed = new AtomicLong(0L);

    HeapSlabAllocator(Pool pool) {
        super(pool);
    }

    @Override
    public ByteBuffer allocate(int size) {
        return this.allocate(size, null);
    }

    @Override
    public ByteBuffer allocate(int size, OpOrder.Group opGroup) {
        assert (size >= 0);
        if (size == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        this.markAllocated(size, opGroup);
        if (size > 131072) {
            this.unslabbed.addAndGet(size);
            return ByteBuffer.allocate(size);
        }
        Region region;
        ByteBuffer cloned;
        while ((cloned = (region = this.getRegion()).allocate(size)) == null) {
            this.currentRegion.compareAndSet(region, null);
        }
        return cloned;
    }

    @Override
    public void free(ByteBuffer name) {
    }

    private Region getRegion() {
        Region region;
        while ((region = this.currentRegion.get()) == null) {
            region = RACE_ALLOCATED.poll();
            if (region == null) {
                region = new Region(0x100000);
            }
            if (this.currentRegion.compareAndSet(null, region)) {
                this.regionCount.incrementAndGet();
                logger.trace("{} regions now allocated in {}", (Object)this.regionCount, (Object)this);
                return region;
            }
            RACE_ALLOCATED.add(region);
        }
        return region;
    }

    private static class Region {
        private ByteBuffer data;
        private AtomicInteger nextFreeOffset = new AtomicInteger(0);
        private AtomicInteger allocCount = new AtomicInteger();

        private Region(int size) {
            this.data = ByteBuffer.allocate(size);
        }

        public ByteBuffer allocate(int size) {
            int oldOffset;
            do {
                if ((oldOffset = this.nextFreeOffset.get()) + size <= this.data.capacity()) continue;
                return null;
            } while (!this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size));
            this.allocCount.incrementAndGet();
            return (ByteBuffer)this.data.duplicate().position(oldOffset).limit(oldOffset + size);
        }

        public String toString() {
            return "Region@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.data.capacity() - this.nextFreeOffset.get());
        }
    }
}

