/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.UpdateFunction;

final class NodeBuilder {
    private static final int MAX_KEYS = 1 + BTree.FAN_FACTOR * 2;
    private NodeBuilder parent;
    private NodeBuilder child;
    private Object[] buildKeys = new Object[MAX_KEYS];
    private Object[] buildChildren = new Object[1 + MAX_KEYS];
    private int buildKeyPosition;
    private int buildChildPosition;
    private int maxBuildKeyPosition;
    private int maxBuildChildPosition;
    private Object[] copyFrom;
    private int copyFromKeyPosition;
    private int copyFromChildPosition;
    private UpdateFunction updateFunction;
    private Comparator comparator;
    private Object upperBound;

    NodeBuilder() {
    }

    void clear() {
        NodeBuilder current = this;
        while (current != null) {
            if (current.upperBound != null) {
                current.reset(null, null, null, null);
                Arrays.fill(current.buildKeys, 0, current.maxBuildKeyPosition, null);
                Arrays.fill(current.buildChildren, 0, current.maxBuildChildPosition, null);
                current.maxBuildKeyPosition = 0;
                current.maxBuildChildPosition = 0;
            }
            current = current.child;
        }
    }

    void reset(Object[] copyFrom, Object upperBound, UpdateFunction updateFunction, Comparator comparator) {
        this.copyFrom = copyFrom;
        this.upperBound = upperBound;
        this.updateFunction = updateFunction;
        this.comparator = comparator;
        this.maxBuildKeyPosition = Math.max(this.maxBuildKeyPosition, this.buildKeyPosition);
        this.maxBuildChildPosition = Math.max(this.maxBuildChildPosition, this.buildChildPosition);
        this.buildKeyPosition = 0;
        this.buildChildPosition = 0;
        this.copyFromKeyPosition = 0;
        this.copyFromChildPosition = 0;
    }

    NodeBuilder update(Object key) {
        assert (this.copyFrom != null);
        int copyFromKeyEnd = BTree.getKeyEnd(this.copyFrom);
        int i = BTree.find(this.comparator, key, this.copyFrom, this.copyFromKeyPosition, copyFromKeyEnd);
        boolean found = i >= 0;
        boolean owns = true;
        if (!found && (i = -i - 1) == copyFromKeyEnd && BTree.compare(this.comparator, this.upperBound, key) <= 0) {
            owns = false;
        }
        if (BTree.isLeaf(this.copyFrom)) {
            this.copyKeys(i);
            if (owns) {
                if (found) {
                    this.replaceNextKey(key);
                } else {
                    this.addNewKey(key);
                }
                return null;
            }
        } else {
            if (found) {
                this.copyKeys(i);
                this.replaceNextKey(key);
                this.copyChildren(i + 1);
                return null;
            }
            if (owns) {
                this.copyKeys(i);
                this.copyChildren(i);
                Object newUpperBound = i < copyFromKeyEnd ? this.copyFrom[i] : this.upperBound;
                Object[] descendInto = (Object[])this.copyFrom[copyFromKeyEnd + i];
                this.ensureChild().reset(descendInto, newUpperBound, this.updateFunction, this.comparator);
                return this.child;
            }
            this.copyKeys(copyFromKeyEnd);
            this.copyChildren(copyFromKeyEnd + 1);
        }
        if (key == BTree.POSITIVE_INFINITY && this.isRoot()) {
            return null;
        }
        return this.ascend();
    }

    boolean isRoot() {
        return (this.parent == null || this.parent.upperBound == null) && this.buildKeyPosition <= BTree.FAN_FACTOR;
    }

    NodeBuilder ascendToRoot() {
        NodeBuilder current = this;
        while (!current.isRoot()) {
            current = current.ascend();
        }
        return current;
    }

    Object[] toNode() {
        assert (this.buildKeyPosition <= BTree.FAN_FACTOR && this.buildKeyPosition > 0) : this.buildKeyPosition;
        return this.buildFromRange(0, this.buildKeyPosition, BTree.isLeaf(this.copyFrom), false);
    }

    private NodeBuilder ascend() {
        this.ensureParent();
        boolean isLeaf = BTree.isLeaf(this.copyFrom);
        if (this.buildKeyPosition > BTree.FAN_FACTOR) {
            int mid = this.buildKeyPosition / 2;
            this.parent.addExtraChild(this.buildFromRange(0, mid, isLeaf, true), this.buildKeys[mid]);
            this.parent.finishChild(this.buildFromRange(mid + 1, this.buildKeyPosition - (mid + 1), isLeaf, false));
        } else {
            this.parent.finishChild(this.buildFromRange(0, this.buildKeyPosition, isLeaf, false));
        }
        return this.parent;
    }

    private void copyKeys(int upToKeyPosition) {
        if (this.copyFromKeyPosition >= upToKeyPosition) {
            return;
        }
        int len = upToKeyPosition - this.copyFromKeyPosition;
        assert (len <= BTree.FAN_FACTOR) : upToKeyPosition + "," + this.copyFromKeyPosition;
        this.ensureRoom(this.buildKeyPosition + len);
        System.arraycopy(this.copyFrom, this.copyFromKeyPosition, this.buildKeys, this.buildKeyPosition, len);
        this.copyFromKeyPosition = upToKeyPosition;
        this.buildKeyPosition += len;
    }

    private void replaceNextKey(Object with) {
        this.ensureRoom(this.buildKeyPosition + 1);
        if (this.updateFunction != null) {
            with = this.updateFunction.apply(this.copyFrom[this.copyFromKeyPosition], with);
        }
        this.buildKeys[this.buildKeyPosition++] = with;
        ++this.copyFromKeyPosition;
    }

    void addNewKey(Object key) {
        this.ensureRoom(this.buildKeyPosition + 1);
        if (this.updateFunction != null) {
            key = this.updateFunction.apply(key);
        }
        this.buildKeys[this.buildKeyPosition++] = key;
    }

    private void copyChildren(int upToChildPosition) {
        if (this.copyFromChildPosition >= upToChildPosition) {
            return;
        }
        int len = upToChildPosition - this.copyFromChildPosition;
        System.arraycopy(this.copyFrom, BTree.getKeyEnd(this.copyFrom) + this.copyFromChildPosition, this.buildChildren, this.buildChildPosition, len);
        this.copyFromChildPosition = upToChildPosition;
        this.buildChildPosition += len;
    }

    private void addExtraChild(Object[] child, Object upperBound) {
        this.ensureRoom(this.buildKeyPosition + 1);
        this.buildKeys[this.buildKeyPosition++] = upperBound;
        this.buildChildren[this.buildChildPosition++] = child;
    }

    private void finishChild(Object[] child) {
        this.buildChildren[this.buildChildPosition++] = child;
        ++this.copyFromChildPosition;
    }

    private void ensureRoom(int nextBuildKeyPosition) {
        if (nextBuildKeyPosition < MAX_KEYS) {
            return;
        }
        Object[] flushUp = this.buildFromRange(0, BTree.FAN_FACTOR, BTree.isLeaf(this.copyFrom), true);
        this.ensureParent().addExtraChild(flushUp, this.buildKeys[BTree.FAN_FACTOR]);
        int size = BTree.FAN_FACTOR + 1;
        assert (size <= this.buildKeyPosition) : this.buildKeyPosition + "," + nextBuildKeyPosition;
        System.arraycopy(this.buildKeys, size, this.buildKeys, 0, this.buildKeyPosition - size);
        this.buildKeyPosition -= size;
        this.maxBuildKeyPosition = this.buildKeys.length;
        if (this.buildChildPosition > 0) {
            System.arraycopy(this.buildChildren, size, this.buildChildren, 0, this.buildChildPosition - size);
            this.buildChildPosition -= size;
            this.maxBuildChildPosition = this.buildChildren.length;
        }
    }

    private Object[] buildFromRange(int offset, int keyLength, boolean isLeaf, boolean isExtra) {
        Object[] a;
        if (isLeaf) {
            a = new Object[keyLength + (keyLength & 1)];
            System.arraycopy(this.buildKeys, offset, a, 0, keyLength);
        } else {
            a = new Object[1 + keyLength * 2];
            System.arraycopy(this.buildKeys, offset, a, 0, keyLength);
            System.arraycopy(this.buildChildren, offset, a, keyLength, keyLength + 1);
        }
        if (this.updateFunction != null) {
            if (isExtra) {
                this.updateFunction.allocated(ObjectSizes.sizeOfArray(a));
            } else if (a.length != this.copyFrom.length) {
                this.updateFunction.allocated(ObjectSizes.sizeOfArray(a) - (this.copyFrom.length == 0 ? 0L : ObjectSizes.sizeOfArray(this.copyFrom)));
            }
        }
        return a;
    }

    private NodeBuilder ensureParent() {
        if (this.parent == null) {
            this.parent = new NodeBuilder();
            this.parent.child = this;
        }
        if (this.parent.upperBound == null) {
            this.parent.reset(BTree.EMPTY_BRANCH, this.upperBound, this.updateFunction, this.comparator);
        }
        return this.parent;
    }

    NodeBuilder ensureChild() {
        if (this.child == null) {
            this.child = new NodeBuilder();
            this.child.parent = this;
        }
        return this.child;
    }
}

