/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Collection;
import java.util.Comparator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.NodeBuilder;
import org.apache.cassandra.utils.btree.UpdateFunction;

final class Builder {
    private final NodeBuilder rootBuilder = new NodeBuilder();

    Builder() {
    }

    public <V> Object[] update(Object[] btree, Comparator<V> comparator, Collection<V> source, UpdateFunction<V> updateF) {
        NodeBuilder next;
        NodeBuilder current = this.rootBuilder;
        current.reset(btree, BTree.POSITIVE_INFINITY, updateF, comparator);
        block0: for (V key : source) {
            while (true) {
                if (updateF != null && updateF.abortEarly()) {
                    this.rootBuilder.clear();
                    return null;
                }
                NodeBuilder next2 = current.update(key);
                if (next2 == null) continue block0;
                current = next2;
            }
        }
        while ((next = current.update(BTree.POSITIVE_INFINITY)) != null) {
            current = next;
        }
        assert (current.isRoot());
        Object[] r = current.toNode();
        current.clear();
        return r;
    }

    public <V> Object[] build(Collection<V> source, int size) {
        NodeBuilder current = this.rootBuilder;
        while ((size >>= BTree.FAN_SHIFT) > 0) {
            current = current.ensureChild();
        }
        current.reset(BTree.EMPTY_LEAF, BTree.POSITIVE_INFINITY, null, null);
        for (V key : source) {
            current.addNewKey(key);
        }
        current = current.ascendToRoot();
        Object[] r = current.toNode();
        current.clear();
        return r;
    }
}

