/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.Builder;
import org.apache.cassandra.utils.btree.Cursor;
import org.apache.cassandra.utils.btree.UpdateFunction;

public class BTree {
    static final int FAN_SHIFT;
    static final int FAN_FACTOR;
    static final int QUICK_MERGE_LIMIT;
    static final int MAX_DEPTH;
    static final Object[] EMPTY_LEAF;
    static final Object[] EMPTY_BRANCH;
    static final Special POSITIVE_INFINITY;
    static final Special NEGATIVE_INFINITY;
    private static final ThreadLocal<Builder> modifier;

    public static Object[] empty() {
        return EMPTY_LEAF;
    }

    public static <V> Object[] build(Collection<V> source, Comparator<V> comparator, boolean sorted, UpdateFunction<V> updateF) {
        int size = source.size();
        if (size < FAN_FACTOR) {
            Object[] values = source.toArray(new Object[size + (size & 1)]);
            if (!sorted) {
                Arrays.sort(values, 0, size, comparator);
            }
            if (updateF != null) {
                for (int i = 0; i < size; ++i) {
                    values[i] = updateF.apply(values[i]);
                }
                updateF.allocated(ObjectSizes.sizeOfArray(values));
            }
            return values;
        }
        if (!sorted) {
            source = BTree.sorted(source, comparator, size);
        }
        return modifier.get().build(source, size);
    }

    public static <V> Object[] update(Object[] btree, Comparator<V> comparator, Collection<V> updateWith, boolean updateWithIsSorted) {
        return BTree.update(btree, comparator, updateWith, updateWithIsSorted, null);
    }

    public static <V> Object[] update(Object[] btree, Comparator<V> comparator, Collection<V> updateWith, boolean updateWithIsSorted, UpdateFunction<V> updateF) {
        if (btree.length == 0) {
            return BTree.build(updateWith, comparator, updateWithIsSorted, updateF);
        }
        if (!updateWithIsSorted) {
            updateWith = BTree.sorted(updateWith, comparator, updateWith.size());
        }
        if (BTree.isLeaf(btree) && btree.length + updateWith.size() < QUICK_MERGE_LIMIT) {
            int btreeOffset = 0;
            int keyEnd = BTree.getLeafKeyEnd(btree);
            Object[] merged = new Object[QUICK_MERGE_LIMIT];
            int mergedCount = 0;
            for (Object v : updateWith) {
                int count;
                boolean found;
                int i = BTree.find(comparator, v, btree, btreeOffset, keyEnd);
                boolean bl = found = i >= 0;
                if (!found) {
                    i = -i - 1;
                }
                if ((count = i - btreeOffset) > 0) {
                    System.arraycopy(btree, btreeOffset, merged, mergedCount, count);
                    mergedCount += count;
                    btreeOffset = i;
                }
                if (found) {
                    ++btreeOffset;
                    if (updateF != null) {
                        v = updateF.apply(btree[i], v);
                    }
                } else if (updateF != null) {
                    v = updateF.apply(v);
                }
                merged[mergedCount++] = v;
            }
            if (btreeOffset < keyEnd) {
                int count = keyEnd - btreeOffset;
                System.arraycopy(btree, btreeOffset, merged, mergedCount, count);
                mergedCount += count;
            }
            assert (mergedCount <= FAN_FACTOR);
            Object[] r = Arrays.copyOfRange(merged, 0, mergedCount + (mergedCount & 1));
            if (updateF != null) {
                updateF.allocated(ObjectSizes.sizeOfArray(r) - (btree.length == 0 ? 0L : ObjectSizes.sizeOfArray(btree)));
            }
            return r;
        }
        return modifier.get().update(btree, comparator, updateWith, updateF);
    }

    public static <V> Cursor<V> slice(Object[] btree, boolean forwards) {
        Cursor r = Cursor.newCursor();
        r.reset(btree, forwards);
        return r;
    }

    public static <V> Cursor<V> slice(Object[] btree, Comparator<V> comparator, V start, V end, boolean forwards) {
        Cursor<V> r = Cursor.newCursor();
        r.reset(btree, comparator, start, end, forwards);
        return r;
    }

    public static <V> Cursor<V> slice(Object[] btree, Comparator<V> comparator, V start, boolean startInclusive, V end, boolean endInclusive, boolean forwards) {
        Cursor<V> r = Cursor.newCursor();
        r.reset(btree, comparator, start, startInclusive, end, endInclusive, forwards);
        return r;
    }

    public static <V> V find(Object[] node, Comparator<V> comparator, V find) {
        while (true) {
            int keyEnd;
            int i;
            if ((i = BTree.find(comparator, find, node, 0, keyEnd = BTree.getKeyEnd(node))) >= 0) {
                return (V)node[i];
            }
            if (BTree.isLeaf(node)) break;
            i = -i - 1;
            node = (Object[])node[keyEnd + i];
        }
        return null;
    }

    static <V> int find(Comparator<V> comparator, Object key, Object[] a, int fromIndex, int toIndex) {
        if (fromIndex >= toIndex) {
            return -(fromIndex + 1);
        }
        int c = BTree.compare(comparator, key, a[fromIndex]);
        if (c <= 0) {
            if (c == 0) {
                return fromIndex;
            }
            return -(fromIndex + 1);
        }
        int low = fromIndex + 1;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = BTree.compare(comparator, key, a[mid]);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    static int getKeyEnd(Object[] node) {
        if (BTree.isLeaf(node)) {
            return BTree.getLeafKeyEnd(node);
        }
        return BTree.getBranchKeyEnd(node);
    }

    static int getLeafKeyEnd(Object[] node) {
        int len = node.length;
        if (len == 0) {
            return 0;
        }
        if (node[len - 1] == null) {
            return len - 1;
        }
        return len;
    }

    static int getBranchKeyEnd(Object[] node) {
        return node.length / 2;
    }

    static boolean isLeaf(Object[] node) {
        return (node.length & 1) == 0;
    }

    private static <V> Collection<V> sorted(Collection<V> collection, Comparator<V> comparator, int size) {
        Object[] vs = collection.toArray(new Object[size]);
        Arrays.sort(vs, comparator);
        return Arrays.asList(vs);
    }

    static <V> int compare(Comparator<V> cmp, Object a, Object b) {
        if (a instanceof Special) {
            return ((Special)a).compareTo(b);
        }
        if (b instanceof Special) {
            return -((Special)b).compareTo(a);
        }
        return cmp.compare(a, b);
    }

    public static boolean isWellFormed(Object[] btree) {
        return BTree.isWellFormed(null, btree, true, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    public static boolean isWellFormed(Object[] btree, Comparator<? extends Object> cmp) {
        return BTree.isWellFormed(cmp, btree, true, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private static boolean isWellFormed(Comparator<?> cmp, Object[] node, boolean isRoot, Object min, Object max) {
        int childOffset;
        if (cmp != null && !BTree.isNodeWellFormed(cmp, node, min, max)) {
            return false;
        }
        if (BTree.isLeaf(node)) {
            if (isRoot) {
                return node.length <= FAN_FACTOR;
            }
            return node.length >= FAN_FACTOR / 2 && node.length <= FAN_FACTOR;
        }
        int type = 0;
        for (int i = childOffset = BTree.getBranchKeyEnd(node); i < node.length; ++i) {
            Object localmax;
            Object[] child = (Object[])node[i];
            Object object = localmax = i < node.length - 1 ? node[i - childOffset] : max;
            if (!BTree.isWellFormed(cmp, child, false, min, localmax)) {
                return false;
            }
            type |= BTree.isLeaf(child) ? 1 : 2;
            min = localmax;
        }
        return type < 3;
    }

    private static boolean isNodeWellFormed(Comparator<?> cmp, Object[] node, Object min, Object max) {
        Object previous = min;
        int end = BTree.getKeyEnd(node);
        for (int i = 0; i < end; ++i) {
            Object current = node[i];
            if (BTree.compare(cmp, previous, current) >= 0) {
                return false;
            }
            previous = current;
        }
        return BTree.compare(cmp, previous, max) < 0;
    }

    static {
        int fanfactor = 32;
        if (System.getProperty("cassandra.btree.fanfactor") != null) {
            fanfactor = Integer.parseInt(System.getProperty("cassandra.btree.fanfactor"));
        }
        int shift = 1;
        while (1 << shift < fanfactor) {
            ++shift;
        }
        FAN_SHIFT = shift;
        FAN_FACTOR = 1 << FAN_SHIFT;
        QUICK_MERGE_LIMIT = Math.min(FAN_FACTOR, 16) * 2;
        MAX_DEPTH = (int)Math.ceil(31.0 / (double)(FAN_SHIFT - 1));
        EMPTY_LEAF = new Object[0];
        EMPTY_BRANCH = new Object[1];
        POSITIVE_INFINITY = new Special(){

            @Override
            public int compareTo(Object o) {
                return o == this ? 0 : 1;
            }
        };
        NEGATIVE_INFINITY = new Special(){

            @Override
            public int compareTo(Object o) {
                return o == this ? 0 : -1;
            }
        };
        modifier = new ThreadLocal<Builder>(){

            @Override
            protected Builder initialValue() {
                return new Builder();
            }
        };
    }

    private static interface Special
    extends Comparable<Object> {
    }
}

