/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;

public class ThriftConversion {
    public static org.apache.cassandra.db.ConsistencyLevel fromThrift(ConsistencyLevel cl) {
        switch (cl) {
            case ANY: {
                return org.apache.cassandra.db.ConsistencyLevel.ANY;
            }
            case ONE: {
                return org.apache.cassandra.db.ConsistencyLevel.ONE;
            }
            case TWO: {
                return org.apache.cassandra.db.ConsistencyLevel.TWO;
            }
            case THREE: {
                return org.apache.cassandra.db.ConsistencyLevel.THREE;
            }
            case QUORUM: {
                return org.apache.cassandra.db.ConsistencyLevel.QUORUM;
            }
            case ALL: {
                return org.apache.cassandra.db.ConsistencyLevel.ALL;
            }
            case LOCAL_QUORUM: {
                return org.apache.cassandra.db.ConsistencyLevel.LOCAL_QUORUM;
            }
            case EACH_QUORUM: {
                return org.apache.cassandra.db.ConsistencyLevel.EACH_QUORUM;
            }
            case SERIAL: {
                return org.apache.cassandra.db.ConsistencyLevel.SERIAL;
            }
            case LOCAL_SERIAL: {
                return org.apache.cassandra.db.ConsistencyLevel.LOCAL_SERIAL;
            }
            case LOCAL_ONE: {
                return org.apache.cassandra.db.ConsistencyLevel.LOCAL_ONE;
            }
        }
        throw new AssertionError();
    }

    public static RuntimeException rethrow(RequestExecutionException e) throws UnavailableException, TimedOutException {
        if (e instanceof RequestTimeoutException) {
            throw ThriftConversion.toThrift((RequestTimeoutException)e);
        }
        throw new UnavailableException();
    }

    public static InvalidRequestException toThrift(RequestValidationException e) {
        return new InvalidRequestException(e.getMessage());
    }

    public static UnavailableException toThrift(org.apache.cassandra.exceptions.UnavailableException e) {
        return new UnavailableException();
    }

    public static AuthenticationException toThrift(org.apache.cassandra.exceptions.AuthenticationException e) {
        return new AuthenticationException(e.getMessage());
    }

    public static TimedOutException toThrift(RequestTimeoutException e) {
        TimedOutException toe = new TimedOutException();
        if (e instanceof WriteTimeoutException) {
            WriteTimeoutException wte = (WriteTimeoutException)e;
            toe.setAcknowledged_by(wte.received);
            if (wte.writeType == WriteType.BATCH_LOG) {
                toe.setAcknowledged_by_batchlog(false);
            } else if (wte.writeType == WriteType.BATCH) {
                toe.setAcknowledged_by_batchlog(true);
            } else if (wte.writeType == WriteType.CAS) {
                toe.setPaxos_in_progress(true);
            }
        }
        return toe;
    }

    public static List<org.apache.cassandra.db.IndexExpression> fromThrift(List<IndexExpression> exprs) {
        if (exprs == null) {
            return null;
        }
        if (exprs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<org.apache.cassandra.db.IndexExpression> converted = new ArrayList<org.apache.cassandra.db.IndexExpression>(exprs.size());
        for (IndexExpression expr : exprs) {
            converted.add(new org.apache.cassandra.db.IndexExpression(expr.column_name, IndexExpression.Operator.findByOrdinal(expr.op.getValue()), expr.value));
        }
        return converted;
    }
}

