/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Random;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);
    public final RepairJobDesc desc;
    public final InetAddress initiator;
    public final MerkleTree tree;
    public final int gcBefore;
    private transient long validated;
    private transient MerkleTree.TreeRange range;
    private transient MerkleTree.TreeRangeIterator ranges;
    private transient DecoratedKey lastKey;

    public Validator(RepairJobDesc desc, InetAddress initiator, int gcBefore) {
        this(desc, initiator, new MerkleTree(DatabaseDescriptor.getPartitioner(), desc.range, 126, (int)Math.pow(2.0, 15.0)), gcBefore);
    }

    public Validator(RepairJobDesc desc, InetAddress initiator, MerkleTree tree, int gcBefore) {
        this.desc = desc;
        this.initiator = initiator;
        this.tree = tree;
        this.gcBefore = gcBefore;
        this.validated = 0L;
        this.range = null;
        this.ranges = null;
    }

    public void prepare(ColumnFamilyStore cfs) {
        if (!this.tree.partitioner().preservesOrder()) {
            this.tree.init();
        } else {
            ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
            for (DecoratedKey sample : cfs.keySamples(this.desc.range)) {
                assert (this.desc.range.contains(sample.token)) : "Token " + sample.token + " is not within range " + this.desc.range;
                keys.add(sample);
            }
            if (keys.isEmpty()) {
                this.tree.init();
            } else {
                DecoratedKey dk;
                int numkeys = keys.size();
                Random random = new Random();
                do {
                    dk = (DecoratedKey)keys.get(random.nextInt(numkeys));
                } while (this.tree.split(dk.token));
            }
        }
        logger.debug("Prepared AEService tree of size {} for {}", (Object)this.tree.size(), (Object)this.desc);
        this.ranges = this.tree.invalids();
    }

    public void add(AbstractCompactedRow row) {
        assert (this.desc.range.contains(row.key.token)) : row.key.token + " is not contained in " + this.desc.range;
        assert (this.lastKey == null || this.lastKey.compareTo(row.key) < 0) : "row " + row.key + " received out of order wrt " + this.lastKey;
        this.lastKey = row.key;
        if (this.range == null) {
            this.range = (MerkleTree.TreeRange)this.ranges.next();
        }
        while (!this.range.contains(row.key.token)) {
            this.range.ensureHashInitialised();
            this.range = (MerkleTree.TreeRange)this.ranges.next();
        }
        this.range.addHash(this.rowHash(row));
    }

    private MerkleTree.RowHash rowHash(AbstractCompactedRow row) {
        ++this.validated;
        CountingDigest digest = new CountingDigest(FBUtilities.newMessageDigest("SHA-256"));
        row.update(digest);
        return new MerkleTree.RowHash(row.key.token, digest.digest(), digest.count);
    }

    public void complete() {
        this.completeTree();
        StageManager.getStage(Stage.ANTI_ENTROPY).execute(this);
        if (logger.isDebugEnabled()) {
            logger.debug("Validated {} partitions for {}.  Partitions per leaf are:", (Object)this.validated, (Object)this.desc.sessionId);
            this.tree.histogramOfRowCountPerLeaf().log(logger);
            logger.debug("Validated {} partitions for {}.  Partition sizes are:", (Object)this.validated, (Object)this.desc.sessionId);
            this.tree.histogramOfRowSizePerLeaf().log(logger);
        }
    }

    @VisibleForTesting
    public void completeTree() {
        assert (this.ranges != null) : "Validator was not prepared()";
        if (this.range != null) {
            this.range.ensureHashInitialised();
        }
        while (this.ranges.hasNext()) {
            this.range = (MerkleTree.TreeRange)this.ranges.next();
            this.range.ensureHashInitialised();
        }
    }

    public void fail() {
        logger.error("Failed creating a merkle tree for {}, {} (see log for details)", (Object)this.desc, (Object)this.initiator);
        MessagingService.instance().sendOneWay(new ValidationComplete(this.desc).createMessage(), this.initiator);
    }

    @Override
    public void run() {
        if (!this.initiator.equals(FBUtilities.getBroadcastAddress())) {
            logger.info(String.format("[repair #%s] Sending completed merkle tree to %s for %s/%s", this.desc.sessionId, this.initiator, this.desc.keyspace, this.desc.columnFamily));
        }
        MessagingService.instance().sendOneWay(new ValidationComplete(this.desc, this.tree).createMessage(), this.initiator);
    }

    static class CountingDigest
    extends MessageDigest {
        private long count;
        private MessageDigest underlying;

        public CountingDigest(MessageDigest underlying) {
            super(underlying.getAlgorithm());
            this.underlying = underlying;
        }

        @Override
        protected void engineUpdate(byte input) {
            this.underlying.update(input);
            ++this.count;
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            this.underlying.update(input, offset, len);
            this.count += (long)len;
        }

        @Override
        protected byte[] engineDigest() {
            return this.underlying.digest();
        }

        @Override
        protected void engineReset() {
            this.underlying.reset();
        }
    }
}

