/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.CLibrary;

public class SequentialWriter
extends OutputStream {
    protected boolean isDirty = false;
    protected boolean syncNeeded = false;
    private final String filePath;
    protected byte[] buffer;
    private final boolean skipIOCache;
    private final int fd;
    private final int directoryFD;
    private boolean directorySynced = false;
    protected long current = 0L;
    protected long bufferOffset;
    protected int validBufferBytes;
    protected final RandomAccessFile out;
    private long ioCacheStartOffset = 0L;
    private long bytesSinceCacheFlush = 0L;
    private boolean trickleFsync;
    private int trickleFsyncByteInterval;
    private int bytesSinceTrickleFsync = 0;
    public final DataOutputStream stream;
    private DataIntegrityMetadata.ChecksumWriter metadata;

    public SequentialWriter(File file, int bufferSize, boolean skipIOCache) {
        try {
            this.out = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.filePath = file.getAbsolutePath();
        this.buffer = new byte[bufferSize];
        this.skipIOCache = skipIOCache;
        this.trickleFsync = DatabaseDescriptor.getTrickleFsync();
        this.trickleFsyncByteInterval = DatabaseDescriptor.getTrickleFsyncIntervalInKb() * 1024;
        try {
            this.fd = CLibrary.getfd(this.out.getFD());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.directoryFD = CLibrary.tryOpenDirectory(file.getParent());
        this.stream = new DataOutputStream(this);
    }

    public static SequentialWriter open(File file) {
        return SequentialWriter.open(file, 65536, false);
    }

    public static SequentialWriter open(File file, boolean skipIOCache) {
        return SequentialWriter.open(file, 65536, skipIOCache);
    }

    public static SequentialWriter open(File file, int bufferSize, boolean skipIOCache) {
        return new SequentialWriter(file, bufferSize, skipIOCache);
    }

    @Override
    public void write(int value) throws ClosedChannelException {
        if (this.current >= this.bufferOffset + (long)this.buffer.length) {
            this.reBuffer();
        }
        assert (this.current < this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        this.buffer[this.bufferCursor()] = (byte)value;
        ++this.validBufferBytes;
        ++this.current;
        this.isDirty = true;
        this.syncNeeded = true;
    }

    @Override
    public void write(byte[] buffer) throws ClosedChannelException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws ClosedChannelException {
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        while (length > 0) {
            int n = this.writeAtMost(data, offset, length);
            offset += n;
            length -= n;
            this.isDirty = true;
            this.syncNeeded = true;
        }
    }

    private int writeAtMost(byte[] data, int offset, int length) {
        if (this.current >= this.bufferOffset + (long)this.buffer.length) {
            this.reBuffer();
        }
        assert (this.current < this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        int toCopy = Math.min(length, this.buffer.length - this.bufferCursor());
        System.arraycopy(data, offset, this.buffer, this.bufferCursor(), toCopy);
        assert (this.current <= this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        this.validBufferBytes = Math.max(this.validBufferBytes, this.bufferCursor() + toCopy);
        this.current += (long)toCopy;
        return toCopy;
    }

    public void sync() {
        this.syncInternal();
    }

    protected void syncDataOnlyInternal() {
        try {
            this.out.getFD().sync();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    protected void syncInternal() {
        if (this.syncNeeded) {
            this.flushInternal();
            this.syncDataOnlyInternal();
            if (!this.directorySynced) {
                CLibrary.trySync(this.directoryFD);
                this.directorySynced = true;
            }
            this.syncNeeded = false;
        }
    }

    @Override
    public void flush() {
        this.flushInternal();
    }

    protected void flushInternal() {
        if (this.isDirty) {
            this.flushData();
            if (this.trickleFsync) {
                this.bytesSinceTrickleFsync += this.validBufferBytes;
                if (this.bytesSinceTrickleFsync >= this.trickleFsyncByteInterval) {
                    this.syncDataOnlyInternal();
                    this.bytesSinceTrickleFsync = 0;
                }
            }
            if (this.skipIOCache) {
                this.bytesSinceCacheFlush += (long)this.validBufferBytes;
                if (this.bytesSinceCacheFlush >= RandomAccessReader.CACHE_FLUSH_INTERVAL_IN_BYTES) {
                    CLibrary.trySkipCache(this.fd, this.ioCacheStartOffset, 0);
                    this.ioCacheStartOffset = this.bufferOffset;
                    this.bytesSinceCacheFlush = 0L;
                }
            }
            this.resetBuffer();
            this.isDirty = false;
        }
    }

    protected void flushData() {
        try {
            this.out.write(this.buffer, 0, this.validBufferBytes);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        if (this.metadata != null) {
            this.metadata.append(this.buffer, 0, this.validBufferBytes);
        }
    }

    public long getFilePointer() {
        return this.current;
    }

    public long getOnDiskFilePointer() {
        return this.getFilePointer();
    }

    public long length() {
        try {
            return Math.max(Math.max(this.current, this.out.length()), this.bufferOffset + (long)this.validBufferBytes);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    public String getPath() {
        return this.filePath;
    }

    protected void reBuffer() {
        this.flushInternal();
        this.resetBuffer();
    }

    protected void resetBuffer() {
        this.bufferOffset = this.current;
        this.validBufferBytes = 0;
    }

    private int bufferCursor() {
        return (int)(this.current - this.bufferOffset);
    }

    public FileMark mark() {
        return new BufferedFileWriterMark(this.current);
    }

    public void resetAndTruncate(FileMark mark) {
        assert (mark instanceof BufferedFileWriterMark);
        long previous = this.current;
        this.current = ((BufferedFileWriterMark)mark).pointer;
        if (previous - this.current <= (long)this.validBufferBytes) {
            this.validBufferBytes -= (int)(previous - this.current);
            return;
        }
        this.syncInternal();
        this.truncate(this.current);
        try {
            this.out.seek(this.current);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
        this.resetBuffer();
    }

    public void truncate(long toSize) {
        try {
            this.out.getChannel().truncate(toSize);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.syncInternal();
        this.buffer = null;
        if (this.skipIOCache && this.bytesSinceCacheFlush > 0L) {
            CLibrary.trySkipCache(this.fd, 0L, 0);
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        FileUtils.closeQuietly(this.metadata);
        CLibrary.tryCloseFD(this.directoryFD);
    }

    public void setDataIntegrityWriter(DataIntegrityMetadata.ChecksumWriter writer) {
        if (this.current != 0L) {
            throw new IllegalStateException();
        }
        this.metadata = writer;
        this.metadata.writeChunkSize(this.buffer.length);
    }

    protected static class BufferedFileWriterMark
    implements FileMark {
        final long pointer;

        public BufferedFileWriterMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

