/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import java.util.zip.Checksum;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.PureJavaCrc32;

public class DataIntegrityMetadata {
    public static ChecksumValidator checksumValidator(Descriptor desc) throws IOException {
        return new ChecksumValidator(desc);
    }

    public static ChecksumWriter checksumWriter(Descriptor desc) {
        return new ChecksumWriter(desc);
    }

    public static class ChecksumWriter
    implements Closeable {
        private final Checksum checksum = new PureJavaCrc32();
        private final MessageDigest digest;
        private final SequentialWriter writer;
        private final Descriptor descriptor;

        public ChecksumWriter(Descriptor desc) {
            this.descriptor = desc;
            this.writer = SequentialWriter.open(new File(desc.filenameFor(Component.CRC)), true);
            try {
                this.digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        public void writeChunkSize(int length) {
            try {
                this.writer.stream.writeInt(length);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        public void append(byte[] buffer, int start, int end) {
            try {
                this.checksum.update(buffer, start, end);
                this.writer.stream.writeInt((int)this.checksum.getValue());
                this.checksum.reset();
                this.digest.update(buffer, start, end);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void close() {
            FileUtils.closeQuietly(this.writer);
            byte[] bytes = this.digest.digest();
            if (bytes == null) {
                return;
            }
            SequentialWriter out = SequentialWriter.open(new File(this.descriptor.filenameFor(Component.DIGEST)), true);
            Descriptor newdesc = this.descriptor.asTemporary(false);
            String[] tmp = newdesc.filenameFor(Component.DATA).split(Pattern.quote(File.separator));
            String dataFileName = tmp[tmp.length - 1];
            try {
                out.write(String.format("%s  %s", Hex.bytesToHex(bytes), dataFileName).getBytes());
            }
            catch (ClosedChannelException e) {
                throw new AssertionError();
            }
            finally {
                FileUtils.closeQuietly(out);
            }
        }
    }

    public static class ChecksumValidator
    implements Closeable {
        private final Checksum checksum = new PureJavaCrc32();
        private final RandomAccessReader reader;
        private final Descriptor descriptor;
        public final int chunkSize;

        public ChecksumValidator(Descriptor desc) throws IOException {
            this.descriptor = desc;
            this.reader = RandomAccessReader.open(new File(desc.filenameFor(Component.CRC)));
            this.chunkSize = this.reader.readInt();
        }

        public void seek(long offset) {
            long start = this.chunkStart(offset);
            this.reader.seek(start / (long)this.chunkSize * 4L + 4L);
        }

        public long chunkStart(long offset) {
            long startChunk = offset / (long)this.chunkSize;
            return startChunk * (long)this.chunkSize;
        }

        public void validate(byte[] bytes, int start, int end) throws IOException {
            this.checksum.update(bytes, start, end);
            int current = (int)this.checksum.getValue();
            this.checksum.reset();
            int actual = this.reader.readInt();
            if (current != actual) {
                throw new IOException("Corrupted SSTable : " + this.descriptor.filenameFor(Component.DATA));
            }
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }
}

