/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.TypeSerializer;

public class ListType<T>
extends CollectionType<List<T>> {
    private static final Map<AbstractType<?>, ListType> instances = new HashMap();
    public final AbstractType<T> elements;
    public final ListSerializer<T> serializer;

    public static ListType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("ListType takes exactly 1 type parameter");
        }
        return ListType.getInstance(l.get(0));
    }

    public static synchronized <T> ListType<T> getInstance(AbstractType<T> elements) {
        ListType<T> t = instances.get(elements);
        if (t == null) {
            t = new ListType<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    private ListType(AbstractType<T> elements) {
        super(CollectionType.Kind.LIST);
        this.elements = elements;
        this.serializer = ListSerializer.getInstance(elements.getSerializer());
    }

    @Override
    public AbstractType<UUID> nameComparator() {
        return TimeUUIDType.instance;
    }

    @Override
    public AbstractType<T> valueComparator() {
        return this.elements;
    }

    @Override
    public TypeSerializer<List<T>> getSerializer() {
        return this.serializer;
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements)));
    }

    @Override
    public ByteBuffer serialize(List<Cell> cells) {
        cells = this.enforceLimit(cells);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(cells.size());
        int size = 0;
        for (Cell c : cells) {
            bbs.add(c.value());
            size += 2 + c.value().remaining();
        }
        return ListType.pack(bbs, cells.size(), size);
    }
}

