/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositesSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(CompositesSearcher.class);

    public CompositesSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        super(indexManager, columns);
    }

    @Override
    public List<Row> search(ExtendedFilter filter) {
        assert (filter.getClause() != null && !filter.getClause().isEmpty());
        return this.baseCfs.filter(this.getIndexedIterator(filter), filter);
    }

    private Composite makePrefix(CompositesIndex index, ByteBuffer key, ExtendedFilter filter, boolean isStart) {
        Composite prefix;
        if (key.remaining() == 0) {
            return Composites.EMPTY;
        }
        IDiskAtomFilter columnFilter = filter.columnFilter(key);
        if (columnFilter instanceof SliceQueryFilter) {
            SliceQueryFilter sqf = (SliceQueryFilter)columnFilter;
            prefix = index.makeIndexColumnPrefix(key, isStart ? sqf.start() : sqf.finish());
        } else {
            prefix = index.getIndexComparator().make(key);
        }
        return isStart ? prefix.start() : prefix.end();
    }

    private ColumnFamilyStore.AbstractScanIterator getIndexedIterator(final ExtendedFilter filter) {
        final IndexExpression primary = this.highestSelectivityPredicate(filter.getClause());
        final CompositesIndex index = (CompositesIndex)this.indexManager.getIndexForColumn(primary.column);
        assert (index != null);
        assert (index.getIndexCfs() != null);
        final DecoratedKey indexKey = index.getIndexKeyFor(primary.value);
        if (logger.isDebugEnabled()) {
            logger.debug("Most-selective indexed predicate is {}", (Object)index.expressionString(primary));
        }
        final AbstractBounds<RowPosition> range = filter.dataRange.keyRange();
        ByteBuffer startKey = range.left instanceof DecoratedKey ? ((DecoratedKey)range.left).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        ByteBuffer endKey = range.right instanceof DecoratedKey ? ((DecoratedKey)range.right).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        final CellNameType baseComparator = this.baseCfs.getComparator();
        final CellNameType indexComparator = index.getIndexCfs().getComparator();
        final Composite startPrefix = this.makePrefix(index, startKey, filter, true);
        final Composite endPrefix = this.makePrefix(index, endKey, filter, false);
        return new ColumnFamilyStore.AbstractScanIterator(){
            private Composite lastSeenPrefix;
            private Deque<Cell> indexCells;
            private int columnsRead;
            private int limit;
            private int columnsCount;
            private int meanColumns;
            private int rowsPerQuery;
            {
                this.lastSeenPrefix = startPrefix;
                this.columnsRead = Integer.MAX_VALUE;
                this.limit = filter.currentLimit();
                this.columnsCount = 0;
                this.meanColumns = Math.max(index.getIndexCfs().getMeanColumns(), 1);
                this.rowsPerQuery = Math.max(Math.min(filter.maxRows(), filter.maxColumns() / this.meanColumns), 2);
            }

            @Override
            public boolean needsFiltering() {
                return false;
            }

            private Row makeReturn(DecoratedKey key, ColumnFamily data) {
                if (data == null) {
                    return (Row)this.endOfData();
                }
                assert (key != null);
                return new Row(key, data);
            }

            protected Row computeNext() {
                DecoratedKey currentKey = null;
                ColumnFamily data = null;
                Object previousPrefix = null;
                block0: while (this.columnsCount < this.limit) {
                    if (this.indexCells == null || this.indexCells.isEmpty()) {
                        if (this.columnsRead < this.rowsPerQuery) {
                            logger.trace("Read only {} (< {}) last page through, must be done", (Object)this.columnsRead, (Object)this.rowsPerQuery);
                            return this.makeReturn(currentKey, data);
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("Scanning index {} starting with {}", (Object)index.expressionString(primary), (Object)indexComparator.getString(startPrefix));
                        }
                        QueryFilter indexFilter = QueryFilter.getSliceFilter(indexKey, index.getIndexCfs().name, this.lastSeenPrefix, endPrefix, false, this.rowsPerQuery, filter.timestamp);
                        ColumnFamily indexRow = index.getIndexCfs().getColumnFamily(indexFilter);
                        if (indexRow == null || indexRow.getColumnCount() == 0) {
                            return this.makeReturn(currentKey, data);
                        }
                        Collection<Cell> sortedCells = indexRow.getSortedColumns();
                        this.columnsRead = sortedCells.size();
                        this.indexCells = new ArrayDeque<Cell>(sortedCells);
                        Cell firstCell = sortedCells.iterator().next();
                        if (this.lastSeenPrefix != startPrefix && this.lastSeenPrefix.equals(firstCell.name())) {
                            this.indexCells.poll();
                            logger.trace("Skipping {}", (Object)indexComparator.getString(firstCell.name()));
                        }
                    }
                    while (true) {
                        if (this.indexCells.isEmpty() || this.columnsCount > this.limit) continue block0;
                        Cell cell = this.indexCells.poll();
                        this.lastSeenPrefix = cell.name();
                        if (cell.isMarkedForDelete(filter.timestamp)) {
                            logger.trace("skipping {}", (Object)cell.name());
                            continue;
                        }
                        CompositesIndex.IndexedEntry entry = index.decodeEntry(indexKey, cell);
                        DecoratedKey dk = ((CompositesSearcher)CompositesSearcher.this).baseCfs.partitioner.decorateKey(entry.indexedKey);
                        if (currentKey == null) {
                            currentKey = dk;
                        } else if (!currentKey.equals(dk)) {
                            DecoratedKey previousKey = currentKey;
                            currentKey = dk;
                            this.indexCells.addFirst(cell);
                            if (data == null) continue;
                            return this.makeReturn(previousKey, data);
                        }
                        if (!range.contains(dk)) {
                            if (!((RowPosition)range.right).isMinimum(((CompositesSearcher)CompositesSearcher.this).baseCfs.partitioner) && ((RowPosition)range.right).compareTo(dk) < 0) {
                                logger.trace("Reached end of assigned scan range");
                                return (Row)this.endOfData();
                            }
                            logger.debug("Skipping entry {} before assigned scan range", (Object)dk.token);
                            continue;
                        }
                        Composite start = entry.indexedEntryPrefix;
                        if (!filter.columnFilter(dk.key).maySelectPrefix(baseComparator, start) || previousPrefix != null && previousPrefix.equals(start)) continue;
                        previousPrefix = null;
                        logger.trace("Adding index hit to current row for {}", (Object)indexComparator.getString(cell.name()));
                        SliceQueryFilter dataFilter = new SliceQueryFilter(start, entry.indexedEntryPrefix.end(), false, Integer.MAX_VALUE, ((CompositesSearcher)CompositesSearcher.this).baseCfs.metadata.clusteringColumns().size());
                        ColumnFamily newData = CompositesSearcher.this.baseCfs.getColumnFamily(new QueryFilter(dk, ((CompositesSearcher)CompositesSearcher.this).baseCfs.name, dataFilter, filter.timestamp));
                        if (newData == null || index.isStale(entry, newData, filter.timestamp)) {
                            index.delete(entry);
                            continue;
                        }
                        assert (newData != null) : "An entry with no data should have been considered stale";
                        if (entry.indexedEntryCollectionKey != null) {
                            previousPrefix = start;
                        }
                        if (!filter.isSatisfiedBy(dk, newData, entry.indexedEntryPrefix, entry.indexedEntryCollectionKey)) continue;
                        if (data == null) {
                            data = ArrayBackedSortedColumns.factory.create(((CompositesSearcher)CompositesSearcher.this).baseCfs.metadata);
                        }
                        data.addAll(newData);
                        this.columnsCount += dataFilter.lastCounted();
                    }
                    break;
                }
                return this.makeReturn(currentKey, data);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

