/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.AbstractCompoundCellNameType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundCType;
import org.apache.cassandra.db.composites.CompoundComposite;
import org.apache.cassandra.db.composites.CompoundSparseCellName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CompoundSparseCellNameType
extends AbstractCompoundCellNameType {
    private static final ColumnIdentifier rowMarkerId = new ColumnIdentifier(ByteBufferUtil.EMPTY_BYTE_BUFFER, UTF8Type.instance);
    private static final CellName rowMarkerNoPrefix = new CompoundSparseCellName(rowMarkerId);
    private final AbstractType<?> columnNameType;
    protected final Map<ByteBuffer, ColumnIdentifier> internedIds;

    public CompoundSparseCellNameType(List<AbstractType<?>> types) {
        this(types, UTF8Type.instance);
    }

    public CompoundSparseCellNameType(List<AbstractType<?>> types, AbstractType<?> columnNameType) {
        this(new CompoundCType(types), columnNameType);
    }

    private CompoundSparseCellNameType(CompoundCType clusteringType, AbstractType<?> columnNameType) {
        this(clusteringType, columnNameType, CompoundSparseCellNameType.makeCType(clusteringType, columnNameType, null), new HashMap<ByteBuffer, ColumnIdentifier>());
    }

    private CompoundSparseCellNameType(CompoundCType clusteringType, AbstractType<?> columnNameType, CompoundCType fullType, Map<ByteBuffer, ColumnIdentifier> internedIds) {
        super(clusteringType, fullType);
        this.columnNameType = columnNameType;
        this.internedIds = internedIds;
    }

    protected static CompoundCType makeCType(CompoundCType clusteringType, AbstractType<?> columnNameType, ColumnToCollectionType collectionType) {
        ArrayList allSubtypes = new ArrayList(clusteringType.size() + (collectionType == null ? 1 : 2));
        for (int i = 0; i < clusteringType.size(); ++i) {
            allSubtypes.add(clusteringType.subtype(i));
        }
        allSubtypes.add(columnNameType);
        if (collectionType != null) {
            allSubtypes.add(collectionType);
        }
        return new CompoundCType(allSubtypes);
    }

    @Override
    public CellNameType setSubtype(int position, AbstractType<?> newType) {
        if (position < this.clusteringSize) {
            return new CompoundSparseCellNameType((CompoundCType)this.clusteringType.setSubtype(position, (AbstractType)newType), this.columnNameType, (CompoundCType)this.fullType.setSubtype(position, (AbstractType)newType), this.internedIds);
        }
        if (position == this.clusteringSize) {
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CellNameType addCollection(ColumnIdentifier columnName, CollectionType newCollection) {
        return new WithCollection(this.clusteringType, ColumnToCollectionType.getInstance(Collections.singletonMap(columnName.bytes, newCollection)), this.internedIds);
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean supportCollections() {
        return true;
    }

    @Override
    public CellName create(Composite prefix, ColumnIdentifier columnName) {
        assert (prefix.size() == this.clusteringSize);
        if (prefix.isEmpty()) {
            return new CompoundSparseCellName(columnName);
        }
        assert (prefix instanceof CompoundComposite);
        CompoundComposite lc = (CompoundComposite)prefix;
        return new CompoundSparseCellName(lc.elements, this.clusteringSize, columnName);
    }

    @Override
    public CellName rowMarker(Composite prefix) {
        if (prefix.isEmpty()) {
            return rowMarkerNoPrefix;
        }
        return this.create(prefix, rowMarkerId);
    }

    protected ColumnIdentifier idFor(ByteBuffer bb) {
        ColumnIdentifier id = this.internedIds.get(bb);
        return id == null ? new ColumnIdentifier(bb, this.columnNameType) : id;
    }

    @Override
    protected Composite makeWith(ByteBuffer[] components, int size, Composite.EOC eoc) {
        if (size < this.clusteringSize + 1 || eoc != Composite.EOC.NONE) {
            return new CompoundComposite(components, size).withEOC(eoc);
        }
        return new CompoundSparseCellName(components, this.clusteringSize, this.idFor(components[this.clusteringSize]));
    }

    @Override
    protected Composite copyAndMakeWith(ByteBuffer[] components, int size, Composite.EOC eoc) {
        if (size < this.clusteringSize + 1 || eoc != Composite.EOC.NONE) {
            return new CompoundComposite(Arrays.copyOfRange(components, 0, size), size).withEOC(eoc);
        }
        ByteBuffer[] clusteringColumns = Arrays.copyOfRange(components, 0, this.clusteringSize);
        return new CompoundSparseCellName(clusteringColumns, this.idFor(components[this.clusteringSize]));
    }

    @Override
    public void addCQL3Column(ColumnIdentifier id) {
        this.internedIds.put(id.bytes, id);
    }

    @Override
    public void removeCQL3Column(ColumnIdentifier id) {
        this.internedIds.remove(id.bytes);
    }

    @Override
    public CQL3Row.Builder CQL3RowBuilder(long now) {
        return CompoundSparseCellNameType.makeSparseCQL3RowBuilder(now);
    }

    public static class WithCollection
    extends CompoundSparseCellNameType {
        private final ColumnToCollectionType collectionType;

        public WithCollection(List<AbstractType<?>> types, ColumnToCollectionType collectionType) {
            this(new CompoundCType(types), collectionType);
        }

        WithCollection(CompoundCType clusteringType, ColumnToCollectionType collectionType) {
            this(clusteringType, collectionType, new HashMap<ByteBuffer, ColumnIdentifier>());
        }

        private WithCollection(CompoundCType clusteringType, ColumnToCollectionType collectionType, Map<ByteBuffer, ColumnIdentifier> internedIds) {
            this(clusteringType, WithCollection.makeCType(clusteringType, UTF8Type.instance, collectionType), collectionType, internedIds);
        }

        private WithCollection(CompoundCType clusteringType, CompoundCType fullCType, ColumnToCollectionType collectionType, Map<ByteBuffer, ColumnIdentifier> internedIds) {
            super(clusteringType, UTF8Type.instance, fullCType, internedIds);
            this.collectionType = collectionType;
        }

        @Override
        public CellNameType setSubtype(int position, AbstractType<?> newType) {
            if (position < this.clusteringSize) {
                return new WithCollection((CompoundCType)this.clusteringType.setSubtype(position, (AbstractType)newType), this.collectionType, this.internedIds);
            }
            throw position >= this.fullType.size() ? new IndexOutOfBoundsException() : new IllegalArgumentException();
        }

        @Override
        public CellNameType addCollection(ColumnIdentifier columnName, CollectionType newCollection) {
            HashMap<ByteBuffer, CollectionType> newMap = new HashMap<ByteBuffer, CollectionType>(this.collectionType.defined);
            newMap.put(columnName.bytes, newCollection);
            return new WithCollection(this.clusteringType, ColumnToCollectionType.getInstance(newMap), this.internedIds);
        }

        @Override
        public CellName create(Composite prefix, ColumnIdentifier columnName, ByteBuffer collectionElement) {
            assert (prefix.size() == this.clusteringSize);
            if (prefix.isEmpty()) {
                return new CompoundSparseCellName.WithCollection(columnName, collectionElement);
            }
            assert (prefix instanceof CompoundComposite);
            CompoundComposite lc = (CompoundComposite)prefix;
            return new CompoundSparseCellName.WithCollection(lc.elements, this.clusteringSize, columnName, collectionElement);
        }

        @Override
        public boolean hasCollections() {
            return true;
        }

        @Override
        public ColumnToCollectionType collectionType() {
            return this.collectionType;
        }

        @Override
        protected Composite makeWith(ByteBuffer[] components, int size, Composite.EOC eoc) {
            if (size < this.fullSize) {
                return super.makeWith(components, size, eoc);
            }
            return new CompoundSparseCellName.WithCollection(components, this.clusteringSize, this.idFor(components[this.clusteringSize]), components[this.fullSize - 1]);
        }

        @Override
        protected Composite copyAndMakeWith(ByteBuffer[] components, int size, Composite.EOC eoc) {
            if (size < this.fullSize) {
                return super.copyAndMakeWith(components, size, eoc);
            }
            ByteBuffer[] clusteringColumns = Arrays.copyOfRange(components, 0, this.clusteringSize);
            return new CompoundSparseCellName.WithCollection(clusteringColumns, this.idFor(components[this.clusteringSize]), components[this.clusteringSize + 1]);
        }
    }
}

