/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.composites.AbstractCellNameType;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.SimpleCType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractSimpleCellNameType
extends AbstractCellNameType {
    protected final AbstractType<?> type;

    protected AbstractSimpleCellNameType(AbstractType<?> type) {
        this.type = type;
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AbstractType<?> subtype(int i) {
        if (i != 0) {
            throw new IllegalArgumentException();
        }
        return this.type;
    }

    @Override
    protected CellName makeCellName(ByteBuffer[] components) {
        assert (components.length == 1);
        return this.cellFromByteBuffer(components[0]);
    }

    @Override
    public CBuilder builder() {
        return new SimpleCType.SimpleCBuilder(this);
    }

    @Override
    public AbstractType<?> asAbstractType() {
        return this.type;
    }

    @Override
    public CellNameType.Deserializer newDeserializer(DataInput in) {
        return new SimpleDeserializer(this, in);
    }

    private static class SimpleDeserializer
    implements CellNameType.Deserializer {
        private final AbstractSimpleCellNameType type;
        private ByteBuffer next;
        private final DataInput in;

        public SimpleDeserializer(AbstractSimpleCellNameType type, DataInput in) {
            this.type = type;
            this.in = in;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.next == null) {
                this.maybeReadNext();
            }
            return this.next.hasRemaining();
        }

        @Override
        public boolean hasUnprocessed() throws IOException {
            return this.next != null;
        }

        @Override
        public int compareNextTo(Composite composite) throws IOException {
            this.maybeReadNext();
            if (composite.isEmpty()) {
                return this.next.hasRemaining() ? 1 : 0;
            }
            return this.type.subtype(0).compare(this.next, composite.get(0));
        }

        private void maybeReadNext() throws IOException {
            if (this.next != null) {
                return;
            }
            int length = this.in.readShort() & 0xFFFF;
            if (length == 0) {
                this.next = ByteBufferUtil.EMPTY_BYTE_BUFFER;
                return;
            }
            byte[] b = new byte[length];
            this.in.readFully(b);
            this.next = ByteBuffer.wrap(b);
        }

        @Override
        public Composite readNext() throws IOException {
            this.maybeReadNext();
            Composite c = this.type.fromByteBuffer(this.next);
            this.next = null;
            return c;
        }

        @Override
        public void skipNext() throws IOException {
            this.maybeReadNext();
            this.next = null;
        }
    }
}

