/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.composites.BoundedComposite;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractCompositeType;

public abstract class AbstractComposite
implements Composite {
    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Composite.EOC eoc() {
        return Composite.EOC.NONE;
    }

    @Override
    public Composite start() {
        return this.withEOC(Composite.EOC.START);
    }

    @Override
    public Composite end() {
        return this.withEOC(Composite.EOC.END);
    }

    @Override
    public Composite withEOC(Composite.EOC newEoc) {
        switch (newEoc) {
            case START: {
                return BoundedComposite.startOf(this);
            }
            case END: {
                return BoundedComposite.endOf(this);
            }
        }
        return this;
    }

    @Override
    public ColumnSlice slice() {
        return new ColumnSlice(this.start(), this.end());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer result = ByteBuffer.allocate(this.dataSize() + 3 * this.size());
        for (int i = 0; i < this.size(); ++i) {
            ByteBuffer bb = this.get(i);
            AbstractCompositeType.putShortLength(result, bb.remaining());
            result.put(bb.duplicate());
            result.put((byte)0);
        }
        result.flip();
        return result;
    }

    @Override
    public int dataSize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            size += this.get(i).remaining();
        }
        return size;
    }

    @Override
    public boolean isPrefixOf(Composite c) {
        if (this.size() > c.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(c.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Composite)) {
            return false;
        }
        Composite c = (Composite)o;
        if (this.size() != c.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(c.get(i))) continue;
            return false;
        }
        return this.eoc() == c.eoc();
    }

    public int hashCode() {
        int h = 31;
        for (int i = 0; i < this.size(); ++i) {
            h += this.get(i).hashCode();
        }
        return h + this.eoc().hashCode();
    }
}

