/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.io.IVersionedSerializer;

class ReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    ReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand command, DataOutput out, int version) throws IOException {
        out.writeByte(command.commandType.serializedValue);
        switch (command.commandType) {
            case GET_BY_NAMES: {
                SliceByNamesReadCommand.serializer.serialize(command, out, version);
                break;
            }
            case GET_SLICES: {
                SliceFromReadCommand.serializer.serialize(command, out, version);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public ReadCommand deserialize(DataInput in, int version) throws IOException {
        ReadCommand.Type msgType = ReadCommand.Type.fromSerializedValue(in.readByte());
        switch (msgType) {
            case GET_BY_NAMES: {
                return SliceByNamesReadCommand.serializer.deserialize(in, version);
            }
            case GET_SLICES: {
                return SliceFromReadCommand.serializer.deserialize(in, version);
            }
        }
        throw new AssertionError();
    }

    @Override
    public long serializedSize(ReadCommand command, int version) {
        switch (command.commandType) {
            case GET_BY_NAMES: {
                return 1L + SliceByNamesReadCommand.serializer.serializedSize(command, version);
            }
            case GET_SLICES: {
                return 1L + SliceFromReadCommand.serializer.serializedSize(command, version);
            }
        }
        throw new AssertionError();
    }
}

